<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Party StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Party
 * @subpackage Structs
 */
class Party extends AbstractStructBase
{
    /**
     * The AgentParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AgentParty
     */
    public $AgentParty;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The EndpointID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndpointID;
    /**
     * The IndustryClassificationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPartyIdentification
     */
    public $PartyIdentifications;
    /**
     * The PartyLegalEntity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPartyLegalEntity
     */
    public $PartyLegalEntity;
    /**
     * The PartyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartyName;
    /**
     * The PartyTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartyTax;
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The PhysicalLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Location
     */
    public $PhysicalLocation;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $PostalAddress;
    /**
     * The WebsiteURI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebsiteURI;
    /**
     * Constructor method for Party
     * @uses Party::setAgentParty()
     * @uses Party::setContact()
     * @uses Party::setEndpointID()
     * @uses Party::setIndustryClassificationCode()
     * @uses Party::setPartyIdentifications()
     * @uses Party::setPartyLegalEntity()
     * @uses Party::setPartyName()
     * @uses Party::setPartyTax()
     * @uses Party::setPerson()
     * @uses Party::setPhysicalLocation()
     * @uses Party::setPostalAddress()
     * @uses Party::setWebsiteURI()
     * @param \StructType\AgentParty $agentParty
     * @param \StructType\Contact $contact
     * @param string $endpointID
     * @param string $industryClassificationCode
     * @param \ArrayType\ArrayOfPartyIdentification $partyIdentifications
     * @param \ArrayType\ArrayOfPartyLegalEntity $partyLegalEntity
     * @param string $partyName
     * @param string $partyTax
     * @param \StructType\Person $person
     * @param \StructType\Location $physicalLocation
     * @param \StructType\Address $postalAddress
     * @param string $websiteURI
     */
    public function __construct(\StructType\AgentParty $agentParty = null, \StructType\Contact $contact = null, $endpointID = null, $industryClassificationCode = null, \ArrayType\ArrayOfPartyIdentification $partyIdentifications = null, \ArrayType\ArrayOfPartyLegalEntity $partyLegalEntity = null, $partyName = null, $partyTax = null, \StructType\Person $person = null, \StructType\Location $physicalLocation = null, \StructType\Address $postalAddress = null, $websiteURI = null)
    {
        $this
            ->setAgentParty($agentParty)
            ->setContact($contact)
            ->setEndpointID($endpointID)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentifications($partyIdentifications)
            ->setPartyLegalEntity($partyLegalEntity)
            ->setPartyName($partyName)
            ->setPartyTax($partyTax)
            ->setPerson($person)
            ->setPhysicalLocation($physicalLocation)
            ->setPostalAddress($postalAddress)
            ->setWebsiteURI($websiteURI);
    }
    /**
     * Get AgentParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AgentParty|null
     */
    public function getAgentParty()
    {
        return isset($this->AgentParty) ? $this->AgentParty : null;
    }
    /**
     * Set AgentParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AgentParty $agentParty
     * @return \StructType\Party
     */
    public function setAgentParty(\StructType\AgentParty $agentParty = null)
    {
        if (is_null($agentParty) || (is_array($agentParty) && empty($agentParty))) {
            unset($this->AgentParty);
        } else {
            $this->AgentParty = $agentParty;
        }
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\Party
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get EndpointID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndpointID()
    {
        return isset($this->EndpointID) ? $this->EndpointID : null;
    }
    /**
     * Set EndpointID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endpointID
     * @return \StructType\Party
     */
    public function setEndpointID($endpointID = null)
    {
        // validation for constraint: string
        if (!is_null($endpointID) && !is_string($endpointID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endpointID, true), gettype($endpointID)), __LINE__);
        }
        if (is_null($endpointID) || (is_array($endpointID) && empty($endpointID))) {
            unset($this->EndpointID);
        } else {
            $this->EndpointID = $endpointID;
        }
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndustryClassificationCode()
    {
        return isset($this->IndustryClassificationCode) ? $this->IndustryClassificationCode : null;
    }
    /**
     * Set IndustryClassificationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $industryClassificationCode
     * @return \StructType\Party
     */
    public function setIndustryClassificationCode($industryClassificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($industryClassificationCode) && !is_string($industryClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industryClassificationCode, true), gettype($industryClassificationCode)), __LINE__);
        }
        if (is_null($industryClassificationCode) || (is_array($industryClassificationCode) && empty($industryClassificationCode))) {
            unset($this->IndustryClassificationCode);
        } else {
            $this->IndustryClassificationCode = $industryClassificationCode;
        }
        return $this;
    }
    /**
     * Get PartyIdentifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPartyIdentification|null
     */
    public function getPartyIdentifications()
    {
        return isset($this->PartyIdentifications) ? $this->PartyIdentifications : null;
    }
    /**
     * Set PartyIdentifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPartyIdentification $partyIdentifications
     * @return \StructType\Party
     */
    public function setPartyIdentifications(\ArrayType\ArrayOfPartyIdentification $partyIdentifications = null)
    {
        if (is_null($partyIdentifications) || (is_array($partyIdentifications) && empty($partyIdentifications))) {
            unset($this->PartyIdentifications);
        } else {
            $this->PartyIdentifications = $partyIdentifications;
        }
        return $this;
    }
    /**
     * Get PartyLegalEntity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPartyLegalEntity|null
     */
    public function getPartyLegalEntity()
    {
        return isset($this->PartyLegalEntity) ? $this->PartyLegalEntity : null;
    }
    /**
     * Set PartyLegalEntity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPartyLegalEntity $partyLegalEntity
     * @return \StructType\Party
     */
    public function setPartyLegalEntity(\ArrayType\ArrayOfPartyLegalEntity $partyLegalEntity = null)
    {
        if (is_null($partyLegalEntity) || (is_array($partyLegalEntity) && empty($partyLegalEntity))) {
            unset($this->PartyLegalEntity);
        } else {
            $this->PartyLegalEntity = $partyLegalEntity;
        }
        return $this;
    }
    /**
     * Get PartyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyName()
    {
        return isset($this->PartyName) ? $this->PartyName : null;
    }
    /**
     * Set PartyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyName
     * @return \StructType\Party
     */
    public function setPartyName($partyName = null)
    {
        // validation for constraint: string
        if (!is_null($partyName) && !is_string($partyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyName, true), gettype($partyName)), __LINE__);
        }
        if (is_null($partyName) || (is_array($partyName) && empty($partyName))) {
            unset($this->PartyName);
        } else {
            $this->PartyName = $partyName;
        }
        return $this;
    }
    /**
     * Get PartyTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyTax()
    {
        return isset($this->PartyTax) ? $this->PartyTax : null;
    }
    /**
     * Set PartyTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyTax
     * @return \StructType\Party
     */
    public function setPartyTax($partyTax = null)
    {
        // validation for constraint: string
        if (!is_null($partyTax) && !is_string($partyTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyTax, true), gettype($partyTax)), __LINE__);
        }
        if (is_null($partyTax) || (is_array($partyTax) && empty($partyTax))) {
            unset($this->PartyTax);
        } else {
            $this->PartyTax = $partyTax;
        }
        return $this;
    }
    /**
     * Get Person value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return isset($this->Person) ? $this->Person : null;
    }
    /**
     * Set Person value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $person
     * @return \StructType\Party
     */
    public function setPerson(\StructType\Person $person = null)
    {
        if (is_null($person) || (is_array($person) && empty($person))) {
            unset($this->Person);
        } else {
            $this->Person = $person;
        }
        return $this;
    }
    /**
     * Get PhysicalLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Location|null
     */
    public function getPhysicalLocation()
    {
        return isset($this->PhysicalLocation) ? $this->PhysicalLocation : null;
    }
    /**
     * Set PhysicalLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Location $physicalLocation
     * @return \StructType\Party
     */
    public function setPhysicalLocation(\StructType\Location $physicalLocation = null)
    {
        if (is_null($physicalLocation) || (is_array($physicalLocation) && empty($physicalLocation))) {
            unset($this->PhysicalLocation);
        } else {
            $this->PhysicalLocation = $physicalLocation;
        }
        return $this;
    }
    /**
     * Get PostalAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getPostalAddress()
    {
        return isset($this->PostalAddress) ? $this->PostalAddress : null;
    }
    /**
     * Set PostalAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $postalAddress
     * @return \StructType\Party
     */
    public function setPostalAddress(\StructType\Address $postalAddress = null)
    {
        if (is_null($postalAddress) || (is_array($postalAddress) && empty($postalAddress))) {
            unset($this->PostalAddress);
        } else {
            $this->PostalAddress = $postalAddress;
        }
        return $this;
    }
    /**
     * Get WebsiteURI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsiteURI()
    {
        return isset($this->WebsiteURI) ? $this->WebsiteURI : null;
    }
    /**
     * Set WebsiteURI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $websiteURI
     * @return \StructType\Party
     */
    public function setWebsiteURI($websiteURI = null)
    {
        // validation for constraint: string
        if (!is_null($websiteURI) && !is_string($websiteURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($websiteURI, true), gettype($websiteURI)), __LINE__);
        }
        if (is_null($websiteURI) || (is_array($websiteURI) && empty($websiteURI))) {
            unset($this->WebsiteURI);
        } else {
            $this->WebsiteURI = $websiteURI;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Party
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
