<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Package StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Package
 * @subpackage Structs
 */
class Package extends AbstractStructBase
{
    /**
     * The ContainedPackage
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfContainedPackage
     */
    public $ContainedPackage;
    /**
     * The GoodsItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfGoodsItem
     */
    public $GoodsItem;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The MeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDimension
     */
    public $MeasurementDimension;
    /**
     * The PackageLevelCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackageLevelCode;
    /**
     * The PackagingMaterial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $PackagingMaterial;
    /**
     * The PackagingTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackagingTypeCode;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Quantity;
    /**
     * The ReturnableMaterialIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ReturnableMaterialIndicator;
    /**
     * Constructor method for Package
     * @uses Package::setContainedPackage()
     * @uses Package::setGoodsItem()
     * @uses Package::setID()
     * @uses Package::setMeasurementDimension()
     * @uses Package::setPackageLevelCode()
     * @uses Package::setPackagingMaterial()
     * @uses Package::setPackagingTypeCode()
     * @uses Package::setQuantity()
     * @uses Package::setReturnableMaterialIndicator()
     * @param \ArrayType\ArrayOfContainedPackage $containedPackage
     * @param \ArrayType\ArrayOfGoodsItem $goodsItem
     * @param string $iD
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @param string $packageLevelCode
     * @param \ArrayType\ArrayOfstring $packagingMaterial
     * @param string $packagingTypeCode
     * @param float $quantity
     * @param bool $returnableMaterialIndicator
     */
    public function __construct(\ArrayType\ArrayOfContainedPackage $containedPackage = null, \ArrayType\ArrayOfGoodsItem $goodsItem = null, $iD = null, \ArrayType\ArrayOfDimension $measurementDimension = null, $packageLevelCode = null, \ArrayType\ArrayOfstring $packagingMaterial = null, $packagingTypeCode = null, $quantity = null, $returnableMaterialIndicator = null)
    {
        $this
            ->setContainedPackage($containedPackage)
            ->setGoodsItem($goodsItem)
            ->setID($iD)
            ->setMeasurementDimension($measurementDimension)
            ->setPackageLevelCode($packageLevelCode)
            ->setPackagingMaterial($packagingMaterial)
            ->setPackagingTypeCode($packagingTypeCode)
            ->setQuantity($quantity)
            ->setReturnableMaterialIndicator($returnableMaterialIndicator);
    }
    /**
     * Get ContainedPackage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfContainedPackage|null
     */
    public function getContainedPackage()
    {
        return isset($this->ContainedPackage) ? $this->ContainedPackage : null;
    }
    /**
     * Set ContainedPackage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfContainedPackage $containedPackage
     * @return \StructType\Package
     */
    public function setContainedPackage(\ArrayType\ArrayOfContainedPackage $containedPackage = null)
    {
        if (is_null($containedPackage) || (is_array($containedPackage) && empty($containedPackage))) {
            unset($this->ContainedPackage);
        } else {
            $this->ContainedPackage = $containedPackage;
        }
        return $this;
    }
    /**
     * Get GoodsItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfGoodsItem|null
     */
    public function getGoodsItem()
    {
        return isset($this->GoodsItem) ? $this->GoodsItem : null;
    }
    /**
     * Set GoodsItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfGoodsItem $goodsItem
     * @return \StructType\Package
     */
    public function setGoodsItem(\ArrayType\ArrayOfGoodsItem $goodsItem = null)
    {
        if (is_null($goodsItem) || (is_array($goodsItem) && empty($goodsItem))) {
            unset($this->GoodsItem);
        } else {
            $this->GoodsItem = $goodsItem;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Package
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDimension|null
     */
    public function getMeasurementDimension()
    {
        return isset($this->MeasurementDimension) ? $this->MeasurementDimension : null;
    }
    /**
     * Set MeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @return \StructType\Package
     */
    public function setMeasurementDimension(\ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        if (is_null($measurementDimension) || (is_array($measurementDimension) && empty($measurementDimension))) {
            unset($this->MeasurementDimension);
        } else {
            $this->MeasurementDimension = $measurementDimension;
        }
        return $this;
    }
    /**
     * Get PackageLevelCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageLevelCode()
    {
        return isset($this->PackageLevelCode) ? $this->PackageLevelCode : null;
    }
    /**
     * Set PackageLevelCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageLevelCode
     * @return \StructType\Package
     */
    public function setPackageLevelCode($packageLevelCode = null)
    {
        // validation for constraint: string
        if (!is_null($packageLevelCode) && !is_string($packageLevelCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageLevelCode, true), gettype($packageLevelCode)), __LINE__);
        }
        if (is_null($packageLevelCode) || (is_array($packageLevelCode) && empty($packageLevelCode))) {
            unset($this->PackageLevelCode);
        } else {
            $this->PackageLevelCode = $packageLevelCode;
        }
        return $this;
    }
    /**
     * Get PackagingMaterial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getPackagingMaterial()
    {
        return isset($this->PackagingMaterial) ? $this->PackagingMaterial : null;
    }
    /**
     * Set PackagingMaterial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $packagingMaterial
     * @return \StructType\Package
     */
    public function setPackagingMaterial(\ArrayType\ArrayOfstring $packagingMaterial = null)
    {
        if (is_null($packagingMaterial) || (is_array($packagingMaterial) && empty($packagingMaterial))) {
            unset($this->PackagingMaterial);
        } else {
            $this->PackagingMaterial = $packagingMaterial;
        }
        return $this;
    }
    /**
     * Get PackagingTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackagingTypeCode()
    {
        return isset($this->PackagingTypeCode) ? $this->PackagingTypeCode : null;
    }
    /**
     * Set PackagingTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packagingTypeCode
     * @return \StructType\Package
     */
    public function setPackagingTypeCode($packagingTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($packagingTypeCode) && !is_string($packagingTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagingTypeCode, true), gettype($packagingTypeCode)), __LINE__);
        }
        if (is_null($packagingTypeCode) || (is_array($packagingTypeCode) && empty($packagingTypeCode))) {
            unset($this->PackagingTypeCode);
        } else {
            $this->PackagingTypeCode = $packagingTypeCode;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Package
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get ReturnableMaterialIndicator value
     * @return bool|null
     */
    public function getReturnableMaterialIndicator()
    {
        return $this->ReturnableMaterialIndicator;
    }
    /**
     * Set ReturnableMaterialIndicator value
     * @param bool $returnableMaterialIndicator
     * @return \StructType\Package
     */
    public function setReturnableMaterialIndicator($returnableMaterialIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnableMaterialIndicator) && !is_bool($returnableMaterialIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnableMaterialIndicator, true), gettype($returnableMaterialIndicator)), __LINE__);
        }
        $this->ReturnableMaterialIndicator = $returnableMaterialIndicator;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Package
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
