<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OutgoingInvoiceHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OutgoingInvoiceHeader
 * @subpackage Structs
 */
class OutgoingInvoiceHeader extends AbstractStructBase
{
    /**
     * The ExternalDepartmentId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalDepartmentId;
    /**
     * The InvoiceLabels
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $InvoiceLabels;
    /**
     * The InvoiceMailList
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $InvoiceMailList;
    /**
     * The InvoiceMembershipType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceMembershipType;
    /**
     * The InvoiceNumberPrefix
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceNumberPrefix;
    /**
     * The InvoiceSaleType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceSaleType;
    /**
     * The InvoiceSendType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceSendType;
    /**
     * The InvoiceTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceTypeCode;
    /**
     * The IsDraft
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsDraft;
    /**
     * The IsOverrideWithRetry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOverrideWithRetry;
    /**
     * The IsWayBill
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsWayBill;
    /**
     * The OnlineSaleInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OnlineSaleInfo
     */
    public $OnlineSaleInfo;
    /**
     * The OperationSourceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OperationSourceCode;
    /**
     * The PaymentRecorederInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentRecorderInfo
     */
    public $PaymentRecorederInfo;
    /**
     * The ReceiverAlias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverAlias;
    /**
     * The ReceiverIdentityNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverIdentityNumber;
    /**
     * The SenderAlias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAlias;
    /**
     * The SmsConfigurationInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SmsConfigurationInfo
     */
    public $SmsConfigurationInfo;
    /**
     * The TrackNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackNumber;
    /**
     * Constructor method for OutgoingInvoiceHeader
     * @uses OutgoingInvoiceHeader::setExternalDepartmentId()
     * @uses OutgoingInvoiceHeader::setInvoiceLabels()
     * @uses OutgoingInvoiceHeader::setInvoiceMailList()
     * @uses OutgoingInvoiceHeader::setInvoiceMembershipType()
     * @uses OutgoingInvoiceHeader::setInvoiceNumberPrefix()
     * @uses OutgoingInvoiceHeader::setInvoiceSaleType()
     * @uses OutgoingInvoiceHeader::setInvoiceSendType()
     * @uses OutgoingInvoiceHeader::setInvoiceTypeCode()
     * @uses OutgoingInvoiceHeader::setIsDraft()
     * @uses OutgoingInvoiceHeader::setIsOverrideWithRetry()
     * @uses OutgoingInvoiceHeader::setIsWayBill()
     * @uses OutgoingInvoiceHeader::setOnlineSaleInfo()
     * @uses OutgoingInvoiceHeader::setOperationSourceCode()
     * @uses OutgoingInvoiceHeader::setPaymentRecorederInfo()
     * @uses OutgoingInvoiceHeader::setReceiverAlias()
     * @uses OutgoingInvoiceHeader::setReceiverIdentityNumber()
     * @uses OutgoingInvoiceHeader::setSenderAlias()
     * @uses OutgoingInvoiceHeader::setSmsConfigurationInfo()
     * @uses OutgoingInvoiceHeader::setTrackNumber()
     * @param string $externalDepartmentId
     * @param \ArrayType\ArrayOfstring $invoiceLabels
     * @param \ArrayType\ArrayOfstring $invoiceMailList
     * @param int $invoiceMembershipType
     * @param string $invoiceNumberPrefix
     * @param int $invoiceSaleType
     * @param int $invoiceSendType
     * @param int $invoiceTypeCode
     * @param bool $isDraft
     * @param bool $isOverrideWithRetry
     * @param bool $isWayBill
     * @param \StructType\OnlineSaleInfo $onlineSaleInfo
     * @param int $operationSourceCode
     * @param \StructType\PaymentRecorderInfo $paymentRecorederInfo
     * @param string $receiverAlias
     * @param string $receiverIdentityNumber
     * @param string $senderAlias
     * @param \StructType\SmsConfigurationInfo $smsConfigurationInfo
     * @param string $trackNumber
     */
    public function __construct($externalDepartmentId = null, \ArrayType\ArrayOfstring $invoiceLabels = null, \ArrayType\ArrayOfstring $invoiceMailList = null, $invoiceMembershipType = null, $invoiceNumberPrefix = null, $invoiceSaleType = null, $invoiceSendType = null, $invoiceTypeCode = null, $isDraft = null, $isOverrideWithRetry = null, $isWayBill = null, \StructType\OnlineSaleInfo $onlineSaleInfo = null, $operationSourceCode = null, \StructType\PaymentRecorderInfo $paymentRecorederInfo = null, $receiverAlias = null, $receiverIdentityNumber = null, $senderAlias = null, \StructType\SmsConfigurationInfo $smsConfigurationInfo = null, $trackNumber = null)
    {
        $this
            ->setExternalDepartmentId($externalDepartmentId)
            ->setInvoiceLabels($invoiceLabels)
            ->setInvoiceMailList($invoiceMailList)
            ->setInvoiceMembershipType($invoiceMembershipType)
            ->setInvoiceNumberPrefix($invoiceNumberPrefix)
            ->setInvoiceSaleType($invoiceSaleType)
            ->setInvoiceSendType($invoiceSendType)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setIsDraft($isDraft)
            ->setIsOverrideWithRetry($isOverrideWithRetry)
            ->setIsWayBill($isWayBill)
            ->setOnlineSaleInfo($onlineSaleInfo)
            ->setOperationSourceCode($operationSourceCode)
            ->setPaymentRecorederInfo($paymentRecorederInfo)
            ->setReceiverAlias($receiverAlias)
            ->setReceiverIdentityNumber($receiverIdentityNumber)
            ->setSenderAlias($senderAlias)
            ->setSmsConfigurationInfo($smsConfigurationInfo)
            ->setTrackNumber($trackNumber);
    }
    /**
     * Get ExternalDepartmentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalDepartmentId()
    {
        return isset($this->ExternalDepartmentId) ? $this->ExternalDepartmentId : null;
    }
    /**
     * Set ExternalDepartmentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalDepartmentId
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setExternalDepartmentId($externalDepartmentId = null)
    {
        // validation for constraint: string
        if (!is_null($externalDepartmentId) && !is_string($externalDepartmentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalDepartmentId, true), gettype($externalDepartmentId)), __LINE__);
        }
        if (is_null($externalDepartmentId) || (is_array($externalDepartmentId) && empty($externalDepartmentId))) {
            unset($this->ExternalDepartmentId);
        } else {
            $this->ExternalDepartmentId = $externalDepartmentId;
        }
        return $this;
    }
    /**
     * Get InvoiceLabels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getInvoiceLabels()
    {
        return isset($this->InvoiceLabels) ? $this->InvoiceLabels : null;
    }
    /**
     * Set InvoiceLabels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $invoiceLabels
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceLabels(\ArrayType\ArrayOfstring $invoiceLabels = null)
    {
        if (is_null($invoiceLabels) || (is_array($invoiceLabels) && empty($invoiceLabels))) {
            unset($this->InvoiceLabels);
        } else {
            $this->InvoiceLabels = $invoiceLabels;
        }
        return $this;
    }
    /**
     * Get InvoiceMailList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getInvoiceMailList()
    {
        return isset($this->InvoiceMailList) ? $this->InvoiceMailList : null;
    }
    /**
     * Set InvoiceMailList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $invoiceMailList
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceMailList(\ArrayType\ArrayOfstring $invoiceMailList = null)
    {
        if (is_null($invoiceMailList) || (is_array($invoiceMailList) && empty($invoiceMailList))) {
            unset($this->InvoiceMailList);
        } else {
            $this->InvoiceMailList = $invoiceMailList;
        }
        return $this;
    }
    /**
     * Get InvoiceMembershipType value
     * @return int|null
     */
    public function getInvoiceMembershipType()
    {
        return $this->InvoiceMembershipType;
    }
    /**
     * Set InvoiceMembershipType value
     * @param int $invoiceMembershipType
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceMembershipType($invoiceMembershipType = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceMembershipType) && !(is_int($invoiceMembershipType) || ctype_digit($invoiceMembershipType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceMembershipType, true), gettype($invoiceMembershipType)), __LINE__);
        }
        $this->InvoiceMembershipType = $invoiceMembershipType;
        return $this;
    }
    /**
     * Get InvoiceNumberPrefix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceNumberPrefix()
    {
        return isset($this->InvoiceNumberPrefix) ? $this->InvoiceNumberPrefix : null;
    }
    /**
     * Set InvoiceNumberPrefix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceNumberPrefix
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceNumberPrefix($invoiceNumberPrefix = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumberPrefix) && !is_string($invoiceNumberPrefix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumberPrefix, true), gettype($invoiceNumberPrefix)), __LINE__);
        }
        if (is_null($invoiceNumberPrefix) || (is_array($invoiceNumberPrefix) && empty($invoiceNumberPrefix))) {
            unset($this->InvoiceNumberPrefix);
        } else {
            $this->InvoiceNumberPrefix = $invoiceNumberPrefix;
        }
        return $this;
    }
    /**
     * Get InvoiceSaleType value
     * @return int|null
     */
    public function getInvoiceSaleType()
    {
        return $this->InvoiceSaleType;
    }
    /**
     * Set InvoiceSaleType value
     * @param int $invoiceSaleType
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceSaleType($invoiceSaleType = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceSaleType) && !(is_int($invoiceSaleType) || ctype_digit($invoiceSaleType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceSaleType, true), gettype($invoiceSaleType)), __LINE__);
        }
        $this->InvoiceSaleType = $invoiceSaleType;
        return $this;
    }
    /**
     * Get InvoiceSendType value
     * @return int|null
     */
    public function getInvoiceSendType()
    {
        return $this->InvoiceSendType;
    }
    /**
     * Set InvoiceSendType value
     * @param int $invoiceSendType
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceSendType($invoiceSendType = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceSendType) && !(is_int($invoiceSendType) || ctype_digit($invoiceSendType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceSendType, true), gettype($invoiceSendType)), __LINE__);
        }
        $this->InvoiceSendType = $invoiceSendType;
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return int|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param int $invoiceTypeCode
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setInvoiceTypeCode($invoiceTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceTypeCode) && !(is_int($invoiceTypeCode) || ctype_digit($invoiceTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceTypeCode, true), gettype($invoiceTypeCode)), __LINE__);
        }
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get IsDraft value
     * @return bool|null
     */
    public function getIsDraft()
    {
        return $this->IsDraft;
    }
    /**
     * Set IsDraft value
     * @param bool $isDraft
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setIsDraft($isDraft = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDraft) && !is_bool($isDraft)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDraft, true), gettype($isDraft)), __LINE__);
        }
        $this->IsDraft = $isDraft;
        return $this;
    }
    /**
     * Get IsOverrideWithRetry value
     * @return bool|null
     */
    public function getIsOverrideWithRetry()
    {
        return $this->IsOverrideWithRetry;
    }
    /**
     * Set IsOverrideWithRetry value
     * @param bool $isOverrideWithRetry
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setIsOverrideWithRetry($isOverrideWithRetry = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOverrideWithRetry) && !is_bool($isOverrideWithRetry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOverrideWithRetry, true), gettype($isOverrideWithRetry)), __LINE__);
        }
        $this->IsOverrideWithRetry = $isOverrideWithRetry;
        return $this;
    }
    /**
     * Get IsWayBill value
     * @return bool|null
     */
    public function getIsWayBill()
    {
        return $this->IsWayBill;
    }
    /**
     * Set IsWayBill value
     * @param bool $isWayBill
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setIsWayBill($isWayBill = null)
    {
        // validation for constraint: boolean
        if (!is_null($isWayBill) && !is_bool($isWayBill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isWayBill, true), gettype($isWayBill)), __LINE__);
        }
        $this->IsWayBill = $isWayBill;
        return $this;
    }
    /**
     * Get OnlineSaleInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OnlineSaleInfo|null
     */
    public function getOnlineSaleInfo()
    {
        return isset($this->OnlineSaleInfo) ? $this->OnlineSaleInfo : null;
    }
    /**
     * Set OnlineSaleInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OnlineSaleInfo $onlineSaleInfo
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setOnlineSaleInfo(\StructType\OnlineSaleInfo $onlineSaleInfo = null)
    {
        if (is_null($onlineSaleInfo) || (is_array($onlineSaleInfo) && empty($onlineSaleInfo))) {
            unset($this->OnlineSaleInfo);
        } else {
            $this->OnlineSaleInfo = $onlineSaleInfo;
        }
        return $this;
    }
    /**
     * Get OperationSourceCode value
     * @return int|null
     */
    public function getOperationSourceCode()
    {
        return $this->OperationSourceCode;
    }
    /**
     * Set OperationSourceCode value
     * @param int $operationSourceCode
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setOperationSourceCode($operationSourceCode = null)
    {
        // validation for constraint: int
        if (!is_null($operationSourceCode) && !(is_int($operationSourceCode) || ctype_digit($operationSourceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($operationSourceCode, true), gettype($operationSourceCode)), __LINE__);
        }
        $this->OperationSourceCode = $operationSourceCode;
        return $this;
    }
    /**
     * Get PaymentRecorederInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentRecorderInfo|null
     */
    public function getPaymentRecorederInfo()
    {
        return isset($this->PaymentRecorederInfo) ? $this->PaymentRecorederInfo : null;
    }
    /**
     * Set PaymentRecorederInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PaymentRecorderInfo $paymentRecorederInfo
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setPaymentRecorederInfo(\StructType\PaymentRecorderInfo $paymentRecorederInfo = null)
    {
        if (is_null($paymentRecorederInfo) || (is_array($paymentRecorederInfo) && empty($paymentRecorederInfo))) {
            unset($this->PaymentRecorederInfo);
        } else {
            $this->PaymentRecorederInfo = $paymentRecorederInfo;
        }
        return $this;
    }
    /**
     * Get ReceiverAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverAlias()
    {
        return isset($this->ReceiverAlias) ? $this->ReceiverAlias : null;
    }
    /**
     * Set ReceiverAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverAlias
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setReceiverAlias($receiverAlias = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAlias) && !is_string($receiverAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAlias, true), gettype($receiverAlias)), __LINE__);
        }
        if (is_null($receiverAlias) || (is_array($receiverAlias) && empty($receiverAlias))) {
            unset($this->ReceiverAlias);
        } else {
            $this->ReceiverAlias = $receiverAlias;
        }
        return $this;
    }
    /**
     * Get ReceiverIdentityNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverIdentityNumber()
    {
        return isset($this->ReceiverIdentityNumber) ? $this->ReceiverIdentityNumber : null;
    }
    /**
     * Set ReceiverIdentityNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverIdentityNumber
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setReceiverIdentityNumber($receiverIdentityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($receiverIdentityNumber) && !is_string($receiverIdentityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverIdentityNumber, true), gettype($receiverIdentityNumber)), __LINE__);
        }
        if (is_null($receiverIdentityNumber) || (is_array($receiverIdentityNumber) && empty($receiverIdentityNumber))) {
            unset($this->ReceiverIdentityNumber);
        } else {
            $this->ReceiverIdentityNumber = $receiverIdentityNumber;
        }
        return $this;
    }
    /**
     * Get SenderAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAlias()
    {
        return isset($this->SenderAlias) ? $this->SenderAlias : null;
    }
    /**
     * Set SenderAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAlias
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setSenderAlias($senderAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderAlias) && !is_string($senderAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAlias, true), gettype($senderAlias)), __LINE__);
        }
        if (is_null($senderAlias) || (is_array($senderAlias) && empty($senderAlias))) {
            unset($this->SenderAlias);
        } else {
            $this->SenderAlias = $senderAlias;
        }
        return $this;
    }
    /**
     * Get SmsConfigurationInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SmsConfigurationInfo|null
     */
    public function getSmsConfigurationInfo()
    {
        return isset($this->SmsConfigurationInfo) ? $this->SmsConfigurationInfo : null;
    }
    /**
     * Set SmsConfigurationInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SmsConfigurationInfo $smsConfigurationInfo
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setSmsConfigurationInfo(\StructType\SmsConfigurationInfo $smsConfigurationInfo = null)
    {
        if (is_null($smsConfigurationInfo) || (is_array($smsConfigurationInfo) && empty($smsConfigurationInfo))) {
            unset($this->SmsConfigurationInfo);
        } else {
            $this->SmsConfigurationInfo = $smsConfigurationInfo;
        }
        return $this;
    }
    /**
     * Get TrackNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackNumber()
    {
        return isset($this->TrackNumber) ? $this->TrackNumber : null;
    }
    /**
     * Set TrackNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackNumber
     * @return \StructType\OutgoingInvoiceHeader
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackNumber) && !is_string($trackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackNumber, true), gettype($trackNumber)), __LINE__);
        }
        if (is_null($trackNumber) || (is_array($trackNumber) && empty($trackNumber))) {
            unset($this->TrackNumber);
        } else {
            $this->TrackNumber = $trackNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OutgoingInvoiceHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
