<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderReference
 * @subpackage Structs
 */
class OrderReference extends AbstractStructBase
{
    /**
     * The DocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $DocumentReference;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The OrderTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrderTypeCode;
    /**
     * The SalesOrderID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesOrderID;
    /**
     * Constructor method for OrderReference
     * @uses OrderReference::setDocumentReference()
     * @uses OrderReference::setID()
     * @uses OrderReference::setIssueDate()
     * @uses OrderReference::setOrderTypeCode()
     * @uses OrderReference::setSalesOrderID()
     * @param \ArrayType\ArrayOfDocumentReference $documentReference
     * @param string $iD
     * @param string $issueDate
     * @param string $orderTypeCode
     * @param string $salesOrderID
     */
    public function __construct(\ArrayType\ArrayOfDocumentReference $documentReference = null, $iD = null, $issueDate = null, $orderTypeCode = null, $salesOrderID = null)
    {
        $this
            ->setDocumentReference($documentReference)
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setOrderTypeCode($orderTypeCode)
            ->setSalesOrderID($salesOrderID);
    }
    /**
     * Get DocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getDocumentReference()
    {
        return isset($this->DocumentReference) ? $this->DocumentReference : null;
    }
    /**
     * Set DocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $documentReference
     * @return \StructType\OrderReference
     */
    public function setDocumentReference(\ArrayType\ArrayOfDocumentReference $documentReference = null)
    {
        if (is_null($documentReference) || (is_array($documentReference) && empty($documentReference))) {
            unset($this->DocumentReference);
        } else {
            $this->DocumentReference = $documentReference;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\OrderReference
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\OrderReference
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get OrderTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrderTypeCode()
    {
        return isset($this->OrderTypeCode) ? $this->OrderTypeCode : null;
    }
    /**
     * Set OrderTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $orderTypeCode
     * @return \StructType\OrderReference
     */
    public function setOrderTypeCode($orderTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderTypeCode) && !is_string($orderTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderTypeCode, true), gettype($orderTypeCode)), __LINE__);
        }
        if (is_null($orderTypeCode) || (is_array($orderTypeCode) && empty($orderTypeCode))) {
            unset($this->OrderTypeCode);
        } else {
            $this->OrderTypeCode = $orderTypeCode;
        }
        return $this;
    }
    /**
     * Get SalesOrderID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesOrderID()
    {
        return isset($this->SalesOrderID) ? $this->SalesOrderID : null;
    }
    /**
     * Set SalesOrderID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesOrderID
     * @return \StructType\OrderReference
     */
    public function setSalesOrderID($salesOrderID = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderID) && !is_string($salesOrderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderID, true), gettype($salesOrderID)), __LINE__);
        }
        if (is_null($salesOrderID) || (is_array($salesOrderID) && empty($salesOrderID))) {
            unset($this->SalesOrderID);
        } else {
            $this->SalesOrderID = $salesOrderID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
