<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderLineReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderLineReference
 * @subpackage Structs
 */
class OrderLineReference extends AbstractStructBase
{
    /**
     * The LineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineID;
    /**
     * The LineStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineStatusCode;
    /**
     * The OrderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderReference
     */
    public $OrderReference;
    /**
     * The SalesOrderLineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesOrderLineID;
    /**
     * The UUID
     * Meta informations extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UUID;
    /**
     * Constructor method for OrderLineReference
     * @uses OrderLineReference::setLineID()
     * @uses OrderLineReference::setLineStatusCode()
     * @uses OrderLineReference::setOrderReference()
     * @uses OrderLineReference::setSalesOrderLineID()
     * @uses OrderLineReference::setUUID()
     * @param string $lineID
     * @param string $lineStatusCode
     * @param \StructType\OrderReference $orderReference
     * @param string $salesOrderLineID
     * @param string $uUID
     */
    public function __construct($lineID = null, $lineStatusCode = null, \StructType\OrderReference $orderReference = null, $salesOrderLineID = null, $uUID = null)
    {
        $this
            ->setLineID($lineID)
            ->setLineStatusCode($lineStatusCode)
            ->setOrderReference($orderReference)
            ->setSalesOrderLineID($salesOrderLineID)
            ->setUUID($uUID);
    }
    /**
     * Get LineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineID()
    {
        return isset($this->LineID) ? $this->LineID : null;
    }
    /**
     * Set LineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineID
     * @return \StructType\OrderLineReference
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: string
        if (!is_null($lineID) && !is_string($lineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineID, true), gettype($lineID)), __LINE__);
        }
        if (is_null($lineID) || (is_array($lineID) && empty($lineID))) {
            unset($this->LineID);
        } else {
            $this->LineID = $lineID;
        }
        return $this;
    }
    /**
     * Get LineStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineStatusCode()
    {
        return isset($this->LineStatusCode) ? $this->LineStatusCode : null;
    }
    /**
     * Set LineStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineStatusCode
     * @return \StructType\OrderLineReference
     */
    public function setLineStatusCode($lineStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($lineStatusCode) && !is_string($lineStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineStatusCode, true), gettype($lineStatusCode)), __LINE__);
        }
        if (is_null($lineStatusCode) || (is_array($lineStatusCode) && empty($lineStatusCode))) {
            unset($this->LineStatusCode);
        } else {
            $this->LineStatusCode = $lineStatusCode;
        }
        return $this;
    }
    /**
     * Get OrderReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderReference|null
     */
    public function getOrderReference()
    {
        return isset($this->OrderReference) ? $this->OrderReference : null;
    }
    /**
     * Set OrderReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrderReference $orderReference
     * @return \StructType\OrderLineReference
     */
    public function setOrderReference(\StructType\OrderReference $orderReference = null)
    {
        if (is_null($orderReference) || (is_array($orderReference) && empty($orderReference))) {
            unset($this->OrderReference);
        } else {
            $this->OrderReference = $orderReference;
        }
        return $this;
    }
    /**
     * Get SalesOrderLineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesOrderLineID()
    {
        return isset($this->SalesOrderLineID) ? $this->SalesOrderLineID : null;
    }
    /**
     * Set SalesOrderLineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesOrderLineID
     * @return \StructType\OrderLineReference
     */
    public function setSalesOrderLineID($salesOrderLineID = null)
    {
        // validation for constraint: string
        if (!is_null($salesOrderLineID) && !is_string($salesOrderLineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesOrderLineID, true), gettype($salesOrderLineID)), __LINE__);
        }
        if (is_null($salesOrderLineID) || (is_array($salesOrderLineID) && empty($salesOrderLineID))) {
            unset($this->SalesOrderLineID);
        } else {
            $this->SalesOrderLineID = $salesOrderLineID;
        }
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\OrderLineReference
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uUID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uUID, true)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OrderLineReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
