<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlineSaleShippingInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlineSaleShippingInfo
 * @subpackage Structs
 */
class OnlineSaleShippingInfo extends AbstractStructBase
{
    /**
     * The AgentIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentIdentification;
    /**
     * The AgentName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentName;
    /**
     * The AgentSurName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AgentSurName;
    /**
     * The AgentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $AgentType;
    /**
     * The ShippingDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ShippingDate;
    /**
     * Constructor method for OnlineSaleShippingInfo
     * @uses OnlineSaleShippingInfo::setAgentIdentification()
     * @uses OnlineSaleShippingInfo::setAgentName()
     * @uses OnlineSaleShippingInfo::setAgentSurName()
     * @uses OnlineSaleShippingInfo::setAgentType()
     * @uses OnlineSaleShippingInfo::setShippingDate()
     * @param string $agentIdentification
     * @param string $agentName
     * @param string $agentSurName
     * @param int $agentType
     * @param string $shippingDate
     */
    public function __construct($agentIdentification = null, $agentName = null, $agentSurName = null, $agentType = null, $shippingDate = null)
    {
        $this
            ->setAgentIdentification($agentIdentification)
            ->setAgentName($agentName)
            ->setAgentSurName($agentSurName)
            ->setAgentType($agentType)
            ->setShippingDate($shippingDate);
    }
    /**
     * Get AgentIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentIdentification()
    {
        return isset($this->AgentIdentification) ? $this->AgentIdentification : null;
    }
    /**
     * Set AgentIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentIdentification
     * @return \StructType\OnlineSaleShippingInfo
     */
    public function setAgentIdentification($agentIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($agentIdentification) && !is_string($agentIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentIdentification, true), gettype($agentIdentification)), __LINE__);
        }
        if (is_null($agentIdentification) || (is_array($agentIdentification) && empty($agentIdentification))) {
            unset($this->AgentIdentification);
        } else {
            $this->AgentIdentification = $agentIdentification;
        }
        return $this;
    }
    /**
     * Get AgentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentName()
    {
        return isset($this->AgentName) ? $this->AgentName : null;
    }
    /**
     * Set AgentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentName
     * @return \StructType\OnlineSaleShippingInfo
     */
    public function setAgentName($agentName = null)
    {
        // validation for constraint: string
        if (!is_null($agentName) && !is_string($agentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentName, true), gettype($agentName)), __LINE__);
        }
        if (is_null($agentName) || (is_array($agentName) && empty($agentName))) {
            unset($this->AgentName);
        } else {
            $this->AgentName = $agentName;
        }
        return $this;
    }
    /**
     * Get AgentSurName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgentSurName()
    {
        return isset($this->AgentSurName) ? $this->AgentSurName : null;
    }
    /**
     * Set AgentSurName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agentSurName
     * @return \StructType\OnlineSaleShippingInfo
     */
    public function setAgentSurName($agentSurName = null)
    {
        // validation for constraint: string
        if (!is_null($agentSurName) && !is_string($agentSurName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agentSurName, true), gettype($agentSurName)), __LINE__);
        }
        if (is_null($agentSurName) || (is_array($agentSurName) && empty($agentSurName))) {
            unset($this->AgentSurName);
        } else {
            $this->AgentSurName = $agentSurName;
        }
        return $this;
    }
    /**
     * Get AgentType value
     * @return int|null
     */
    public function getAgentType()
    {
        return $this->AgentType;
    }
    /**
     * Set AgentType value
     * @param int $agentType
     * @return \StructType\OnlineSaleShippingInfo
     */
    public function setAgentType($agentType = null)
    {
        // validation for constraint: int
        if (!is_null($agentType) && !(is_int($agentType) || ctype_digit($agentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($agentType, true), gettype($agentType)), __LINE__);
        }
        $this->AgentType = $agentType;
        return $this;
    }
    /**
     * Get ShippingDate value
     * @return string|null
     */
    public function getShippingDate()
    {
        return $this->ShippingDate;
    }
    /**
     * Set ShippingDate value
     * @param string $shippingDate
     * @return \StructType\OnlineSaleShippingInfo
     */
    public function setShippingDate($shippingDate = null)
    {
        // validation for constraint: string
        if (!is_null($shippingDate) && !is_string($shippingDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($shippingDate, true), gettype($shippingDate)), __LINE__);
        }
        $this->ShippingDate = $shippingDate;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OnlineSaleShippingInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
