<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnlineSaleInfo StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:OnlineSaleInfo
 * @subpackage Structs
 */
class OnlineSaleInfo extends AbstractStructBase
{
    /**
     * The OtherExplanations
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherExplanations;
    /**
     * The PaymentAgent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentAgent;
    /**
     * The PaymentDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PaymentDate;
    /**
     * The PaymentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentType;
    /**
     * The ShippingInfo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OnlineSaleShippingInfo
     */
    public $ShippingInfo;
    /**
     * The WebAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebAddress;
    /**
     * Constructor method for OnlineSaleInfo
     * @uses OnlineSaleInfo::setOtherExplanations()
     * @uses OnlineSaleInfo::setPaymentAgent()
     * @uses OnlineSaleInfo::setPaymentDate()
     * @uses OnlineSaleInfo::setPaymentType()
     * @uses OnlineSaleInfo::setShippingInfo()
     * @uses OnlineSaleInfo::setWebAddress()
     * @param string $otherExplanations
     * @param string $paymentAgent
     * @param string $paymentDate
     * @param string $paymentType
     * @param \StructType\OnlineSaleShippingInfo $shippingInfo
     * @param string $webAddress
     */
    public function __construct($otherExplanations = null, $paymentAgent = null, $paymentDate = null, $paymentType = null, \StructType\OnlineSaleShippingInfo $shippingInfo = null, $webAddress = null)
    {
        $this
            ->setOtherExplanations($otherExplanations)
            ->setPaymentAgent($paymentAgent)
            ->setPaymentDate($paymentDate)
            ->setPaymentType($paymentType)
            ->setShippingInfo($shippingInfo)
            ->setWebAddress($webAddress);
    }
    /**
     * Get OtherExplanations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherExplanations()
    {
        return isset($this->OtherExplanations) ? $this->OtherExplanations : null;
    }
    /**
     * Set OtherExplanations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherExplanations
     * @return \StructType\OnlineSaleInfo
     */
    public function setOtherExplanations($otherExplanations = null)
    {
        // validation for constraint: string
        if (!is_null($otherExplanations) && !is_string($otherExplanations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherExplanations, true), gettype($otherExplanations)), __LINE__);
        }
        if (is_null($otherExplanations) || (is_array($otherExplanations) && empty($otherExplanations))) {
            unset($this->OtherExplanations);
        } else {
            $this->OtherExplanations = $otherExplanations;
        }
        return $this;
    }
    /**
     * Get PaymentAgent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentAgent()
    {
        return isset($this->PaymentAgent) ? $this->PaymentAgent : null;
    }
    /**
     * Set PaymentAgent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentAgent
     * @return \StructType\OnlineSaleInfo
     */
    public function setPaymentAgent($paymentAgent = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAgent) && !is_string($paymentAgent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAgent, true), gettype($paymentAgent)), __LINE__);
        }
        if (is_null($paymentAgent) || (is_array($paymentAgent) && empty($paymentAgent))) {
            unset($this->PaymentAgent);
        } else {
            $this->PaymentAgent = $paymentAgent;
        }
        return $this;
    }
    /**
     * Get PaymentDate value
     * @return string|null
     */
    public function getPaymentDate()
    {
        return $this->PaymentDate;
    }
    /**
     * Set PaymentDate value
     * @param string $paymentDate
     * @return \StructType\OnlineSaleInfo
     */
    public function setPaymentDate($paymentDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDate) && !is_string($paymentDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDate, true), gettype($paymentDate)), __LINE__);
        }
        $this->PaymentDate = $paymentDate;
        return $this;
    }
    /**
     * Get PaymentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentType()
    {
        return isset($this->PaymentType) ? $this->PaymentType : null;
    }
    /**
     * Set PaymentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentType
     * @return \StructType\OnlineSaleInfo
     */
    public function setPaymentType($paymentType = null)
    {
        // validation for constraint: string
        if (!is_null($paymentType) && !is_string($paymentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentType, true), gettype($paymentType)), __LINE__);
        }
        if (is_null($paymentType) || (is_array($paymentType) && empty($paymentType))) {
            unset($this->PaymentType);
        } else {
            $this->PaymentType = $paymentType;
        }
        return $this;
    }
    /**
     * Get ShippingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OnlineSaleShippingInfo|null
     */
    public function getShippingInfo()
    {
        return isset($this->ShippingInfo) ? $this->ShippingInfo : null;
    }
    /**
     * Set ShippingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OnlineSaleShippingInfo $shippingInfo
     * @return \StructType\OnlineSaleInfo
     */
    public function setShippingInfo(\StructType\OnlineSaleShippingInfo $shippingInfo = null)
    {
        if (is_null($shippingInfo) || (is_array($shippingInfo) && empty($shippingInfo))) {
            unset($this->ShippingInfo);
        } else {
            $this->ShippingInfo = $shippingInfo;
        }
        return $this;
    }
    /**
     * Get WebAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebAddress()
    {
        return isset($this->WebAddress) ? $this->WebAddress : null;
    }
    /**
     * Set WebAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $webAddress
     * @return \StructType\OnlineSaleInfo
     */
    public function setWebAddress($webAddress = null)
    {
        // validation for constraint: string
        if (!is_null($webAddress) && !is_string($webAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($webAddress, true), gettype($webAddress)), __LINE__);
        }
        if (is_null($webAddress) || (is_array($webAddress) && empty($webAddress))) {
            unset($this->WebAddress);
        } else {
            $this->WebAddress = $webAddress;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\OnlineSaleInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
