<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaritimeTransport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MaritimeTransport
 * @subpackage Structs
 */
class MaritimeTransport extends AbstractStructBase
{
    /**
     * The RadioCallSignID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RadioCallSignID;
    /**
     * The VesselID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VesselID;
    /**
     * The VesselName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VesselName;
    /**
     * Constructor method for MaritimeTransport
     * @uses MaritimeTransport::setRadioCallSignID()
     * @uses MaritimeTransport::setVesselID()
     * @uses MaritimeTransport::setVesselName()
     * @param string $radioCallSignID
     * @param string $vesselID
     * @param string $vesselName
     */
    public function __construct($radioCallSignID = null, $vesselID = null, $vesselName = null)
    {
        $this
            ->setRadioCallSignID($radioCallSignID)
            ->setVesselID($vesselID)
            ->setVesselName($vesselName);
    }
    /**
     * Get RadioCallSignID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRadioCallSignID()
    {
        return isset($this->RadioCallSignID) ? $this->RadioCallSignID : null;
    }
    /**
     * Set RadioCallSignID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $radioCallSignID
     * @return \StructType\MaritimeTransport
     */
    public function setRadioCallSignID($radioCallSignID = null)
    {
        // validation for constraint: string
        if (!is_null($radioCallSignID) && !is_string($radioCallSignID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($radioCallSignID, true), gettype($radioCallSignID)), __LINE__);
        }
        if (is_null($radioCallSignID) || (is_array($radioCallSignID) && empty($radioCallSignID))) {
            unset($this->RadioCallSignID);
        } else {
            $this->RadioCallSignID = $radioCallSignID;
        }
        return $this;
    }
    /**
     * Get VesselID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVesselID()
    {
        return isset($this->VesselID) ? $this->VesselID : null;
    }
    /**
     * Set VesselID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vesselID
     * @return \StructType\MaritimeTransport
     */
    public function setVesselID($vesselID = null)
    {
        // validation for constraint: string
        if (!is_null($vesselID) && !is_string($vesselID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vesselID, true), gettype($vesselID)), __LINE__);
        }
        if (is_null($vesselID) || (is_array($vesselID) && empty($vesselID))) {
            unset($this->VesselID);
        } else {
            $this->VesselID = $vesselID;
        }
        return $this;
    }
    /**
     * Get VesselName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVesselName()
    {
        return isset($this->VesselName) ? $this->VesselName : null;
    }
    /**
     * Set VesselName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vesselName
     * @return \StructType\MaritimeTransport
     */
    public function setVesselName($vesselName = null)
    {
        // validation for constraint: string
        if (!is_null($vesselName) && !is_string($vesselName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vesselName, true), gettype($vesselName)), __LINE__);
        }
        if (is_null($vesselName) || (is_array($vesselName) && empty($vesselName))) {
            unset($this->VesselName);
        } else {
            $this->VesselName = $vesselName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MaritimeTransport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
