<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LineReference
 * @subpackage Structs
 */
class LineReference extends AbstractStructBase
{
    /**
     * The DocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $DocumentReference;
    /**
     * The LineID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineID;
    /**
     * The LineStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LineStatusCode;
    /**
     * Constructor method for LineReference
     * @uses LineReference::setDocumentReference()
     * @uses LineReference::setLineID()
     * @uses LineReference::setLineStatusCode()
     * @param \StructType\DocumentReference $documentReference
     * @param string $lineID
     * @param string $lineStatusCode
     */
    public function __construct(\StructType\DocumentReference $documentReference = null, $lineID = null, $lineStatusCode = null)
    {
        $this
            ->setDocumentReference($documentReference)
            ->setLineID($lineID)
            ->setLineStatusCode($lineStatusCode);
    }
    /**
     * Get DocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getDocumentReference()
    {
        return isset($this->DocumentReference) ? $this->DocumentReference : null;
    }
    /**
     * Set DocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $documentReference
     * @return \StructType\LineReference
     */
    public function setDocumentReference(\StructType\DocumentReference $documentReference = null)
    {
        if (is_null($documentReference) || (is_array($documentReference) && empty($documentReference))) {
            unset($this->DocumentReference);
        } else {
            $this->DocumentReference = $documentReference;
        }
        return $this;
    }
    /**
     * Get LineID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineID()
    {
        return isset($this->LineID) ? $this->LineID : null;
    }
    /**
     * Set LineID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineID
     * @return \StructType\LineReference
     */
    public function setLineID($lineID = null)
    {
        // validation for constraint: string
        if (!is_null($lineID) && !is_string($lineID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineID, true), gettype($lineID)), __LINE__);
        }
        if (is_null($lineID) || (is_array($lineID) && empty($lineID))) {
            unset($this->LineID);
        } else {
            $this->LineID = $lineID;
        }
        return $this;
    }
    /**
     * Get LineStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLineStatusCode()
    {
        return isset($this->LineStatusCode) ? $this->LineStatusCode : null;
    }
    /**
     * Set LineStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lineStatusCode
     * @return \StructType\LineReference
     */
    public function setLineStatusCode($lineStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($lineStatusCode) && !is_string($lineStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineStatusCode, true), gettype($lineStatusCode)), __LINE__);
        }
        if (is_null($lineStatusCode) || (is_array($lineStatusCode) && empty($lineStatusCode))) {
            unset($this->LineStatusCode);
        } else {
            $this->LineStatusCode = $lineStatusCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LineReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
