<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Item StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Item
 * @subpackage Structs
 */
class Item extends AbstractStructBase
{
    /**
     * The AdditionalItemIdentificationCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $AdditionalItemIdentificationCodes;
    /**
     * The BrandName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BrandName;
    /**
     * The BuyersItemIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuyersItemIdentification;
    /**
     * The CommodityClassification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCommodityClassification
     */
    public $CommodityClassification;
    /**
     * The CommodityClassificationCodes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $CommodityClassificationCodes;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The ManufacturersItemIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ManufacturersItemIdentification;
    /**
     * The ModelName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModelName;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OriginCountry
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OriginCountry
     */
    public $OriginCountry;
    /**
     * The ProductTraceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductTraceID;
    /**
     * The SellersItemIdentification
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellersItemIdentification;
    /**
     * The SerialID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerialID;
    /**
     * Constructor method for Item
     * @uses Item::setAdditionalItemIdentificationCodes()
     * @uses Item::setBrandName()
     * @uses Item::setBuyersItemIdentification()
     * @uses Item::setCommodityClassification()
     * @uses Item::setCommodityClassificationCodes()
     * @uses Item::setDescription()
     * @uses Item::setManufacturersItemIdentification()
     * @uses Item::setModelName()
     * @uses Item::setName()
     * @uses Item::setOriginCountry()
     * @uses Item::setProductTraceID()
     * @uses Item::setSellersItemIdentification()
     * @uses Item::setSerialID()
     * @param \ArrayType\ArrayOfstring $additionalItemIdentificationCodes
     * @param string $brandName
     * @param string $buyersItemIdentification
     * @param \ArrayType\ArrayOfCommodityClassification $commodityClassification
     * @param \ArrayType\ArrayOfstring $commodityClassificationCodes
     * @param string $description
     * @param string $manufacturersItemIdentification
     * @param string $modelName
     * @param string $name
     * @param \StructType\OriginCountry $originCountry
     * @param string $productTraceID
     * @param string $sellersItemIdentification
     * @param string $serialID
     */
    public function __construct(\ArrayType\ArrayOfstring $additionalItemIdentificationCodes = null, $brandName = null, $buyersItemIdentification = null, \ArrayType\ArrayOfCommodityClassification $commodityClassification = null, \ArrayType\ArrayOfstring $commodityClassificationCodes = null, $description = null, $manufacturersItemIdentification = null, $modelName = null, $name = null, \StructType\OriginCountry $originCountry = null, $productTraceID = null, $sellersItemIdentification = null, $serialID = null)
    {
        $this
            ->setAdditionalItemIdentificationCodes($additionalItemIdentificationCodes)
            ->setBrandName($brandName)
            ->setBuyersItemIdentification($buyersItemIdentification)
            ->setCommodityClassification($commodityClassification)
            ->setCommodityClassificationCodes($commodityClassificationCodes)
            ->setDescription($description)
            ->setManufacturersItemIdentification($manufacturersItemIdentification)
            ->setModelName($modelName)
            ->setName($name)
            ->setOriginCountry($originCountry)
            ->setProductTraceID($productTraceID)
            ->setSellersItemIdentification($sellersItemIdentification)
            ->setSerialID($serialID);
    }
    /**
     * Get AdditionalItemIdentificationCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAdditionalItemIdentificationCodes()
    {
        return isset($this->AdditionalItemIdentificationCodes) ? $this->AdditionalItemIdentificationCodes : null;
    }
    /**
     * Set AdditionalItemIdentificationCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $additionalItemIdentificationCodes
     * @return \StructType\Item
     */
    public function setAdditionalItemIdentificationCodes(\ArrayType\ArrayOfstring $additionalItemIdentificationCodes = null)
    {
        if (is_null($additionalItemIdentificationCodes) || (is_array($additionalItemIdentificationCodes) && empty($additionalItemIdentificationCodes))) {
            unset($this->AdditionalItemIdentificationCodes);
        } else {
            $this->AdditionalItemIdentificationCodes = $additionalItemIdentificationCodes;
        }
        return $this;
    }
    /**
     * Get BrandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBrandName()
    {
        return isset($this->BrandName) ? $this->BrandName : null;
    }
    /**
     * Set BrandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $brandName
     * @return \StructType\Item
     */
    public function setBrandName($brandName = null)
    {
        // validation for constraint: string
        if (!is_null($brandName) && !is_string($brandName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($brandName, true), gettype($brandName)), __LINE__);
        }
        if (is_null($brandName) || (is_array($brandName) && empty($brandName))) {
            unset($this->BrandName);
        } else {
            $this->BrandName = $brandName;
        }
        return $this;
    }
    /**
     * Get BuyersItemIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuyersItemIdentification()
    {
        return isset($this->BuyersItemIdentification) ? $this->BuyersItemIdentification : null;
    }
    /**
     * Set BuyersItemIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buyersItemIdentification
     * @return \StructType\Item
     */
    public function setBuyersItemIdentification($buyersItemIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($buyersItemIdentification) && !is_string($buyersItemIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buyersItemIdentification, true), gettype($buyersItemIdentification)), __LINE__);
        }
        if (is_null($buyersItemIdentification) || (is_array($buyersItemIdentification) && empty($buyersItemIdentification))) {
            unset($this->BuyersItemIdentification);
        } else {
            $this->BuyersItemIdentification = $buyersItemIdentification;
        }
        return $this;
    }
    /**
     * Get CommodityClassification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCommodityClassification|null
     */
    public function getCommodityClassification()
    {
        return isset($this->CommodityClassification) ? $this->CommodityClassification : null;
    }
    /**
     * Set CommodityClassification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCommodityClassification $commodityClassification
     * @return \StructType\Item
     */
    public function setCommodityClassification(\ArrayType\ArrayOfCommodityClassification $commodityClassification = null)
    {
        if (is_null($commodityClassification) || (is_array($commodityClassification) && empty($commodityClassification))) {
            unset($this->CommodityClassification);
        } else {
            $this->CommodityClassification = $commodityClassification;
        }
        return $this;
    }
    /**
     * Get CommodityClassificationCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getCommodityClassificationCodes()
    {
        return isset($this->CommodityClassificationCodes) ? $this->CommodityClassificationCodes : null;
    }
    /**
     * Set CommodityClassificationCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $commodityClassificationCodes
     * @return \StructType\Item
     */
    public function setCommodityClassificationCodes(\ArrayType\ArrayOfstring $commodityClassificationCodes = null)
    {
        if (is_null($commodityClassificationCodes) || (is_array($commodityClassificationCodes) && empty($commodityClassificationCodes))) {
            unset($this->CommodityClassificationCodes);
        } else {
            $this->CommodityClassificationCodes = $commodityClassificationCodes;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\Item
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get ManufacturersItemIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getManufacturersItemIdentification()
    {
        return isset($this->ManufacturersItemIdentification) ? $this->ManufacturersItemIdentification : null;
    }
    /**
     * Set ManufacturersItemIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $manufacturersItemIdentification
     * @return \StructType\Item
     */
    public function setManufacturersItemIdentification($manufacturersItemIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturersItemIdentification) && !is_string($manufacturersItemIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($manufacturersItemIdentification, true), gettype($manufacturersItemIdentification)), __LINE__);
        }
        if (is_null($manufacturersItemIdentification) || (is_array($manufacturersItemIdentification) && empty($manufacturersItemIdentification))) {
            unset($this->ManufacturersItemIdentification);
        } else {
            $this->ManufacturersItemIdentification = $manufacturersItemIdentification;
        }
        return $this;
    }
    /**
     * Get ModelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelName()
    {
        return isset($this->ModelName) ? $this->ModelName : null;
    }
    /**
     * Set ModelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelName
     * @return \StructType\Item
     */
    public function setModelName($modelName = null)
    {
        // validation for constraint: string
        if (!is_null($modelName) && !is_string($modelName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($modelName, true), gettype($modelName)), __LINE__);
        }
        if (is_null($modelName) || (is_array($modelName) && empty($modelName))) {
            unset($this->ModelName);
        } else {
            $this->ModelName = $modelName;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Item
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OriginCountry value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OriginCountry|null
     */
    public function getOriginCountry()
    {
        return isset($this->OriginCountry) ? $this->OriginCountry : null;
    }
    /**
     * Set OriginCountry value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OriginCountry $originCountry
     * @return \StructType\Item
     */
    public function setOriginCountry(\StructType\OriginCountry $originCountry = null)
    {
        if (is_null($originCountry) || (is_array($originCountry) && empty($originCountry))) {
            unset($this->OriginCountry);
        } else {
            $this->OriginCountry = $originCountry;
        }
        return $this;
    }
    /**
     * Get ProductTraceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductTraceID()
    {
        return isset($this->ProductTraceID) ? $this->ProductTraceID : null;
    }
    /**
     * Set ProductTraceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productTraceID
     * @return \StructType\Item
     */
    public function setProductTraceID($productTraceID = null)
    {
        // validation for constraint: string
        if (!is_null($productTraceID) && !is_string($productTraceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productTraceID, true), gettype($productTraceID)), __LINE__);
        }
        if (is_null($productTraceID) || (is_array($productTraceID) && empty($productTraceID))) {
            unset($this->ProductTraceID);
        } else {
            $this->ProductTraceID = $productTraceID;
        }
        return $this;
    }
    /**
     * Get SellersItemIdentification value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellersItemIdentification()
    {
        return isset($this->SellersItemIdentification) ? $this->SellersItemIdentification : null;
    }
    /**
     * Set SellersItemIdentification value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sellersItemIdentification
     * @return \StructType\Item
     */
    public function setSellersItemIdentification($sellersItemIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($sellersItemIdentification) && !is_string($sellersItemIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sellersItemIdentification, true), gettype($sellersItemIdentification)), __LINE__);
        }
        if (is_null($sellersItemIdentification) || (is_array($sellersItemIdentification) && empty($sellersItemIdentification))) {
            unset($this->SellersItemIdentification);
        } else {
            $this->SellersItemIdentification = $sellersItemIdentification;
        }
        return $this;
    }
    /**
     * Get SerialID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerialID()
    {
        return isset($this->SerialID) ? $this->SerialID : null;
    }
    /**
     * Set SerialID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serialID
     * @return \StructType\Item
     */
    public function setSerialID($serialID = null)
    {
        // validation for constraint: string
        if (!is_null($serialID) && !is_string($serialID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serialID, true), gettype($serialID)), __LINE__);
        }
        if (is_null($serialID) || (is_array($serialID) && empty($serialID))) {
            unset($this->SerialID);
        } else {
            $this->SerialID = $serialID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Item
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
