<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceSubLine StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvoiceSubLine
 * @subpackage Structs
 */
class InvoiceSubLine extends AbstractStructBase
{
    /**
     * The AllowanceCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAllowanceCharge
     */
    public $AllowanceCharge;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDelivery
     */
    public $Delivery;
    /**
     * The DespatchLineReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLineReference
     */
    public $DespatchLineReference;
    /**
     * The InvoicedQuantityUnitCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoicedQuantityUnitCode;
    /**
     * The InvoicedQuantityValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $InvoicedQuantityValue;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Item
     */
    public $Item;
    /**
     * The LineExtensionAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $LineExtensionAmount;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Notes;
    /**
     * The OrderLineReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfOrderLineReference
     */
    public $OrderLineReference;
    /**
     * The Price
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $Price;
    /**
     * The ReceiptLineReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLineReference
     */
    public $ReceiptLineReference;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TaxTotal
     */
    public $TaxTotal;
    /**
     * The WithholdingTaxTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTaxTotal
     */
    public $WithholdingTaxTotal;
    /**
     * Constructor method for InvoiceSubLine
     * @uses InvoiceSubLine::setAllowanceCharge()
     * @uses InvoiceSubLine::setDelivery()
     * @uses InvoiceSubLine::setDespatchLineReference()
     * @uses InvoiceSubLine::setInvoicedQuantityUnitCode()
     * @uses InvoiceSubLine::setInvoicedQuantityValue()
     * @uses InvoiceSubLine::setItem()
     * @uses InvoiceSubLine::setLineExtensionAmount()
     * @uses InvoiceSubLine::setNotes()
     * @uses InvoiceSubLine::setOrderLineReference()
     * @uses InvoiceSubLine::setPrice()
     * @uses InvoiceSubLine::setReceiptLineReference()
     * @uses InvoiceSubLine::setTaxTotal()
     * @uses InvoiceSubLine::setWithholdingTaxTotal()
     * @param \ArrayType\ArrayOfAllowanceCharge $allowanceCharge
     * @param \ArrayType\ArrayOfDelivery $delivery
     * @param \ArrayType\ArrayOfLineReference $despatchLineReference
     * @param string $invoicedQuantityUnitCode
     * @param float $invoicedQuantityValue
     * @param \StructType\Item $item
     * @param \StructType\Amount $lineExtensionAmount
     * @param \ArrayType\ArrayOfstring $notes
     * @param \ArrayType\ArrayOfOrderLineReference $orderLineReference
     * @param \StructType\Amount $price
     * @param \ArrayType\ArrayOfLineReference $receiptLineReference
     * @param \StructType\TaxTotal $taxTotal
     * @param \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal
     */
    public function __construct(\ArrayType\ArrayOfAllowanceCharge $allowanceCharge = null, \ArrayType\ArrayOfDelivery $delivery = null, \ArrayType\ArrayOfLineReference $despatchLineReference = null, $invoicedQuantityUnitCode = null, $invoicedQuantityValue = null, \StructType\Item $item = null, \StructType\Amount $lineExtensionAmount = null, \ArrayType\ArrayOfstring $notes = null, \ArrayType\ArrayOfOrderLineReference $orderLineReference = null, \StructType\Amount $price = null, \ArrayType\ArrayOfLineReference $receiptLineReference = null, \StructType\TaxTotal $taxTotal = null, \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal = null)
    {
        $this
            ->setAllowanceCharge($allowanceCharge)
            ->setDelivery($delivery)
            ->setDespatchLineReference($despatchLineReference)
            ->setInvoicedQuantityUnitCode($invoicedQuantityUnitCode)
            ->setInvoicedQuantityValue($invoicedQuantityValue)
            ->setItem($item)
            ->setLineExtensionAmount($lineExtensionAmount)
            ->setNotes($notes)
            ->setOrderLineReference($orderLineReference)
            ->setPrice($price)
            ->setReceiptLineReference($receiptLineReference)
            ->setTaxTotal($taxTotal)
            ->setWithholdingTaxTotal($withholdingTaxTotal);
    }
    /**
     * Get AllowanceCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAllowanceCharge|null
     */
    public function getAllowanceCharge()
    {
        return isset($this->AllowanceCharge) ? $this->AllowanceCharge : null;
    }
    /**
     * Set AllowanceCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAllowanceCharge $allowanceCharge
     * @return \StructType\InvoiceSubLine
     */
    public function setAllowanceCharge(\ArrayType\ArrayOfAllowanceCharge $allowanceCharge = null)
    {
        if (is_null($allowanceCharge) || (is_array($allowanceCharge) && empty($allowanceCharge))) {
            unset($this->AllowanceCharge);
        } else {
            $this->AllowanceCharge = $allowanceCharge;
        }
        return $this;
    }
    /**
     * Get Delivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDelivery|null
     */
    public function getDelivery()
    {
        return isset($this->Delivery) ? $this->Delivery : null;
    }
    /**
     * Set Delivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDelivery $delivery
     * @return \StructType\InvoiceSubLine
     */
    public function setDelivery(\ArrayType\ArrayOfDelivery $delivery = null)
    {
        if (is_null($delivery) || (is_array($delivery) && empty($delivery))) {
            unset($this->Delivery);
        } else {
            $this->Delivery = $delivery;
        }
        return $this;
    }
    /**
     * Get DespatchLineReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLineReference|null
     */
    public function getDespatchLineReference()
    {
        return isset($this->DespatchLineReference) ? $this->DespatchLineReference : null;
    }
    /**
     * Set DespatchLineReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLineReference $despatchLineReference
     * @return \StructType\InvoiceSubLine
     */
    public function setDespatchLineReference(\ArrayType\ArrayOfLineReference $despatchLineReference = null)
    {
        if (is_null($despatchLineReference) || (is_array($despatchLineReference) && empty($despatchLineReference))) {
            unset($this->DespatchLineReference);
        } else {
            $this->DespatchLineReference = $despatchLineReference;
        }
        return $this;
    }
    /**
     * Get InvoicedQuantityUnitCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoicedQuantityUnitCode()
    {
        return isset($this->InvoicedQuantityUnitCode) ? $this->InvoicedQuantityUnitCode : null;
    }
    /**
     * Set InvoicedQuantityUnitCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoicedQuantityUnitCode
     * @return \StructType\InvoiceSubLine
     */
    public function setInvoicedQuantityUnitCode($invoicedQuantityUnitCode = null)
    {
        // validation for constraint: string
        if (!is_null($invoicedQuantityUnitCode) && !is_string($invoicedQuantityUnitCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoicedQuantityUnitCode, true), gettype($invoicedQuantityUnitCode)), __LINE__);
        }
        if (is_null($invoicedQuantityUnitCode) || (is_array($invoicedQuantityUnitCode) && empty($invoicedQuantityUnitCode))) {
            unset($this->InvoicedQuantityUnitCode);
        } else {
            $this->InvoicedQuantityUnitCode = $invoicedQuantityUnitCode;
        }
        return $this;
    }
    /**
     * Get InvoicedQuantityValue value
     * @return float|null
     */
    public function getInvoicedQuantityValue()
    {
        return $this->InvoicedQuantityValue;
    }
    /**
     * Set InvoicedQuantityValue value
     * @param float $invoicedQuantityValue
     * @return \StructType\InvoiceSubLine
     */
    public function setInvoicedQuantityValue($invoicedQuantityValue = null)
    {
        // validation for constraint: float
        if (!is_null($invoicedQuantityValue) && !(is_float($invoicedQuantityValue) || is_numeric($invoicedQuantityValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($invoicedQuantityValue, true), gettype($invoicedQuantityValue)), __LINE__);
        }
        $this->InvoicedQuantityValue = $invoicedQuantityValue;
        return $this;
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Item|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Item $item
     * @return \StructType\InvoiceSubLine
     */
    public function setItem(\StructType\Item $item = null)
    {
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Get LineExtensionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getLineExtensionAmount()
    {
        return isset($this->LineExtensionAmount) ? $this->LineExtensionAmount : null;
    }
    /**
     * Set LineExtensionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $lineExtensionAmount
     * @return \StructType\InvoiceSubLine
     */
    public function setLineExtensionAmount(\StructType\Amount $lineExtensionAmount = null)
    {
        if (is_null($lineExtensionAmount) || (is_array($lineExtensionAmount) && empty($lineExtensionAmount))) {
            unset($this->LineExtensionAmount);
        } else {
            $this->LineExtensionAmount = $lineExtensionAmount;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $notes
     * @return \StructType\InvoiceSubLine
     */
    public function setNotes(\ArrayType\ArrayOfstring $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OrderLineReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfOrderLineReference|null
     */
    public function getOrderLineReference()
    {
        return isset($this->OrderLineReference) ? $this->OrderLineReference : null;
    }
    /**
     * Set OrderLineReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfOrderLineReference $orderLineReference
     * @return \StructType\InvoiceSubLine
     */
    public function setOrderLineReference(\ArrayType\ArrayOfOrderLineReference $orderLineReference = null)
    {
        if (is_null($orderLineReference) || (is_array($orderLineReference) && empty($orderLineReference))) {
            unset($this->OrderLineReference);
        } else {
            $this->OrderLineReference = $orderLineReference;
        }
        return $this;
    }
    /**
     * Get Price value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getPrice()
    {
        return isset($this->Price) ? $this->Price : null;
    }
    /**
     * Set Price value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $price
     * @return \StructType\InvoiceSubLine
     */
    public function setPrice(\StructType\Amount $price = null)
    {
        if (is_null($price) || (is_array($price) && empty($price))) {
            unset($this->Price);
        } else {
            $this->Price = $price;
        }
        return $this;
    }
    /**
     * Get ReceiptLineReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLineReference|null
     */
    public function getReceiptLineReference()
    {
        return isset($this->ReceiptLineReference) ? $this->ReceiptLineReference : null;
    }
    /**
     * Set ReceiptLineReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLineReference $receiptLineReference
     * @return \StructType\InvoiceSubLine
     */
    public function setReceiptLineReference(\ArrayType\ArrayOfLineReference $receiptLineReference = null)
    {
        if (is_null($receiptLineReference) || (is_array($receiptLineReference) && empty($receiptLineReference))) {
            unset($this->ReceiptLineReference);
        } else {
            $this->ReceiptLineReference = $receiptLineReference;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TaxTotal|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\TaxTotal $taxTotal
     * @return \StructType\InvoiceSubLine
     */
    public function setTaxTotal(\StructType\TaxTotal $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTaxTotal|null
     */
    public function getWithholdingTaxTotal()
    {
        return isset($this->WithholdingTaxTotal) ? $this->WithholdingTaxTotal : null;
    }
    /**
     * Set WithholdingTaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal
     * @return \StructType\InvoiceSubLine
     */
    public function setWithholdingTaxTotal(\ArrayType\ArrayOfTaxTotal $withholdingTaxTotal = null)
    {
        if (is_null($withholdingTaxTotal) || (is_array($withholdingTaxTotal) && empty($withholdingTaxTotal))) {
            unset($this->WithholdingTaxTotal);
        } else {
            $this->WithholdingTaxTotal = $withholdingTaxTotal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceSubLine
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
