<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceResultItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvoiceResultItem
 * @subpackage Structs
 */
class InvoiceResultItem extends AbstractStructBase
{
    /**
     * The InvoiceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InvoiceNumber;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The ResponseCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseCode;
    /**
     * The ResponseDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResponseDescription;
    /**
     * The ResponseStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ResponseStatus;
    /**
     * The TrackNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackNumber;
    /**
     * The UUID
     * Meta informations extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UUID;
    /**
     * The ViewUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewUrl;
    /**
     * Constructor method for InvoiceResultItem
     * @uses InvoiceResultItem::setInvoiceNumber()
     * @uses InvoiceResultItem::setReferenceNumber()
     * @uses InvoiceResultItem::setResponseCode()
     * @uses InvoiceResultItem::setResponseDescription()
     * @uses InvoiceResultItem::setResponseStatus()
     * @uses InvoiceResultItem::setTrackNumber()
     * @uses InvoiceResultItem::setUUID()
     * @uses InvoiceResultItem::setViewUrl()
     * @param string $invoiceNumber
     * @param int $referenceNumber
     * @param string $responseCode
     * @param string $responseDescription
     * @param int $responseStatus
     * @param string $trackNumber
     * @param string $uUID
     * @param string $viewUrl
     */
    public function __construct($invoiceNumber = null, $referenceNumber = null, $responseCode = null, $responseDescription = null, $responseStatus = null, $trackNumber = null, $uUID = null, $viewUrl = null)
    {
        $this
            ->setInvoiceNumber($invoiceNumber)
            ->setReferenceNumber($referenceNumber)
            ->setResponseCode($responseCode)
            ->setResponseDescription($responseDescription)
            ->setResponseStatus($responseStatus)
            ->setTrackNumber($trackNumber)
            ->setUUID($uUID)
            ->setViewUrl($viewUrl);
    }
    /**
     * Get InvoiceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInvoiceNumber()
    {
        return isset($this->InvoiceNumber) ? $this->InvoiceNumber : null;
    }
    /**
     * Set InvoiceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $invoiceNumber
     * @return \StructType\InvoiceResultItem
     */
    public function setInvoiceNumber($invoiceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($invoiceNumber) && !is_string($invoiceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($invoiceNumber, true), gettype($invoiceNumber)), __LINE__);
        }
        if (is_null($invoiceNumber) || (is_array($invoiceNumber) && empty($invoiceNumber))) {
            unset($this->InvoiceNumber);
        } else {
            $this->InvoiceNumber = $invoiceNumber;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\InvoiceResultItem
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get ResponseCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseCode()
    {
        return isset($this->ResponseCode) ? $this->ResponseCode : null;
    }
    /**
     * Set ResponseCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseCode
     * @return \StructType\InvoiceResultItem
     */
    public function setResponseCode($responseCode = null)
    {
        // validation for constraint: string
        if (!is_null($responseCode) && !is_string($responseCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseCode, true), gettype($responseCode)), __LINE__);
        }
        if (is_null($responseCode) || (is_array($responseCode) && empty($responseCode))) {
            unset($this->ResponseCode);
        } else {
            $this->ResponseCode = $responseCode;
        }
        return $this;
    }
    /**
     * Get ResponseDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResponseDescription()
    {
        return isset($this->ResponseDescription) ? $this->ResponseDescription : null;
    }
    /**
     * Set ResponseDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $responseDescription
     * @return \StructType\InvoiceResultItem
     */
    public function setResponseDescription($responseDescription = null)
    {
        // validation for constraint: string
        if (!is_null($responseDescription) && !is_string($responseDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($responseDescription, true), gettype($responseDescription)), __LINE__);
        }
        if (is_null($responseDescription) || (is_array($responseDescription) && empty($responseDescription))) {
            unset($this->ResponseDescription);
        } else {
            $this->ResponseDescription = $responseDescription;
        }
        return $this;
    }
    /**
     * Get ResponseStatus value
     * @return int|null
     */
    public function getResponseStatus()
    {
        return $this->ResponseStatus;
    }
    /**
     * Set ResponseStatus value
     * @param int $responseStatus
     * @return \StructType\InvoiceResultItem
     */
    public function setResponseStatus($responseStatus = null)
    {
        // validation for constraint: int
        if (!is_null($responseStatus) && !(is_int($responseStatus) || ctype_digit($responseStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($responseStatus, true), gettype($responseStatus)), __LINE__);
        }
        $this->ResponseStatus = $responseStatus;
        return $this;
    }
    /**
     * Get TrackNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackNumber()
    {
        return isset($this->TrackNumber) ? $this->TrackNumber : null;
    }
    /**
     * Set TrackNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackNumber
     * @return \StructType\InvoiceResultItem
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackNumber) && !is_string($trackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackNumber, true), gettype($trackNumber)), __LINE__);
        }
        if (is_null($trackNumber) || (is_array($trackNumber) && empty($trackNumber))) {
            unset($this->TrackNumber);
        } else {
            $this->TrackNumber = $trackNumber;
        }
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\InvoiceResultItem
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uUID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uUID, true)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get ViewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewUrl()
    {
        return isset($this->ViewUrl) ? $this->ViewUrl : null;
    }
    /**
     * Set ViewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewUrl
     * @return \StructType\InvoiceResultItem
     */
    public function setViewUrl($viewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($viewUrl) && !is_string($viewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewUrl, true), gettype($viewUrl)), __LINE__);
        }
        if (is_null($viewUrl) || (is_array($viewUrl) && empty($viewUrl))) {
            unset($this->ViewUrl);
        } else {
            $this->ViewUrl = $viewUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceResultItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
