<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceInquiryRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvoiceInquiryRequest
 * @subpackage Structs
 */
class InvoiceInquiryRequest extends RequestBase
{
    /**
     * The GetEmailDetailStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetEmailDetailStatus;
    /**
     * The GetSmsDetailStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $GetSmsDetailStatus;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The TrackNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackNumber;
    /**
     * Constructor method for InvoiceInquiryRequest
     * @uses InvoiceInquiryRequest::setGetEmailDetailStatus()
     * @uses InvoiceInquiryRequest::setGetSmsDetailStatus()
     * @uses InvoiceInquiryRequest::setReferenceNumber()
     * @uses InvoiceInquiryRequest::setTrackNumber()
     * @param bool $getEmailDetailStatus
     * @param bool $getSmsDetailStatus
     * @param int $referenceNumber
     * @param string $trackNumber
     */
    public function __construct($getEmailDetailStatus = null, $getSmsDetailStatus = null, $referenceNumber = null, $trackNumber = null)
    {
        $this
            ->setGetEmailDetailStatus($getEmailDetailStatus)
            ->setGetSmsDetailStatus($getSmsDetailStatus)
            ->setReferenceNumber($referenceNumber)
            ->setTrackNumber($trackNumber);
    }
    /**
     * Get GetEmailDetailStatus value
     * @return bool|null
     */
    public function getGetEmailDetailStatus()
    {
        return $this->GetEmailDetailStatus;
    }
    /**
     * Set GetEmailDetailStatus value
     * @param bool $getEmailDetailStatus
     * @return \StructType\InvoiceInquiryRequest
     */
    public function setGetEmailDetailStatus($getEmailDetailStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($getEmailDetailStatus) && !is_bool($getEmailDetailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getEmailDetailStatus, true), gettype($getEmailDetailStatus)), __LINE__);
        }
        $this->GetEmailDetailStatus = $getEmailDetailStatus;
        return $this;
    }
    /**
     * Get GetSmsDetailStatus value
     * @return bool|null
     */
    public function getGetSmsDetailStatus()
    {
        return $this->GetSmsDetailStatus;
    }
    /**
     * Set GetSmsDetailStatus value
     * @param bool $getSmsDetailStatus
     * @return \StructType\InvoiceInquiryRequest
     */
    public function setGetSmsDetailStatus($getSmsDetailStatus = null)
    {
        // validation for constraint: boolean
        if (!is_null($getSmsDetailStatus) && !is_bool($getSmsDetailStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($getSmsDetailStatus, true), gettype($getSmsDetailStatus)), __LINE__);
        }
        $this->GetSmsDetailStatus = $getSmsDetailStatus;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\InvoiceInquiryRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get TrackNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackNumber()
    {
        return isset($this->TrackNumber) ? $this->TrackNumber : null;
    }
    /**
     * Set TrackNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackNumber
     * @return \StructType\InvoiceInquiryRequest
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackNumber) && !is_string($trackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackNumber, true), gettype($trackNumber)), __LINE__);
        }
        if (is_null($trackNumber) || (is_array($trackNumber) && empty($trackNumber))) {
            unset($this->TrackNumber);
        } else {
            $this->TrackNumber = $trackNumber;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceInquiryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
