<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InvoiceBody StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:InvoiceBody
 * @subpackage Structs
 */
class InvoiceBody extends AbstractStructBase
{
    /**
     * The AccountingCost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountingCost;
    /**
     * The AccountingCustomerParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerParty
     */
    public $AccountingCustomerParty;
    /**
     * The AccountingSupplierParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\SupplierParty
     */
    public $AccountingSupplierParty;
    /**
     * The AdditionalDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $AdditionalDocumentReference;
    /**
     * The AllowanceCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AllowanceCharge
     */
    public $AllowanceCharge;
    /**
     * The AllowanceCharges
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAllowanceCharge
     */
    public $AllowanceCharges;
    /**
     * The BillingReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBillingReference
     */
    public $BillingReference;
    /**
     * The BuyerCustomerParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $BuyerCustomerParty;
    /**
     * The ContractDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $ContractDocumentReference;
    /**
     * The CopyIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CopyIndicator;
    /**
     * The Delivery
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDelivery
     */
    public $Delivery;
    /**
     * The DespatchDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $DespatchDocumentReference;
    /**
     * The DocumentCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentCurrencyCode;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The InvoiceLine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInvoiceLine
     */
    public $InvoiceLine;
    /**
     * The InvoicePeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period
     */
    public $InvoicePeriod;
    /**
     * The InvoiceTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InvoiceTypeCode;
    /**
     * The IssueDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueDateTime;
    /**
     * The LegalMonetaryTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MonetaryTotal
     */
    public $LegalMonetaryTotal;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Notes;
    /**
     * The OrderReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderReference
     */
    public $OrderReference;
    /**
     * The OriginatorDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $OriginatorDocumentReference;
    /**
     * The PaymentAlternativeCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentAlternativeCurrencyCode;
    /**
     * The PaymentAlternativeExchangeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExchangeRate
     */
    public $PaymentAlternativeExchangeRate;
    /**
     * The PaymentCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentCurrencyCode;
    /**
     * The PaymentExchangeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExchangeRate
     */
    public $PaymentExchangeRate;
    /**
     * The PaymentMeans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPaymentMeans
     */
    public $PaymentMeans;
    /**
     * The PaymentTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaymentTerms
     */
    public $PaymentTerms;
    /**
     * The PricingCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PricingCurrencyCode;
    /**
     * The PricingExchangeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExchangeRate
     */
    public $PricingExchangeRate;
    /**
     * The ProfileID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProfileID;
    /**
     * The ReceiptDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDocumentReference
     */
    public $ReceiptDocumentReference;
    /**
     * The SellerSupplierParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $SellerSupplierParty;
    /**
     * The TaxCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxCurrencyCode;
    /**
     * The TaxExchangeRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ExchangeRate
     */
    public $TaxExchangeRate;
    /**
     * The TaxRepresentativeParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $TaxRepresentativeParty;
    /**
     * The TaxTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTaxTotal
     */
    public $TaxTotal;
    /**
     * The UUID
     * Meta informations extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UUID;
    /**
     * The WithholdingTaxTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTaxTotal
     */
    public $WithholdingTaxTotal;
    /**
     * Constructor method for InvoiceBody
     * @uses InvoiceBody::setAccountingCost()
     * @uses InvoiceBody::setAccountingCustomerParty()
     * @uses InvoiceBody::setAccountingSupplierParty()
     * @uses InvoiceBody::setAdditionalDocumentReference()
     * @uses InvoiceBody::setAllowanceCharge()
     * @uses InvoiceBody::setAllowanceCharges()
     * @uses InvoiceBody::setBillingReference()
     * @uses InvoiceBody::setBuyerCustomerParty()
     * @uses InvoiceBody::setContractDocumentReference()
     * @uses InvoiceBody::setCopyIndicator()
     * @uses InvoiceBody::setDelivery()
     * @uses InvoiceBody::setDespatchDocumentReference()
     * @uses InvoiceBody::setDocumentCurrencyCode()
     * @uses InvoiceBody::setID()
     * @uses InvoiceBody::setInvoiceLine()
     * @uses InvoiceBody::setInvoicePeriod()
     * @uses InvoiceBody::setInvoiceTypeCode()
     * @uses InvoiceBody::setIssueDateTime()
     * @uses InvoiceBody::setLegalMonetaryTotal()
     * @uses InvoiceBody::setNotes()
     * @uses InvoiceBody::setOrderReference()
     * @uses InvoiceBody::setOriginatorDocumentReference()
     * @uses InvoiceBody::setPaymentAlternativeCurrencyCode()
     * @uses InvoiceBody::setPaymentAlternativeExchangeRate()
     * @uses InvoiceBody::setPaymentCurrencyCode()
     * @uses InvoiceBody::setPaymentExchangeRate()
     * @uses InvoiceBody::setPaymentMeans()
     * @uses InvoiceBody::setPaymentTerms()
     * @uses InvoiceBody::setPricingCurrencyCode()
     * @uses InvoiceBody::setPricingExchangeRate()
     * @uses InvoiceBody::setProfileID()
     * @uses InvoiceBody::setReceiptDocumentReference()
     * @uses InvoiceBody::setSellerSupplierParty()
     * @uses InvoiceBody::setTaxCurrencyCode()
     * @uses InvoiceBody::setTaxExchangeRate()
     * @uses InvoiceBody::setTaxRepresentativeParty()
     * @uses InvoiceBody::setTaxTotal()
     * @uses InvoiceBody::setUUID()
     * @uses InvoiceBody::setWithholdingTaxTotal()
     * @param string $accountingCost
     * @param \StructType\CustomerParty $accountingCustomerParty
     * @param \StructType\SupplierParty $accountingSupplierParty
     * @param \ArrayType\ArrayOfDocumentReference $additionalDocumentReference
     * @param \StructType\AllowanceCharge $allowanceCharge
     * @param \ArrayType\ArrayOfAllowanceCharge $allowanceCharges
     * @param \ArrayType\ArrayOfBillingReference $billingReference
     * @param \StructType\Party $buyerCustomerParty
     * @param \ArrayType\ArrayOfDocumentReference $contractDocumentReference
     * @param bool $copyIndicator
     * @param \ArrayType\ArrayOfDelivery $delivery
     * @param \ArrayType\ArrayOfDocumentReference $despatchDocumentReference
     * @param string $documentCurrencyCode
     * @param string $iD
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLine
     * @param \StructType\Period $invoicePeriod
     * @param int $invoiceTypeCode
     * @param string $issueDateTime
     * @param \StructType\MonetaryTotal $legalMonetaryTotal
     * @param \ArrayType\ArrayOfstring $notes
     * @param \StructType\OrderReference $orderReference
     * @param \ArrayType\ArrayOfDocumentReference $originatorDocumentReference
     * @param string $paymentAlternativeCurrencyCode
     * @param \StructType\ExchangeRate $paymentAlternativeExchangeRate
     * @param string $paymentCurrencyCode
     * @param \StructType\ExchangeRate $paymentExchangeRate
     * @param \ArrayType\ArrayOfPaymentMeans $paymentMeans
     * @param \StructType\PaymentTerms $paymentTerms
     * @param string $pricingCurrencyCode
     * @param \StructType\ExchangeRate $pricingExchangeRate
     * @param int $profileID
     * @param \ArrayType\ArrayOfDocumentReference $receiptDocumentReference
     * @param \StructType\Party $sellerSupplierParty
     * @param string $taxCurrencyCode
     * @param \StructType\ExchangeRate $taxExchangeRate
     * @param \StructType\Party $taxRepresentativeParty
     * @param \ArrayType\ArrayOfTaxTotal $taxTotal
     * @param string $uUID
     * @param \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal
     */
    public function __construct($accountingCost = null, \StructType\CustomerParty $accountingCustomerParty = null, \StructType\SupplierParty $accountingSupplierParty = null, \ArrayType\ArrayOfDocumentReference $additionalDocumentReference = null, \StructType\AllowanceCharge $allowanceCharge = null, \ArrayType\ArrayOfAllowanceCharge $allowanceCharges = null, \ArrayType\ArrayOfBillingReference $billingReference = null, \StructType\Party $buyerCustomerParty = null, \ArrayType\ArrayOfDocumentReference $contractDocumentReference = null, $copyIndicator = null, \ArrayType\ArrayOfDelivery $delivery = null, \ArrayType\ArrayOfDocumentReference $despatchDocumentReference = null, $documentCurrencyCode = null, $iD = null, \ArrayType\ArrayOfInvoiceLine $invoiceLine = null, \StructType\Period $invoicePeriod = null, $invoiceTypeCode = null, $issueDateTime = null, \StructType\MonetaryTotal $legalMonetaryTotal = null, \ArrayType\ArrayOfstring $notes = null, \StructType\OrderReference $orderReference = null, \ArrayType\ArrayOfDocumentReference $originatorDocumentReference = null, $paymentAlternativeCurrencyCode = null, \StructType\ExchangeRate $paymentAlternativeExchangeRate = null, $paymentCurrencyCode = null, \StructType\ExchangeRate $paymentExchangeRate = null, \ArrayType\ArrayOfPaymentMeans $paymentMeans = null, \StructType\PaymentTerms $paymentTerms = null, $pricingCurrencyCode = null, \StructType\ExchangeRate $pricingExchangeRate = null, $profileID = null, \ArrayType\ArrayOfDocumentReference $receiptDocumentReference = null, \StructType\Party $sellerSupplierParty = null, $taxCurrencyCode = null, \StructType\ExchangeRate $taxExchangeRate = null, \StructType\Party $taxRepresentativeParty = null, \ArrayType\ArrayOfTaxTotal $taxTotal = null, $uUID = null, \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal = null)
    {
        $this
            ->setAccountingCost($accountingCost)
            ->setAccountingCustomerParty($accountingCustomerParty)
            ->setAccountingSupplierParty($accountingSupplierParty)
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setAllowanceCharge($allowanceCharge)
            ->setAllowanceCharges($allowanceCharges)
            ->setBillingReference($billingReference)
            ->setBuyerCustomerParty($buyerCustomerParty)
            ->setContractDocumentReference($contractDocumentReference)
            ->setCopyIndicator($copyIndicator)
            ->setDelivery($delivery)
            ->setDespatchDocumentReference($despatchDocumentReference)
            ->setDocumentCurrencyCode($documentCurrencyCode)
            ->setID($iD)
            ->setInvoiceLine($invoiceLine)
            ->setInvoicePeriod($invoicePeriod)
            ->setInvoiceTypeCode($invoiceTypeCode)
            ->setIssueDateTime($issueDateTime)
            ->setLegalMonetaryTotal($legalMonetaryTotal)
            ->setNotes($notes)
            ->setOrderReference($orderReference)
            ->setOriginatorDocumentReference($originatorDocumentReference)
            ->setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode)
            ->setPaymentAlternativeExchangeRate($paymentAlternativeExchangeRate)
            ->setPaymentCurrencyCode($paymentCurrencyCode)
            ->setPaymentExchangeRate($paymentExchangeRate)
            ->setPaymentMeans($paymentMeans)
            ->setPaymentTerms($paymentTerms)
            ->setPricingCurrencyCode($pricingCurrencyCode)
            ->setPricingExchangeRate($pricingExchangeRate)
            ->setProfileID($profileID)
            ->setReceiptDocumentReference($receiptDocumentReference)
            ->setSellerSupplierParty($sellerSupplierParty)
            ->setTaxCurrencyCode($taxCurrencyCode)
            ->setTaxExchangeRate($taxExchangeRate)
            ->setTaxRepresentativeParty($taxRepresentativeParty)
            ->setTaxTotal($taxTotal)
            ->setUUID($uUID)
            ->setWithholdingTaxTotal($withholdingTaxTotal);
    }
    /**
     * Get AccountingCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountingCost()
    {
        return isset($this->AccountingCost) ? $this->AccountingCost : null;
    }
    /**
     * Set AccountingCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountingCost
     * @return \StructType\InvoiceBody
     */
    public function setAccountingCost($accountingCost = null)
    {
        // validation for constraint: string
        if (!is_null($accountingCost) && !is_string($accountingCost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountingCost, true), gettype($accountingCost)), __LINE__);
        }
        if (is_null($accountingCost) || (is_array($accountingCost) && empty($accountingCost))) {
            unset($this->AccountingCost);
        } else {
            $this->AccountingCost = $accountingCost;
        }
        return $this;
    }
    /**
     * Get AccountingCustomerParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerParty|null
     */
    public function getAccountingCustomerParty()
    {
        return isset($this->AccountingCustomerParty) ? $this->AccountingCustomerParty : null;
    }
    /**
     * Set AccountingCustomerParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerParty $accountingCustomerParty
     * @return \StructType\InvoiceBody
     */
    public function setAccountingCustomerParty(\StructType\CustomerParty $accountingCustomerParty = null)
    {
        if (is_null($accountingCustomerParty) || (is_array($accountingCustomerParty) && empty($accountingCustomerParty))) {
            unset($this->AccountingCustomerParty);
        } else {
            $this->AccountingCustomerParty = $accountingCustomerParty;
        }
        return $this;
    }
    /**
     * Get AccountingSupplierParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\SupplierParty|null
     */
    public function getAccountingSupplierParty()
    {
        return isset($this->AccountingSupplierParty) ? $this->AccountingSupplierParty : null;
    }
    /**
     * Set AccountingSupplierParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\SupplierParty $accountingSupplierParty
     * @return \StructType\InvoiceBody
     */
    public function setAccountingSupplierParty(\StructType\SupplierParty $accountingSupplierParty = null)
    {
        if (is_null($accountingSupplierParty) || (is_array($accountingSupplierParty) && empty($accountingSupplierParty))) {
            unset($this->AccountingSupplierParty);
        } else {
            $this->AccountingSupplierParty = $accountingSupplierParty;
        }
        return $this;
    }
    /**
     * Get AdditionalDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getAdditionalDocumentReference()
    {
        return isset($this->AdditionalDocumentReference) ? $this->AdditionalDocumentReference : null;
    }
    /**
     * Set AdditionalDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $additionalDocumentReference
     * @return \StructType\InvoiceBody
     */
    public function setAdditionalDocumentReference(\ArrayType\ArrayOfDocumentReference $additionalDocumentReference = null)
    {
        if (is_null($additionalDocumentReference) || (is_array($additionalDocumentReference) && empty($additionalDocumentReference))) {
            unset($this->AdditionalDocumentReference);
        } else {
            $this->AdditionalDocumentReference = $additionalDocumentReference;
        }
        return $this;
    }
    /**
     * Get AllowanceCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AllowanceCharge|null
     */
    public function getAllowanceCharge()
    {
        return isset($this->AllowanceCharge) ? $this->AllowanceCharge : null;
    }
    /**
     * Set AllowanceCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\AllowanceCharge $allowanceCharge
     * @return \StructType\InvoiceBody
     */
    public function setAllowanceCharge(\StructType\AllowanceCharge $allowanceCharge = null)
    {
        if (is_null($allowanceCharge) || (is_array($allowanceCharge) && empty($allowanceCharge))) {
            unset($this->AllowanceCharge);
        } else {
            $this->AllowanceCharge = $allowanceCharge;
        }
        return $this;
    }
    /**
     * Get AllowanceCharges value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAllowanceCharge|null
     */
    public function getAllowanceCharges()
    {
        return isset($this->AllowanceCharges) ? $this->AllowanceCharges : null;
    }
    /**
     * Set AllowanceCharges value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAllowanceCharge $allowanceCharges
     * @return \StructType\InvoiceBody
     */
    public function setAllowanceCharges(\ArrayType\ArrayOfAllowanceCharge $allowanceCharges = null)
    {
        if (is_null($allowanceCharges) || (is_array($allowanceCharges) && empty($allowanceCharges))) {
            unset($this->AllowanceCharges);
        } else {
            $this->AllowanceCharges = $allowanceCharges;
        }
        return $this;
    }
    /**
     * Get BillingReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBillingReference|null
     */
    public function getBillingReference()
    {
        return isset($this->BillingReference) ? $this->BillingReference : null;
    }
    /**
     * Set BillingReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBillingReference $billingReference
     * @return \StructType\InvoiceBody
     */
    public function setBillingReference(\ArrayType\ArrayOfBillingReference $billingReference = null)
    {
        if (is_null($billingReference) || (is_array($billingReference) && empty($billingReference))) {
            unset($this->BillingReference);
        } else {
            $this->BillingReference = $billingReference;
        }
        return $this;
    }
    /**
     * Get BuyerCustomerParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getBuyerCustomerParty()
    {
        return isset($this->BuyerCustomerParty) ? $this->BuyerCustomerParty : null;
    }
    /**
     * Set BuyerCustomerParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $buyerCustomerParty
     * @return \StructType\InvoiceBody
     */
    public function setBuyerCustomerParty(\StructType\Party $buyerCustomerParty = null)
    {
        if (is_null($buyerCustomerParty) || (is_array($buyerCustomerParty) && empty($buyerCustomerParty))) {
            unset($this->BuyerCustomerParty);
        } else {
            $this->BuyerCustomerParty = $buyerCustomerParty;
        }
        return $this;
    }
    /**
     * Get ContractDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getContractDocumentReference()
    {
        return isset($this->ContractDocumentReference) ? $this->ContractDocumentReference : null;
    }
    /**
     * Set ContractDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $contractDocumentReference
     * @return \StructType\InvoiceBody
     */
    public function setContractDocumentReference(\ArrayType\ArrayOfDocumentReference $contractDocumentReference = null)
    {
        if (is_null($contractDocumentReference) || (is_array($contractDocumentReference) && empty($contractDocumentReference))) {
            unset($this->ContractDocumentReference);
        } else {
            $this->ContractDocumentReference = $contractDocumentReference;
        }
        return $this;
    }
    /**
     * Get CopyIndicator value
     * @return bool|null
     */
    public function getCopyIndicator()
    {
        return $this->CopyIndicator;
    }
    /**
     * Set CopyIndicator value
     * @param bool $copyIndicator
     * @return \StructType\InvoiceBody
     */
    public function setCopyIndicator($copyIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($copyIndicator) && !is_bool($copyIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($copyIndicator, true), gettype($copyIndicator)), __LINE__);
        }
        $this->CopyIndicator = $copyIndicator;
        return $this;
    }
    /**
     * Get Delivery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDelivery|null
     */
    public function getDelivery()
    {
        return isset($this->Delivery) ? $this->Delivery : null;
    }
    /**
     * Set Delivery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDelivery $delivery
     * @return \StructType\InvoiceBody
     */
    public function setDelivery(\ArrayType\ArrayOfDelivery $delivery = null)
    {
        if (is_null($delivery) || (is_array($delivery) && empty($delivery))) {
            unset($this->Delivery);
        } else {
            $this->Delivery = $delivery;
        }
        return $this;
    }
    /**
     * Get DespatchDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getDespatchDocumentReference()
    {
        return isset($this->DespatchDocumentReference) ? $this->DespatchDocumentReference : null;
    }
    /**
     * Set DespatchDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $despatchDocumentReference
     * @return \StructType\InvoiceBody
     */
    public function setDespatchDocumentReference(\ArrayType\ArrayOfDocumentReference $despatchDocumentReference = null)
    {
        if (is_null($despatchDocumentReference) || (is_array($despatchDocumentReference) && empty($despatchDocumentReference))) {
            unset($this->DespatchDocumentReference);
        } else {
            $this->DespatchDocumentReference = $despatchDocumentReference;
        }
        return $this;
    }
    /**
     * Get DocumentCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentCurrencyCode()
    {
        return isset($this->DocumentCurrencyCode) ? $this->DocumentCurrencyCode : null;
    }
    /**
     * Set DocumentCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentCurrencyCode
     * @return \StructType\InvoiceBody
     */
    public function setDocumentCurrencyCode($documentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentCurrencyCode) && !is_string($documentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentCurrencyCode, true), gettype($documentCurrencyCode)), __LINE__);
        }
        if (is_null($documentCurrencyCode) || (is_array($documentCurrencyCode) && empty($documentCurrencyCode))) {
            unset($this->DocumentCurrencyCode);
        } else {
            $this->DocumentCurrencyCode = $documentCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\InvoiceBody
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get InvoiceLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInvoiceLine|null
     */
    public function getInvoiceLine()
    {
        return isset($this->InvoiceLine) ? $this->InvoiceLine : null;
    }
    /**
     * Set InvoiceLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLine
     * @return \StructType\InvoiceBody
     */
    public function setInvoiceLine(\ArrayType\ArrayOfInvoiceLine $invoiceLine = null)
    {
        if (is_null($invoiceLine) || (is_array($invoiceLine) && empty($invoiceLine))) {
            unset($this->InvoiceLine);
        } else {
            $this->InvoiceLine = $invoiceLine;
        }
        return $this;
    }
    /**
     * Get InvoicePeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period|null
     */
    public function getInvoicePeriod()
    {
        return isset($this->InvoicePeriod) ? $this->InvoicePeriod : null;
    }
    /**
     * Set InvoicePeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Period $invoicePeriod
     * @return \StructType\InvoiceBody
     */
    public function setInvoicePeriod(\StructType\Period $invoicePeriod = null)
    {
        if (is_null($invoicePeriod) || (is_array($invoicePeriod) && empty($invoicePeriod))) {
            unset($this->InvoicePeriod);
        } else {
            $this->InvoicePeriod = $invoicePeriod;
        }
        return $this;
    }
    /**
     * Get InvoiceTypeCode value
     * @return int|null
     */
    public function getInvoiceTypeCode()
    {
        return $this->InvoiceTypeCode;
    }
    /**
     * Set InvoiceTypeCode value
     * @param int $invoiceTypeCode
     * @return \StructType\InvoiceBody
     */
    public function setInvoiceTypeCode($invoiceTypeCode = null)
    {
        // validation for constraint: int
        if (!is_null($invoiceTypeCode) && !(is_int($invoiceTypeCode) || ctype_digit($invoiceTypeCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($invoiceTypeCode, true), gettype($invoiceTypeCode)), __LINE__);
        }
        $this->InvoiceTypeCode = $invoiceTypeCode;
        return $this;
    }
    /**
     * Get IssueDateTime value
     * @return string|null
     */
    public function getIssueDateTime()
    {
        return $this->IssueDateTime;
    }
    /**
     * Set IssueDateTime value
     * @param string $issueDateTime
     * @return \StructType\InvoiceBody
     */
    public function setIssueDateTime($issueDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($issueDateTime) && !is_string($issueDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDateTime, true), gettype($issueDateTime)), __LINE__);
        }
        $this->IssueDateTime = $issueDateTime;
        return $this;
    }
    /**
     * Get LegalMonetaryTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MonetaryTotal|null
     */
    public function getLegalMonetaryTotal()
    {
        return isset($this->LegalMonetaryTotal) ? $this->LegalMonetaryTotal : null;
    }
    /**
     * Set LegalMonetaryTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MonetaryTotal $legalMonetaryTotal
     * @return \StructType\InvoiceBody
     */
    public function setLegalMonetaryTotal(\StructType\MonetaryTotal $legalMonetaryTotal = null)
    {
        if (is_null($legalMonetaryTotal) || (is_array($legalMonetaryTotal) && empty($legalMonetaryTotal))) {
            unset($this->LegalMonetaryTotal);
        } else {
            $this->LegalMonetaryTotal = $legalMonetaryTotal;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $notes
     * @return \StructType\InvoiceBody
     */
    public function setNotes(\ArrayType\ArrayOfstring $notes = null)
    {
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OrderReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderReference|null
     */
    public function getOrderReference()
    {
        return isset($this->OrderReference) ? $this->OrderReference : null;
    }
    /**
     * Set OrderReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\OrderReference $orderReference
     * @return \StructType\InvoiceBody
     */
    public function setOrderReference(\StructType\OrderReference $orderReference = null)
    {
        if (is_null($orderReference) || (is_array($orderReference) && empty($orderReference))) {
            unset($this->OrderReference);
        } else {
            $this->OrderReference = $orderReference;
        }
        return $this;
    }
    /**
     * Get OriginatorDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getOriginatorDocumentReference()
    {
        return isset($this->OriginatorDocumentReference) ? $this->OriginatorDocumentReference : null;
    }
    /**
     * Set OriginatorDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $originatorDocumentReference
     * @return \StructType\InvoiceBody
     */
    public function setOriginatorDocumentReference(\ArrayType\ArrayOfDocumentReference $originatorDocumentReference = null)
    {
        if (is_null($originatorDocumentReference) || (is_array($originatorDocumentReference) && empty($originatorDocumentReference))) {
            unset($this->OriginatorDocumentReference);
        } else {
            $this->OriginatorDocumentReference = $originatorDocumentReference;
        }
        return $this;
    }
    /**
     * Get PaymentAlternativeCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentAlternativeCurrencyCode()
    {
        return isset($this->PaymentAlternativeCurrencyCode) ? $this->PaymentAlternativeCurrencyCode : null;
    }
    /**
     * Set PaymentAlternativeCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentAlternativeCurrencyCode
     * @return \StructType\InvoiceBody
     */
    public function setPaymentAlternativeCurrencyCode($paymentAlternativeCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentAlternativeCurrencyCode) && !is_string($paymentAlternativeCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentAlternativeCurrencyCode, true), gettype($paymentAlternativeCurrencyCode)), __LINE__);
        }
        if (is_null($paymentAlternativeCurrencyCode) || (is_array($paymentAlternativeCurrencyCode) && empty($paymentAlternativeCurrencyCode))) {
            unset($this->PaymentAlternativeCurrencyCode);
        } else {
            $this->PaymentAlternativeCurrencyCode = $paymentAlternativeCurrencyCode;
        }
        return $this;
    }
    /**
     * Get PaymentAlternativeExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExchangeRate|null
     */
    public function getPaymentAlternativeExchangeRate()
    {
        return isset($this->PaymentAlternativeExchangeRate) ? $this->PaymentAlternativeExchangeRate : null;
    }
    /**
     * Set PaymentAlternativeExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExchangeRate $paymentAlternativeExchangeRate
     * @return \StructType\InvoiceBody
     */
    public function setPaymentAlternativeExchangeRate(\StructType\ExchangeRate $paymentAlternativeExchangeRate = null)
    {
        if (is_null($paymentAlternativeExchangeRate) || (is_array($paymentAlternativeExchangeRate) && empty($paymentAlternativeExchangeRate))) {
            unset($this->PaymentAlternativeExchangeRate);
        } else {
            $this->PaymentAlternativeExchangeRate = $paymentAlternativeExchangeRate;
        }
        return $this;
    }
    /**
     * Get PaymentCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentCurrencyCode()
    {
        return isset($this->PaymentCurrencyCode) ? $this->PaymentCurrencyCode : null;
    }
    /**
     * Set PaymentCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentCurrencyCode
     * @return \StructType\InvoiceBody
     */
    public function setPaymentCurrencyCode($paymentCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($paymentCurrencyCode) && !is_string($paymentCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentCurrencyCode, true), gettype($paymentCurrencyCode)), __LINE__);
        }
        if (is_null($paymentCurrencyCode) || (is_array($paymentCurrencyCode) && empty($paymentCurrencyCode))) {
            unset($this->PaymentCurrencyCode);
        } else {
            $this->PaymentCurrencyCode = $paymentCurrencyCode;
        }
        return $this;
    }
    /**
     * Get PaymentExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExchangeRate|null
     */
    public function getPaymentExchangeRate()
    {
        return isset($this->PaymentExchangeRate) ? $this->PaymentExchangeRate : null;
    }
    /**
     * Set PaymentExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExchangeRate $paymentExchangeRate
     * @return \StructType\InvoiceBody
     */
    public function setPaymentExchangeRate(\StructType\ExchangeRate $paymentExchangeRate = null)
    {
        if (is_null($paymentExchangeRate) || (is_array($paymentExchangeRate) && empty($paymentExchangeRate))) {
            unset($this->PaymentExchangeRate);
        } else {
            $this->PaymentExchangeRate = $paymentExchangeRate;
        }
        return $this;
    }
    /**
     * Get PaymentMeans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPaymentMeans|null
     */
    public function getPaymentMeans()
    {
        return isset($this->PaymentMeans) ? $this->PaymentMeans : null;
    }
    /**
     * Set PaymentMeans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPaymentMeans $paymentMeans
     * @return \StructType\InvoiceBody
     */
    public function setPaymentMeans(\ArrayType\ArrayOfPaymentMeans $paymentMeans = null)
    {
        if (is_null($paymentMeans) || (is_array($paymentMeans) && empty($paymentMeans))) {
            unset($this->PaymentMeans);
        } else {
            $this->PaymentMeans = $paymentMeans;
        }
        return $this;
    }
    /**
     * Get PaymentTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaymentTerms|null
     */
    public function getPaymentTerms()
    {
        return isset($this->PaymentTerms) ? $this->PaymentTerms : null;
    }
    /**
     * Set PaymentTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\PaymentTerms $paymentTerms
     * @return \StructType\InvoiceBody
     */
    public function setPaymentTerms(\StructType\PaymentTerms $paymentTerms = null)
    {
        if (is_null($paymentTerms) || (is_array($paymentTerms) && empty($paymentTerms))) {
            unset($this->PaymentTerms);
        } else {
            $this->PaymentTerms = $paymentTerms;
        }
        return $this;
    }
    /**
     * Get PricingCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPricingCurrencyCode()
    {
        return isset($this->PricingCurrencyCode) ? $this->PricingCurrencyCode : null;
    }
    /**
     * Set PricingCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pricingCurrencyCode
     * @return \StructType\InvoiceBody
     */
    public function setPricingCurrencyCode($pricingCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($pricingCurrencyCode) && !is_string($pricingCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingCurrencyCode, true), gettype($pricingCurrencyCode)), __LINE__);
        }
        if (is_null($pricingCurrencyCode) || (is_array($pricingCurrencyCode) && empty($pricingCurrencyCode))) {
            unset($this->PricingCurrencyCode);
        } else {
            $this->PricingCurrencyCode = $pricingCurrencyCode;
        }
        return $this;
    }
    /**
     * Get PricingExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExchangeRate|null
     */
    public function getPricingExchangeRate()
    {
        return isset($this->PricingExchangeRate) ? $this->PricingExchangeRate : null;
    }
    /**
     * Set PricingExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExchangeRate $pricingExchangeRate
     * @return \StructType\InvoiceBody
     */
    public function setPricingExchangeRate(\StructType\ExchangeRate $pricingExchangeRate = null)
    {
        if (is_null($pricingExchangeRate) || (is_array($pricingExchangeRate) && empty($pricingExchangeRate))) {
            unset($this->PricingExchangeRate);
        } else {
            $this->PricingExchangeRate = $pricingExchangeRate;
        }
        return $this;
    }
    /**
     * Get ProfileID value
     * @return int|null
     */
    public function getProfileID()
    {
        return $this->ProfileID;
    }
    /**
     * Set ProfileID value
     * @param int $profileID
     * @return \StructType\InvoiceBody
     */
    public function setProfileID($profileID = null)
    {
        // validation for constraint: int
        if (!is_null($profileID) && !(is_int($profileID) || ctype_digit($profileID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($profileID, true), gettype($profileID)), __LINE__);
        }
        $this->ProfileID = $profileID;
        return $this;
    }
    /**
     * Get ReceiptDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDocumentReference|null
     */
    public function getReceiptDocumentReference()
    {
        return isset($this->ReceiptDocumentReference) ? $this->ReceiptDocumentReference : null;
    }
    /**
     * Set ReceiptDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDocumentReference $receiptDocumentReference
     * @return \StructType\InvoiceBody
     */
    public function setReceiptDocumentReference(\ArrayType\ArrayOfDocumentReference $receiptDocumentReference = null)
    {
        if (is_null($receiptDocumentReference) || (is_array($receiptDocumentReference) && empty($receiptDocumentReference))) {
            unset($this->ReceiptDocumentReference);
        } else {
            $this->ReceiptDocumentReference = $receiptDocumentReference;
        }
        return $this;
    }
    /**
     * Get SellerSupplierParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getSellerSupplierParty()
    {
        return isset($this->SellerSupplierParty) ? $this->SellerSupplierParty : null;
    }
    /**
     * Set SellerSupplierParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $sellerSupplierParty
     * @return \StructType\InvoiceBody
     */
    public function setSellerSupplierParty(\StructType\Party $sellerSupplierParty = null)
    {
        if (is_null($sellerSupplierParty) || (is_array($sellerSupplierParty) && empty($sellerSupplierParty))) {
            unset($this->SellerSupplierParty);
        } else {
            $this->SellerSupplierParty = $sellerSupplierParty;
        }
        return $this;
    }
    /**
     * Get TaxCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxCurrencyCode()
    {
        return isset($this->TaxCurrencyCode) ? $this->TaxCurrencyCode : null;
    }
    /**
     * Set TaxCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxCurrencyCode
     * @return \StructType\InvoiceBody
     */
    public function setTaxCurrencyCode($taxCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxCurrencyCode) && !is_string($taxCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxCurrencyCode, true), gettype($taxCurrencyCode)), __LINE__);
        }
        if (is_null($taxCurrencyCode) || (is_array($taxCurrencyCode) && empty($taxCurrencyCode))) {
            unset($this->TaxCurrencyCode);
        } else {
            $this->TaxCurrencyCode = $taxCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TaxExchangeRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ExchangeRate|null
     */
    public function getTaxExchangeRate()
    {
        return isset($this->TaxExchangeRate) ? $this->TaxExchangeRate : null;
    }
    /**
     * Set TaxExchangeRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\ExchangeRate $taxExchangeRate
     * @return \StructType\InvoiceBody
     */
    public function setTaxExchangeRate(\StructType\ExchangeRate $taxExchangeRate = null)
    {
        if (is_null($taxExchangeRate) || (is_array($taxExchangeRate) && empty($taxExchangeRate))) {
            unset($this->TaxExchangeRate);
        } else {
            $this->TaxExchangeRate = $taxExchangeRate;
        }
        return $this;
    }
    /**
     * Get TaxRepresentativeParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getTaxRepresentativeParty()
    {
        return isset($this->TaxRepresentativeParty) ? $this->TaxRepresentativeParty : null;
    }
    /**
     * Set TaxRepresentativeParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $taxRepresentativeParty
     * @return \StructType\InvoiceBody
     */
    public function setTaxRepresentativeParty(\StructType\Party $taxRepresentativeParty = null)
    {
        if (is_null($taxRepresentativeParty) || (is_array($taxRepresentativeParty) && empty($taxRepresentativeParty))) {
            unset($this->TaxRepresentativeParty);
        } else {
            $this->TaxRepresentativeParty = $taxRepresentativeParty;
        }
        return $this;
    }
    /**
     * Get TaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTaxTotal|null
     */
    public function getTaxTotal()
    {
        return isset($this->TaxTotal) ? $this->TaxTotal : null;
    }
    /**
     * Set TaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTaxTotal $taxTotal
     * @return \StructType\InvoiceBody
     */
    public function setTaxTotal(\ArrayType\ArrayOfTaxTotal $taxTotal = null)
    {
        if (is_null($taxTotal) || (is_array($taxTotal) && empty($taxTotal))) {
            unset($this->TaxTotal);
        } else {
            $this->TaxTotal = $taxTotal;
        }
        return $this;
    }
    /**
     * Get UUID value
     * @return string|null
     */
    public function getUUID()
    {
        return $this->UUID;
    }
    /**
     * Set UUID value
     * @param string $uUID
     * @return \StructType\InvoiceBody
     */
    public function setUUID($uUID = null)
    {
        // validation for constraint: string
        if (!is_null($uUID) && !is_string($uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uUID, true), gettype($uUID)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uUID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uUID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uUID, true)), __LINE__);
        }
        $this->UUID = $uUID;
        return $this;
    }
    /**
     * Get WithholdingTaxTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTaxTotal|null
     */
    public function getWithholdingTaxTotal()
    {
        return isset($this->WithholdingTaxTotal) ? $this->WithholdingTaxTotal : null;
    }
    /**
     * Set WithholdingTaxTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTaxTotal $withholdingTaxTotal
     * @return \StructType\InvoiceBody
     */
    public function setWithholdingTaxTotal(\ArrayType\ArrayOfTaxTotal $withholdingTaxTotal = null)
    {
        if (is_null($withholdingTaxTotal) || (is_array($withholdingTaxTotal) && empty($withholdingTaxTotal))) {
            unset($this->WithholdingTaxTotal);
        } else {
            $this->WithholdingTaxTotal = $withholdingTaxTotal;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InvoiceBody
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
