<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingInvoiceHeader StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IncomingInvoiceHeader
 * @subpackage Structs
 */
class IncomingInvoiceHeader extends AbstractStructBase
{
    /**
     * The HashValue
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HashValue;
    /**
     * The ReceiveDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReceiveDateTime;
    /**
     * The ReceiverAlias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReceiverAlias;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The SenderAlias
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderAlias;
    /**
     * The SenderIdentityNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SenderIdentityNumber;
    /**
     * The ViewUrl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewUrl;
    /**
     * Constructor method for IncomingInvoiceHeader
     * @uses IncomingInvoiceHeader::setHashValue()
     * @uses IncomingInvoiceHeader::setReceiveDateTime()
     * @uses IncomingInvoiceHeader::setReceiverAlias()
     * @uses IncomingInvoiceHeader::setReferenceNumber()
     * @uses IncomingInvoiceHeader::setSenderAlias()
     * @uses IncomingInvoiceHeader::setSenderIdentityNumber()
     * @uses IncomingInvoiceHeader::setViewUrl()
     * @param string $hashValue
     * @param string $receiveDateTime
     * @param string $receiverAlias
     * @param int $referenceNumber
     * @param string $senderAlias
     * @param string $senderIdentityNumber
     * @param string $viewUrl
     */
    public function __construct($hashValue = null, $receiveDateTime = null, $receiverAlias = null, $referenceNumber = null, $senderAlias = null, $senderIdentityNumber = null, $viewUrl = null)
    {
        $this
            ->setHashValue($hashValue)
            ->setReceiveDateTime($receiveDateTime)
            ->setReceiverAlias($receiverAlias)
            ->setReferenceNumber($referenceNumber)
            ->setSenderAlias($senderAlias)
            ->setSenderIdentityNumber($senderIdentityNumber)
            ->setViewUrl($viewUrl);
    }
    /**
     * Get HashValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHashValue()
    {
        return isset($this->HashValue) ? $this->HashValue : null;
    }
    /**
     * Set HashValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hashValue
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setHashValue($hashValue = null)
    {
        // validation for constraint: string
        if (!is_null($hashValue) && !is_string($hashValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hashValue, true), gettype($hashValue)), __LINE__);
        }
        if (is_null($hashValue) || (is_array($hashValue) && empty($hashValue))) {
            unset($this->HashValue);
        } else {
            $this->HashValue = $hashValue;
        }
        return $this;
    }
    /**
     * Get ReceiveDateTime value
     * @return string|null
     */
    public function getReceiveDateTime()
    {
        return $this->ReceiveDateTime;
    }
    /**
     * Set ReceiveDateTime value
     * @param string $receiveDateTime
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setReceiveDateTime($receiveDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($receiveDateTime) && !is_string($receiveDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiveDateTime, true), gettype($receiveDateTime)), __LINE__);
        }
        $this->ReceiveDateTime = $receiveDateTime;
        return $this;
    }
    /**
     * Get ReceiverAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReceiverAlias()
    {
        return isset($this->ReceiverAlias) ? $this->ReceiverAlias : null;
    }
    /**
     * Set ReceiverAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $receiverAlias
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setReceiverAlias($receiverAlias = null)
    {
        // validation for constraint: string
        if (!is_null($receiverAlias) && !is_string($receiverAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($receiverAlias, true), gettype($receiverAlias)), __LINE__);
        }
        if (is_null($receiverAlias) || (is_array($receiverAlias) && empty($receiverAlias))) {
            unset($this->ReceiverAlias);
        } else {
            $this->ReceiverAlias = $receiverAlias;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get SenderAlias value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderAlias()
    {
        return isset($this->SenderAlias) ? $this->SenderAlias : null;
    }
    /**
     * Set SenderAlias value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderAlias
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setSenderAlias($senderAlias = null)
    {
        // validation for constraint: string
        if (!is_null($senderAlias) && !is_string($senderAlias)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderAlias, true), gettype($senderAlias)), __LINE__);
        }
        if (is_null($senderAlias) || (is_array($senderAlias) && empty($senderAlias))) {
            unset($this->SenderAlias);
        } else {
            $this->SenderAlias = $senderAlias;
        }
        return $this;
    }
    /**
     * Get SenderIdentityNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSenderIdentityNumber()
    {
        return isset($this->SenderIdentityNumber) ? $this->SenderIdentityNumber : null;
    }
    /**
     * Set SenderIdentityNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $senderIdentityNumber
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setSenderIdentityNumber($senderIdentityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($senderIdentityNumber) && !is_string($senderIdentityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($senderIdentityNumber, true), gettype($senderIdentityNumber)), __LINE__);
        }
        if (is_null($senderIdentityNumber) || (is_array($senderIdentityNumber) && empty($senderIdentityNumber))) {
            unset($this->SenderIdentityNumber);
        } else {
            $this->SenderIdentityNumber = $senderIdentityNumber;
        }
        return $this;
    }
    /**
     * Get ViewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewUrl()
    {
        return isset($this->ViewUrl) ? $this->ViewUrl : null;
    }
    /**
     * Set ViewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewUrl
     * @return \StructType\IncomingInvoiceHeader
     */
    public function setViewUrl($viewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($viewUrl) && !is_string($viewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewUrl, true), gettype($viewUrl)), __LINE__);
        }
        if (is_null($viewUrl) || (is_array($viewUrl) && empty($viewUrl))) {
            unset($this->ViewUrl);
        } else {
            $this->ViewUrl = $viewUrl;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncomingInvoiceHeader
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
