<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncomingInvoice StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IncomingInvoice
 * @subpackage Structs
 */
class IncomingInvoice extends AbstractStructBase
{
    /**
     * The Body
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\InvoiceBody
     */
    public $Body;
    /**
     * The Header
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IncomingInvoiceHeader
     */
    public $Header;
    /**
     * The ViewContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewContent;
    /**
     * Constructor method for IncomingInvoice
     * @uses IncomingInvoice::setBody()
     * @uses IncomingInvoice::setHeader()
     * @uses IncomingInvoice::setViewContent()
     * @param \StructType\InvoiceBody $body
     * @param \StructType\IncomingInvoiceHeader $header
     * @param string $viewContent
     */
    public function __construct(\StructType\InvoiceBody $body = null, \StructType\IncomingInvoiceHeader $header = null, $viewContent = null)
    {
        $this
            ->setBody($body)
            ->setHeader($header)
            ->setViewContent($viewContent);
    }
    /**
     * Get Body value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\InvoiceBody|null
     */
    public function getBody()
    {
        return isset($this->Body) ? $this->Body : null;
    }
    /**
     * Set Body value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\InvoiceBody $body
     * @return \StructType\IncomingInvoice
     */
    public function setBody(\StructType\InvoiceBody $body = null)
    {
        if (is_null($body) || (is_array($body) && empty($body))) {
            unset($this->Body);
        } else {
            $this->Body = $body;
        }
        return $this;
    }
    /**
     * Get Header value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IncomingInvoiceHeader|null
     */
    public function getHeader()
    {
        return isset($this->Header) ? $this->Header : null;
    }
    /**
     * Set Header value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\IncomingInvoiceHeader $header
     * @return \StructType\IncomingInvoice
     */
    public function setHeader(\StructType\IncomingInvoiceHeader $header = null)
    {
        if (is_null($header) || (is_array($header) && empty($header))) {
            unset($this->Header);
        } else {
            $this->Header = $header;
        }
        return $this;
    }
    /**
     * Get ViewContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewContent()
    {
        return isset($this->ViewContent) ? $this->ViewContent : null;
    }
    /**
     * Set ViewContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewContent
     * @return \StructType\IncomingInvoice
     */
    public function setViewContent($viewContent = null)
    {
        // validation for constraint: string
        if (!is_null($viewContent) && !is_string($viewContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewContent, true), gettype($viewContent)), __LINE__);
        }
        if (is_null($viewContent) || (is_array($viewContent) && empty($viewContent))) {
            unset($this->ViewContent);
        } else {
            $this->ViewContent = $viewContent;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IncomingInvoice
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
