<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentityDocumentReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:IdentityDocumentReference
 * @subpackage Structs
 */
class IdentityDocumentReference extends AbstractStructBase
{
    /**
     * The Attachment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Attachment
     */
    public $Attachment;
    /**
     * The DocumentDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DocumentDescription;
    /**
     * The DocumentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentType;
    /**
     * The DocumentTypeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeCode;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The IssueDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The ValidityPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period
     */
    public $ValidityPeriod;
    /**
     * Constructor method for IdentityDocumentReference
     * @uses IdentityDocumentReference::setAttachment()
     * @uses IdentityDocumentReference::setDocumentDescription()
     * @uses IdentityDocumentReference::setDocumentType()
     * @uses IdentityDocumentReference::setDocumentTypeCode()
     * @uses IdentityDocumentReference::setID()
     * @uses IdentityDocumentReference::setIssueDate()
     * @uses IdentityDocumentReference::setValidityPeriod()
     * @param \StructType\Attachment $attachment
     * @param \ArrayType\ArrayOfstring $documentDescription
     * @param string $documentType
     * @param string $documentTypeCode
     * @param string $iD
     * @param string $issueDate
     * @param \StructType\Period $validityPeriod
     */
    public function __construct(\StructType\Attachment $attachment = null, \ArrayType\ArrayOfstring $documentDescription = null, $documentType = null, $documentTypeCode = null, $iD = null, $issueDate = null, \StructType\Period $validityPeriod = null)
    {
        $this
            ->setAttachment($attachment)
            ->setDocumentDescription($documentDescription)
            ->setDocumentType($documentType)
            ->setDocumentTypeCode($documentTypeCode)
            ->setID($iD)
            ->setIssueDate($issueDate)
            ->setValidityPeriod($validityPeriod);
    }
    /**
     * Get Attachment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Attachment|null
     */
    public function getAttachment()
    {
        return isset($this->Attachment) ? $this->Attachment : null;
    }
    /**
     * Set Attachment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Attachment $attachment
     * @return \StructType\IdentityDocumentReference
     */
    public function setAttachment(\StructType\Attachment $attachment = null)
    {
        if (is_null($attachment) || (is_array($attachment) && empty($attachment))) {
            unset($this->Attachment);
        } else {
            $this->Attachment = $attachment;
        }
        return $this;
    }
    /**
     * Get DocumentDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDocumentDescription()
    {
        return isset($this->DocumentDescription) ? $this->DocumentDescription : null;
    }
    /**
     * Set DocumentDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $documentDescription
     * @return \StructType\IdentityDocumentReference
     */
    public function setDocumentDescription(\ArrayType\ArrayOfstring $documentDescription = null)
    {
        if (is_null($documentDescription) || (is_array($documentDescription) && empty($documentDescription))) {
            unset($this->DocumentDescription);
        } else {
            $this->DocumentDescription = $documentDescription;
        }
        return $this;
    }
    /**
     * Get DocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentType()
    {
        return isset($this->DocumentType) ? $this->DocumentType : null;
    }
    /**
     * Set DocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentType
     * @return \StructType\IdentityDocumentReference
     */
    public function setDocumentType($documentType = null)
    {
        // validation for constraint: string
        if (!is_null($documentType) && !is_string($documentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentType, true), gettype($documentType)), __LINE__);
        }
        if (is_null($documentType) || (is_array($documentType) && empty($documentType))) {
            unset($this->DocumentType);
        } else {
            $this->DocumentType = $documentType;
        }
        return $this;
    }
    /**
     * Get DocumentTypeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeCode()
    {
        return isset($this->DocumentTypeCode) ? $this->DocumentTypeCode : null;
    }
    /**
     * Set DocumentTypeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeCode
     * @return \StructType\IdentityDocumentReference
     */
    public function setDocumentTypeCode($documentTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeCode) && !is_string($documentTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeCode, true), gettype($documentTypeCode)), __LINE__);
        }
        if (is_null($documentTypeCode) || (is_array($documentTypeCode) && empty($documentTypeCode))) {
            unset($this->DocumentTypeCode);
        } else {
            $this->DocumentTypeCode = $documentTypeCode;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\IdentityDocumentReference
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\IdentityDocumentReference
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get ValidityPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period|null
     */
    public function getValidityPeriod()
    {
        return isset($this->ValidityPeriod) ? $this->ValidityPeriod : null;
    }
    /**
     * Set ValidityPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Period $validityPeriod
     * @return \StructType\IdentityDocumentReference
     */
    public function setValidityPeriod(\StructType\Period $validityPeriod = null)
    {
        if (is_null($validityPeriod) || (is_array($validityPeriod) && empty($validityPeriod))) {
            unset($this->ValidityPeriod);
        } else {
            $this->ValidityPeriod = $validityPeriod;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\IdentityDocumentReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
