<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for HazardousGoodsTransit StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:HazardousGoodsTransit
 * @subpackage Structs
 */
class HazardousGoodsTransit extends AbstractStructBase
{
    /**
     * The HazardousRegulationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HazardousRegulationCode;
    /**
     * The InhalationToxicityZoneCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InhalationToxicityZoneCode;
    /**
     * The MaximumTemperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Temperature
     */
    public $MaximumTemperature;
    /**
     * The MinimumTemperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Temperature
     */
    public $MinimumTemperature;
    /**
     * The PackagingCriteriaCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PackagingCriteriaCode;
    /**
     * The TransportAuthorizationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportAuthorizationCode;
    /**
     * The TransportEmergencyCardCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransportEmergencyCardCode;
    /**
     * Constructor method for HazardousGoodsTransit
     * @uses HazardousGoodsTransit::setHazardousRegulationCode()
     * @uses HazardousGoodsTransit::setInhalationToxicityZoneCode()
     * @uses HazardousGoodsTransit::setMaximumTemperature()
     * @uses HazardousGoodsTransit::setMinimumTemperature()
     * @uses HazardousGoodsTransit::setPackagingCriteriaCode()
     * @uses HazardousGoodsTransit::setTransportAuthorizationCode()
     * @uses HazardousGoodsTransit::setTransportEmergencyCardCode()
     * @param string $hazardousRegulationCode
     * @param string $inhalationToxicityZoneCode
     * @param \StructType\Temperature $maximumTemperature
     * @param \StructType\Temperature $minimumTemperature
     * @param string $packagingCriteriaCode
     * @param string $transportAuthorizationCode
     * @param string $transportEmergencyCardCode
     */
    public function __construct($hazardousRegulationCode = null, $inhalationToxicityZoneCode = null, \StructType\Temperature $maximumTemperature = null, \StructType\Temperature $minimumTemperature = null, $packagingCriteriaCode = null, $transportAuthorizationCode = null, $transportEmergencyCardCode = null)
    {
        $this
            ->setHazardousRegulationCode($hazardousRegulationCode)
            ->setInhalationToxicityZoneCode($inhalationToxicityZoneCode)
            ->setMaximumTemperature($maximumTemperature)
            ->setMinimumTemperature($minimumTemperature)
            ->setPackagingCriteriaCode($packagingCriteriaCode)
            ->setTransportAuthorizationCode($transportAuthorizationCode)
            ->setTransportEmergencyCardCode($transportEmergencyCardCode);
    }
    /**
     * Get HazardousRegulationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHazardousRegulationCode()
    {
        return isset($this->HazardousRegulationCode) ? $this->HazardousRegulationCode : null;
    }
    /**
     * Set HazardousRegulationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hazardousRegulationCode
     * @return \StructType\HazardousGoodsTransit
     */
    public function setHazardousRegulationCode($hazardousRegulationCode = null)
    {
        // validation for constraint: string
        if (!is_null($hazardousRegulationCode) && !is_string($hazardousRegulationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hazardousRegulationCode, true), gettype($hazardousRegulationCode)), __LINE__);
        }
        if (is_null($hazardousRegulationCode) || (is_array($hazardousRegulationCode) && empty($hazardousRegulationCode))) {
            unset($this->HazardousRegulationCode);
        } else {
            $this->HazardousRegulationCode = $hazardousRegulationCode;
        }
        return $this;
    }
    /**
     * Get InhalationToxicityZoneCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInhalationToxicityZoneCode()
    {
        return isset($this->InhalationToxicityZoneCode) ? $this->InhalationToxicityZoneCode : null;
    }
    /**
     * Set InhalationToxicityZoneCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inhalationToxicityZoneCode
     * @return \StructType\HazardousGoodsTransit
     */
    public function setInhalationToxicityZoneCode($inhalationToxicityZoneCode = null)
    {
        // validation for constraint: string
        if (!is_null($inhalationToxicityZoneCode) && !is_string($inhalationToxicityZoneCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inhalationToxicityZoneCode, true), gettype($inhalationToxicityZoneCode)), __LINE__);
        }
        if (is_null($inhalationToxicityZoneCode) || (is_array($inhalationToxicityZoneCode) && empty($inhalationToxicityZoneCode))) {
            unset($this->InhalationToxicityZoneCode);
        } else {
            $this->InhalationToxicityZoneCode = $inhalationToxicityZoneCode;
        }
        return $this;
    }
    /**
     * Get MaximumTemperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Temperature|null
     */
    public function getMaximumTemperature()
    {
        return isset($this->MaximumTemperature) ? $this->MaximumTemperature : null;
    }
    /**
     * Set MaximumTemperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Temperature $maximumTemperature
     * @return \StructType\HazardousGoodsTransit
     */
    public function setMaximumTemperature(\StructType\Temperature $maximumTemperature = null)
    {
        if (is_null($maximumTemperature) || (is_array($maximumTemperature) && empty($maximumTemperature))) {
            unset($this->MaximumTemperature);
        } else {
            $this->MaximumTemperature = $maximumTemperature;
        }
        return $this;
    }
    /**
     * Get MinimumTemperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Temperature|null
     */
    public function getMinimumTemperature()
    {
        return isset($this->MinimumTemperature) ? $this->MinimumTemperature : null;
    }
    /**
     * Set MinimumTemperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Temperature $minimumTemperature
     * @return \StructType\HazardousGoodsTransit
     */
    public function setMinimumTemperature(\StructType\Temperature $minimumTemperature = null)
    {
        if (is_null($minimumTemperature) || (is_array($minimumTemperature) && empty($minimumTemperature))) {
            unset($this->MinimumTemperature);
        } else {
            $this->MinimumTemperature = $minimumTemperature;
        }
        return $this;
    }
    /**
     * Get PackagingCriteriaCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackagingCriteriaCode()
    {
        return isset($this->PackagingCriteriaCode) ? $this->PackagingCriteriaCode : null;
    }
    /**
     * Set PackagingCriteriaCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packagingCriteriaCode
     * @return \StructType\HazardousGoodsTransit
     */
    public function setPackagingCriteriaCode($packagingCriteriaCode = null)
    {
        // validation for constraint: string
        if (!is_null($packagingCriteriaCode) && !is_string($packagingCriteriaCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packagingCriteriaCode, true), gettype($packagingCriteriaCode)), __LINE__);
        }
        if (is_null($packagingCriteriaCode) || (is_array($packagingCriteriaCode) && empty($packagingCriteriaCode))) {
            unset($this->PackagingCriteriaCode);
        } else {
            $this->PackagingCriteriaCode = $packagingCriteriaCode;
        }
        return $this;
    }
    /**
     * Get TransportAuthorizationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportAuthorizationCode()
    {
        return isset($this->TransportAuthorizationCode) ? $this->TransportAuthorizationCode : null;
    }
    /**
     * Set TransportAuthorizationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportAuthorizationCode
     * @return \StructType\HazardousGoodsTransit
     */
    public function setTransportAuthorizationCode($transportAuthorizationCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportAuthorizationCode) && !is_string($transportAuthorizationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportAuthorizationCode, true), gettype($transportAuthorizationCode)), __LINE__);
        }
        if (is_null($transportAuthorizationCode) || (is_array($transportAuthorizationCode) && empty($transportAuthorizationCode))) {
            unset($this->TransportAuthorizationCode);
        } else {
            $this->TransportAuthorizationCode = $transportAuthorizationCode;
        }
        return $this;
    }
    /**
     * Get TransportEmergencyCardCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransportEmergencyCardCode()
    {
        return isset($this->TransportEmergencyCardCode) ? $this->TransportEmergencyCardCode : null;
    }
    /**
     * Set TransportEmergencyCardCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transportEmergencyCardCode
     * @return \StructType\HazardousGoodsTransit
     */
    public function setTransportEmergencyCardCode($transportEmergencyCardCode = null)
    {
        // validation for constraint: string
        if (!is_null($transportEmergencyCardCode) && !is_string($transportEmergencyCardCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transportEmergencyCardCode, true), gettype($transportEmergencyCardCode)), __LINE__);
        }
        if (is_null($transportEmergencyCardCode) || (is_array($transportEmergencyCardCode) && empty($transportEmergencyCardCode))) {
            unset($this->TransportEmergencyCardCode);
        } else {
            $this->TransportEmergencyCardCode = $transportEmergencyCardCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\HazardousGoodsTransit
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
