<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GoodsItem StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GoodsItem
 * @subpackage Structs
 */
class GoodsItem extends AbstractStructBase
{
    /**
     * The ChargableWeightMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $ChargableWeightMeasure;
    /**
     * The ChargeableQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ChargeableQuantity;
    /**
     * The CustomsImportClassifiedIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CustomsImportClassifiedIndicator;
    /**
     * The CustomsStatusCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomsStatusCode;
    /**
     * The CustomsTariffQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CustomsTariffQuantity;
    /**
     * The DeclaredCustomsValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredCustomsValueAmount;
    /**
     * The DeclaredForCarriageValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredForCarriageValueAmount;
    /**
     * The DeclaredStatisticsValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $DeclaredStatisticsValueAmount;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Description;
    /**
     * The FreeOnBoardValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $FreeOnBoardValueAmount;
    /**
     * The FreightAllowanceCharge
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfAllowanceCharge
     */
    public $FreightAllowanceCharge;
    /**
     * The GrossVolumeMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $GrossVolumeMeasure;
    /**
     * The GrossWeightMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $GrossWeightMeasure;
    /**
     * The HazardousRiskIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $HazardousRiskIndicator;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The InsuranceValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $InsuranceValueAmount;
    /**
     * The InvoiceLine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfInvoiceLine
     */
    public $InvoiceLine;
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfItem
     */
    public $Item;
    /**
     * The MeasurementDimension
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDimension
     */
    public $MeasurementDimension;
    /**
     * The NetVolumeMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $NetVolumeMeasure;
    /**
     * The NetWeightMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $NetWeightMeasure;
    /**
     * The OriginAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $OriginAddress;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Quantity;
    /**
     * The RequiredCustomsID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequiredCustomsID;
    /**
     * The ReturnableQuantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ReturnableQuantity;
    /**
     * The Temperature
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTemperature
     */
    public $Temperature;
    /**
     * The TraceID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TraceID;
    /**
     * The ValueAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $ValueAmount;
    /**
     * Constructor method for GoodsItem
     * @uses GoodsItem::setChargableWeightMeasure()
     * @uses GoodsItem::setChargeableQuantity()
     * @uses GoodsItem::setCustomsImportClassifiedIndicator()
     * @uses GoodsItem::setCustomsStatusCode()
     * @uses GoodsItem::setCustomsTariffQuantity()
     * @uses GoodsItem::setDeclaredCustomsValueAmount()
     * @uses GoodsItem::setDeclaredForCarriageValueAmount()
     * @uses GoodsItem::setDeclaredStatisticsValueAmount()
     * @uses GoodsItem::setDescription()
     * @uses GoodsItem::setFreeOnBoardValueAmount()
     * @uses GoodsItem::setFreightAllowanceCharge()
     * @uses GoodsItem::setGrossVolumeMeasure()
     * @uses GoodsItem::setGrossWeightMeasure()
     * @uses GoodsItem::setHazardousRiskIndicator()
     * @uses GoodsItem::setID()
     * @uses GoodsItem::setInsuranceValueAmount()
     * @uses GoodsItem::setInvoiceLine()
     * @uses GoodsItem::setItem()
     * @uses GoodsItem::setMeasurementDimension()
     * @uses GoodsItem::setNetVolumeMeasure()
     * @uses GoodsItem::setNetWeightMeasure()
     * @uses GoodsItem::setOriginAddress()
     * @uses GoodsItem::setQuantity()
     * @uses GoodsItem::setRequiredCustomsID()
     * @uses GoodsItem::setReturnableQuantity()
     * @uses GoodsItem::setTemperature()
     * @uses GoodsItem::setTraceID()
     * @uses GoodsItem::setValueAmount()
     * @param \StructType\Measure $chargableWeightMeasure
     * @param float $chargeableQuantity
     * @param bool $customsImportClassifiedIndicator
     * @param string $customsStatusCode
     * @param float $customsTariffQuantity
     * @param \StructType\Amount $declaredCustomsValueAmount
     * @param \StructType\Amount $declaredForCarriageValueAmount
     * @param \StructType\Amount $declaredStatisticsValueAmount
     * @param \ArrayType\ArrayOfstring $description
     * @param \StructType\Amount $freeOnBoardValueAmount
     * @param \ArrayType\ArrayOfAllowanceCharge $freightAllowanceCharge
     * @param \StructType\Measure $grossVolumeMeasure
     * @param \StructType\Measure $grossWeightMeasure
     * @param bool $hazardousRiskIndicator
     * @param string $iD
     * @param \StructType\Amount $insuranceValueAmount
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLine
     * @param \ArrayType\ArrayOfItem $item
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @param \StructType\Measure $netVolumeMeasure
     * @param \StructType\Measure $netWeightMeasure
     * @param \StructType\Address $originAddress
     * @param float $quantity
     * @param string $requiredCustomsID
     * @param float $returnableQuantity
     * @param \ArrayType\ArrayOfTemperature $temperature
     * @param string $traceID
     * @param \StructType\Amount $valueAmount
     */
    public function __construct(\StructType\Measure $chargableWeightMeasure = null, $chargeableQuantity = null, $customsImportClassifiedIndicator = null, $customsStatusCode = null, $customsTariffQuantity = null, \StructType\Amount $declaredCustomsValueAmount = null, \StructType\Amount $declaredForCarriageValueAmount = null, \StructType\Amount $declaredStatisticsValueAmount = null, \ArrayType\ArrayOfstring $description = null, \StructType\Amount $freeOnBoardValueAmount = null, \ArrayType\ArrayOfAllowanceCharge $freightAllowanceCharge = null, \StructType\Measure $grossVolumeMeasure = null, \StructType\Measure $grossWeightMeasure = null, $hazardousRiskIndicator = null, $iD = null, \StructType\Amount $insuranceValueAmount = null, \ArrayType\ArrayOfInvoiceLine $invoiceLine = null, \ArrayType\ArrayOfItem $item = null, \ArrayType\ArrayOfDimension $measurementDimension = null, \StructType\Measure $netVolumeMeasure = null, \StructType\Measure $netWeightMeasure = null, \StructType\Address $originAddress = null, $quantity = null, $requiredCustomsID = null, $returnableQuantity = null, \ArrayType\ArrayOfTemperature $temperature = null, $traceID = null, \StructType\Amount $valueAmount = null)
    {
        $this
            ->setChargableWeightMeasure($chargableWeightMeasure)
            ->setChargeableQuantity($chargeableQuantity)
            ->setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator)
            ->setCustomsStatusCode($customsStatusCode)
            ->setCustomsTariffQuantity($customsTariffQuantity)
            ->setDeclaredCustomsValueAmount($declaredCustomsValueAmount)
            ->setDeclaredForCarriageValueAmount($declaredForCarriageValueAmount)
            ->setDeclaredStatisticsValueAmount($declaredStatisticsValueAmount)
            ->setDescription($description)
            ->setFreeOnBoardValueAmount($freeOnBoardValueAmount)
            ->setFreightAllowanceCharge($freightAllowanceCharge)
            ->setGrossVolumeMeasure($grossVolumeMeasure)
            ->setGrossWeightMeasure($grossWeightMeasure)
            ->setHazardousRiskIndicator($hazardousRiskIndicator)
            ->setID($iD)
            ->setInsuranceValueAmount($insuranceValueAmount)
            ->setInvoiceLine($invoiceLine)
            ->setItem($item)
            ->setMeasurementDimension($measurementDimension)
            ->setNetVolumeMeasure($netVolumeMeasure)
            ->setNetWeightMeasure($netWeightMeasure)
            ->setOriginAddress($originAddress)
            ->setQuantity($quantity)
            ->setRequiredCustomsID($requiredCustomsID)
            ->setReturnableQuantity($returnableQuantity)
            ->setTemperature($temperature)
            ->setTraceID($traceID)
            ->setValueAmount($valueAmount);
    }
    /**
     * Get ChargableWeightMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getChargableWeightMeasure()
    {
        return isset($this->ChargableWeightMeasure) ? $this->ChargableWeightMeasure : null;
    }
    /**
     * Set ChargableWeightMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $chargableWeightMeasure
     * @return \StructType\GoodsItem
     */
    public function setChargableWeightMeasure(\StructType\Measure $chargableWeightMeasure = null)
    {
        if (is_null($chargableWeightMeasure) || (is_array($chargableWeightMeasure) && empty($chargableWeightMeasure))) {
            unset($this->ChargableWeightMeasure);
        } else {
            $this->ChargableWeightMeasure = $chargableWeightMeasure;
        }
        return $this;
    }
    /**
     * Get ChargeableQuantity value
     * @return float|null
     */
    public function getChargeableQuantity()
    {
        return $this->ChargeableQuantity;
    }
    /**
     * Set ChargeableQuantity value
     * @param float $chargeableQuantity
     * @return \StructType\GoodsItem
     */
    public function setChargeableQuantity($chargeableQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($chargeableQuantity) && !(is_float($chargeableQuantity) || is_numeric($chargeableQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($chargeableQuantity, true), gettype($chargeableQuantity)), __LINE__);
        }
        $this->ChargeableQuantity = $chargeableQuantity;
        return $this;
    }
    /**
     * Get CustomsImportClassifiedIndicator value
     * @return bool|null
     */
    public function getCustomsImportClassifiedIndicator()
    {
        return $this->CustomsImportClassifiedIndicator;
    }
    /**
     * Set CustomsImportClassifiedIndicator value
     * @param bool $customsImportClassifiedIndicator
     * @return \StructType\GoodsItem
     */
    public function setCustomsImportClassifiedIndicator($customsImportClassifiedIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($customsImportClassifiedIndicator) && !is_bool($customsImportClassifiedIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($customsImportClassifiedIndicator, true), gettype($customsImportClassifiedIndicator)), __LINE__);
        }
        $this->CustomsImportClassifiedIndicator = $customsImportClassifiedIndicator;
        return $this;
    }
    /**
     * Get CustomsStatusCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomsStatusCode()
    {
        return isset($this->CustomsStatusCode) ? $this->CustomsStatusCode : null;
    }
    /**
     * Set CustomsStatusCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customsStatusCode
     * @return \StructType\GoodsItem
     */
    public function setCustomsStatusCode($customsStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($customsStatusCode) && !is_string($customsStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customsStatusCode, true), gettype($customsStatusCode)), __LINE__);
        }
        if (is_null($customsStatusCode) || (is_array($customsStatusCode) && empty($customsStatusCode))) {
            unset($this->CustomsStatusCode);
        } else {
            $this->CustomsStatusCode = $customsStatusCode;
        }
        return $this;
    }
    /**
     * Get CustomsTariffQuantity value
     * @return float|null
     */
    public function getCustomsTariffQuantity()
    {
        return $this->CustomsTariffQuantity;
    }
    /**
     * Set CustomsTariffQuantity value
     * @param float $customsTariffQuantity
     * @return \StructType\GoodsItem
     */
    public function setCustomsTariffQuantity($customsTariffQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($customsTariffQuantity) && !(is_float($customsTariffQuantity) || is_numeric($customsTariffQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($customsTariffQuantity, true), gettype($customsTariffQuantity)), __LINE__);
        }
        $this->CustomsTariffQuantity = $customsTariffQuantity;
        return $this;
    }
    /**
     * Get DeclaredCustomsValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredCustomsValueAmount()
    {
        return isset($this->DeclaredCustomsValueAmount) ? $this->DeclaredCustomsValueAmount : null;
    }
    /**
     * Set DeclaredCustomsValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredCustomsValueAmount
     * @return \StructType\GoodsItem
     */
    public function setDeclaredCustomsValueAmount(\StructType\Amount $declaredCustomsValueAmount = null)
    {
        if (is_null($declaredCustomsValueAmount) || (is_array($declaredCustomsValueAmount) && empty($declaredCustomsValueAmount))) {
            unset($this->DeclaredCustomsValueAmount);
        } else {
            $this->DeclaredCustomsValueAmount = $declaredCustomsValueAmount;
        }
        return $this;
    }
    /**
     * Get DeclaredForCarriageValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredForCarriageValueAmount()
    {
        return isset($this->DeclaredForCarriageValueAmount) ? $this->DeclaredForCarriageValueAmount : null;
    }
    /**
     * Set DeclaredForCarriageValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredForCarriageValueAmount
     * @return \StructType\GoodsItem
     */
    public function setDeclaredForCarriageValueAmount(\StructType\Amount $declaredForCarriageValueAmount = null)
    {
        if (is_null($declaredForCarriageValueAmount) || (is_array($declaredForCarriageValueAmount) && empty($declaredForCarriageValueAmount))) {
            unset($this->DeclaredForCarriageValueAmount);
        } else {
            $this->DeclaredForCarriageValueAmount = $declaredForCarriageValueAmount;
        }
        return $this;
    }
    /**
     * Get DeclaredStatisticsValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getDeclaredStatisticsValueAmount()
    {
        return isset($this->DeclaredStatisticsValueAmount) ? $this->DeclaredStatisticsValueAmount : null;
    }
    /**
     * Set DeclaredStatisticsValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $declaredStatisticsValueAmount
     * @return \StructType\GoodsItem
     */
    public function setDeclaredStatisticsValueAmount(\StructType\Amount $declaredStatisticsValueAmount = null)
    {
        if (is_null($declaredStatisticsValueAmount) || (is_array($declaredStatisticsValueAmount) && empty($declaredStatisticsValueAmount))) {
            unset($this->DeclaredStatisticsValueAmount);
        } else {
            $this->DeclaredStatisticsValueAmount = $declaredStatisticsValueAmount;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $description
     * @return \StructType\GoodsItem
     */
    public function setDescription(\ArrayType\ArrayOfstring $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get FreeOnBoardValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getFreeOnBoardValueAmount()
    {
        return isset($this->FreeOnBoardValueAmount) ? $this->FreeOnBoardValueAmount : null;
    }
    /**
     * Set FreeOnBoardValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $freeOnBoardValueAmount
     * @return \StructType\GoodsItem
     */
    public function setFreeOnBoardValueAmount(\StructType\Amount $freeOnBoardValueAmount = null)
    {
        if (is_null($freeOnBoardValueAmount) || (is_array($freeOnBoardValueAmount) && empty($freeOnBoardValueAmount))) {
            unset($this->FreeOnBoardValueAmount);
        } else {
            $this->FreeOnBoardValueAmount = $freeOnBoardValueAmount;
        }
        return $this;
    }
    /**
     * Get FreightAllowanceCharge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfAllowanceCharge|null
     */
    public function getFreightAllowanceCharge()
    {
        return isset($this->FreightAllowanceCharge) ? $this->FreightAllowanceCharge : null;
    }
    /**
     * Set FreightAllowanceCharge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfAllowanceCharge $freightAllowanceCharge
     * @return \StructType\GoodsItem
     */
    public function setFreightAllowanceCharge(\ArrayType\ArrayOfAllowanceCharge $freightAllowanceCharge = null)
    {
        if (is_null($freightAllowanceCharge) || (is_array($freightAllowanceCharge) && empty($freightAllowanceCharge))) {
            unset($this->FreightAllowanceCharge);
        } else {
            $this->FreightAllowanceCharge = $freightAllowanceCharge;
        }
        return $this;
    }
    /**
     * Get GrossVolumeMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getGrossVolumeMeasure()
    {
        return isset($this->GrossVolumeMeasure) ? $this->GrossVolumeMeasure : null;
    }
    /**
     * Set GrossVolumeMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $grossVolumeMeasure
     * @return \StructType\GoodsItem
     */
    public function setGrossVolumeMeasure(\StructType\Measure $grossVolumeMeasure = null)
    {
        if (is_null($grossVolumeMeasure) || (is_array($grossVolumeMeasure) && empty($grossVolumeMeasure))) {
            unset($this->GrossVolumeMeasure);
        } else {
            $this->GrossVolumeMeasure = $grossVolumeMeasure;
        }
        return $this;
    }
    /**
     * Get GrossWeightMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getGrossWeightMeasure()
    {
        return isset($this->GrossWeightMeasure) ? $this->GrossWeightMeasure : null;
    }
    /**
     * Set GrossWeightMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $grossWeightMeasure
     * @return \StructType\GoodsItem
     */
    public function setGrossWeightMeasure(\StructType\Measure $grossWeightMeasure = null)
    {
        if (is_null($grossWeightMeasure) || (is_array($grossWeightMeasure) && empty($grossWeightMeasure))) {
            unset($this->GrossWeightMeasure);
        } else {
            $this->GrossWeightMeasure = $grossWeightMeasure;
        }
        return $this;
    }
    /**
     * Get HazardousRiskIndicator value
     * @return bool|null
     */
    public function getHazardousRiskIndicator()
    {
        return $this->HazardousRiskIndicator;
    }
    /**
     * Set HazardousRiskIndicator value
     * @param bool $hazardousRiskIndicator
     * @return \StructType\GoodsItem
     */
    public function setHazardousRiskIndicator($hazardousRiskIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($hazardousRiskIndicator) && !is_bool($hazardousRiskIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hazardousRiskIndicator, true), gettype($hazardousRiskIndicator)), __LINE__);
        }
        $this->HazardousRiskIndicator = $hazardousRiskIndicator;
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\GoodsItem
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get InsuranceValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getInsuranceValueAmount()
    {
        return isset($this->InsuranceValueAmount) ? $this->InsuranceValueAmount : null;
    }
    /**
     * Set InsuranceValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $insuranceValueAmount
     * @return \StructType\GoodsItem
     */
    public function setInsuranceValueAmount(\StructType\Amount $insuranceValueAmount = null)
    {
        if (is_null($insuranceValueAmount) || (is_array($insuranceValueAmount) && empty($insuranceValueAmount))) {
            unset($this->InsuranceValueAmount);
        } else {
            $this->InsuranceValueAmount = $insuranceValueAmount;
        }
        return $this;
    }
    /**
     * Get InvoiceLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfInvoiceLine|null
     */
    public function getInvoiceLine()
    {
        return isset($this->InvoiceLine) ? $this->InvoiceLine : null;
    }
    /**
     * Set InvoiceLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfInvoiceLine $invoiceLine
     * @return \StructType\GoodsItem
     */
    public function setInvoiceLine(\ArrayType\ArrayOfInvoiceLine $invoiceLine = null)
    {
        if (is_null($invoiceLine) || (is_array($invoiceLine) && empty($invoiceLine))) {
            unset($this->InvoiceLine);
        } else {
            $this->InvoiceLine = $invoiceLine;
        }
        return $this;
    }
    /**
     * Get Item value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfItem|null
     */
    public function getItem()
    {
        return isset($this->Item) ? $this->Item : null;
    }
    /**
     * Set Item value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfItem $item
     * @return \StructType\GoodsItem
     */
    public function setItem(\ArrayType\ArrayOfItem $item = null)
    {
        if (is_null($item) || (is_array($item) && empty($item))) {
            unset($this->Item);
        } else {
            $this->Item = $item;
        }
        return $this;
    }
    /**
     * Get MeasurementDimension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDimension|null
     */
    public function getMeasurementDimension()
    {
        return isset($this->MeasurementDimension) ? $this->MeasurementDimension : null;
    }
    /**
     * Set MeasurementDimension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDimension $measurementDimension
     * @return \StructType\GoodsItem
     */
    public function setMeasurementDimension(\ArrayType\ArrayOfDimension $measurementDimension = null)
    {
        if (is_null($measurementDimension) || (is_array($measurementDimension) && empty($measurementDimension))) {
            unset($this->MeasurementDimension);
        } else {
            $this->MeasurementDimension = $measurementDimension;
        }
        return $this;
    }
    /**
     * Get NetVolumeMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getNetVolumeMeasure()
    {
        return isset($this->NetVolumeMeasure) ? $this->NetVolumeMeasure : null;
    }
    /**
     * Set NetVolumeMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $netVolumeMeasure
     * @return \StructType\GoodsItem
     */
    public function setNetVolumeMeasure(\StructType\Measure $netVolumeMeasure = null)
    {
        if (is_null($netVolumeMeasure) || (is_array($netVolumeMeasure) && empty($netVolumeMeasure))) {
            unset($this->NetVolumeMeasure);
        } else {
            $this->NetVolumeMeasure = $netVolumeMeasure;
        }
        return $this;
    }
    /**
     * Get NetWeightMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getNetWeightMeasure()
    {
        return isset($this->NetWeightMeasure) ? $this->NetWeightMeasure : null;
    }
    /**
     * Set NetWeightMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $netWeightMeasure
     * @return \StructType\GoodsItem
     */
    public function setNetWeightMeasure(\StructType\Measure $netWeightMeasure = null)
    {
        if (is_null($netWeightMeasure) || (is_array($netWeightMeasure) && empty($netWeightMeasure))) {
            unset($this->NetWeightMeasure);
        } else {
            $this->NetWeightMeasure = $netWeightMeasure;
        }
        return $this;
    }
    /**
     * Get OriginAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getOriginAddress()
    {
        return isset($this->OriginAddress) ? $this->OriginAddress : null;
    }
    /**
     * Set OriginAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $originAddress
     * @return \StructType\GoodsItem
     */
    public function setOriginAddress(\StructType\Address $originAddress = null)
    {
        if (is_null($originAddress) || (is_array($originAddress) && empty($originAddress))) {
            unset($this->OriginAddress);
        } else {
            $this->OriginAddress = $originAddress;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\GoodsItem
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get RequiredCustomsID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequiredCustomsID()
    {
        return isset($this->RequiredCustomsID) ? $this->RequiredCustomsID : null;
    }
    /**
     * Set RequiredCustomsID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requiredCustomsID
     * @return \StructType\GoodsItem
     */
    public function setRequiredCustomsID($requiredCustomsID = null)
    {
        // validation for constraint: string
        if (!is_null($requiredCustomsID) && !is_string($requiredCustomsID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requiredCustomsID, true), gettype($requiredCustomsID)), __LINE__);
        }
        if (is_null($requiredCustomsID) || (is_array($requiredCustomsID) && empty($requiredCustomsID))) {
            unset($this->RequiredCustomsID);
        } else {
            $this->RequiredCustomsID = $requiredCustomsID;
        }
        return $this;
    }
    /**
     * Get ReturnableQuantity value
     * @return float|null
     */
    public function getReturnableQuantity()
    {
        return $this->ReturnableQuantity;
    }
    /**
     * Set ReturnableQuantity value
     * @param float $returnableQuantity
     * @return \StructType\GoodsItem
     */
    public function setReturnableQuantity($returnableQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($returnableQuantity) && !(is_float($returnableQuantity) || is_numeric($returnableQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($returnableQuantity, true), gettype($returnableQuantity)), __LINE__);
        }
        $this->ReturnableQuantity = $returnableQuantity;
        return $this;
    }
    /**
     * Get Temperature value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTemperature|null
     */
    public function getTemperature()
    {
        return isset($this->Temperature) ? $this->Temperature : null;
    }
    /**
     * Set Temperature value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTemperature $temperature
     * @return \StructType\GoodsItem
     */
    public function setTemperature(\ArrayType\ArrayOfTemperature $temperature = null)
    {
        if (is_null($temperature) || (is_array($temperature) && empty($temperature))) {
            unset($this->Temperature);
        } else {
            $this->Temperature = $temperature;
        }
        return $this;
    }
    /**
     * Get TraceID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTraceID()
    {
        return isset($this->TraceID) ? $this->TraceID : null;
    }
    /**
     * Set TraceID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $traceID
     * @return \StructType\GoodsItem
     */
    public function setTraceID($traceID = null)
    {
        // validation for constraint: string
        if (!is_null($traceID) && !is_string($traceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($traceID, true), gettype($traceID)), __LINE__);
        }
        if (is_null($traceID) || (is_array($traceID) && empty($traceID))) {
            unset($this->TraceID);
        } else {
            $this->TraceID = $traceID;
        }
        return $this;
    }
    /**
     * Get ValueAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getValueAmount()
    {
        return isset($this->ValueAmount) ? $this->ValueAmount : null;
    }
    /**
     * Set ValueAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $valueAmount
     * @return \StructType\GoodsItem
     */
    public function setValueAmount(\StructType\Amount $valueAmount = null)
    {
        if (is_null($valueAmount) || (is_array($valueAmount) && empty($valueAmount))) {
            unset($this->ValueAmount);
        } else {
            $this->ValueAmount = $valueAmount;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GoodsItem
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
