<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetReconciliationDetailResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetReconciliationDetailResponse
 * @subpackage Structs
 */
class GetReconciliationDetailResponse extends ResponseBase
{
    /**
     * The DeliveredInvoiceNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $DeliveredInvoiceNumbers;
    /**
     * The ReceivedInvoiceNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $ReceivedInvoiceNumbers;
    /**
     * The ReconciliationDetail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReconciliationDeliveryDetail
     */
    public $ReconciliationDetail;
    /**
     * The RepliedInvoiceNumbers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $RepliedInvoiceNumbers;
    /**
     * The GetReconciliationDetailResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetReconciliationDetailResponse
     */
    public $GetReconciliationDetailResult;
    /**
     * Constructor method for GetReconciliationDetailResponse
     * @uses GetReconciliationDetailResponse::setDeliveredInvoiceNumbers()
     * @uses GetReconciliationDetailResponse::setReceivedInvoiceNumbers()
     * @uses GetReconciliationDetailResponse::setReconciliationDetail()
     * @uses GetReconciliationDetailResponse::setRepliedInvoiceNumbers()
     * @uses GetReconciliationDetailResponse::setGetReconciliationDetailResult()
     * @param \ArrayType\ArrayOfstring $deliveredInvoiceNumbers
     * @param \ArrayType\ArrayOfstring $receivedInvoiceNumbers
     * @param \ArrayType\ArrayOfReconciliationDeliveryDetail $reconciliationDetail
     * @param \ArrayType\ArrayOfstring $repliedInvoiceNumbers
     * @param \StructType\GetReconciliationDetailResponse $getReconciliationDetailResult
     */
    public function __construct(\ArrayType\ArrayOfstring $deliveredInvoiceNumbers = null, \ArrayType\ArrayOfstring $receivedInvoiceNumbers = null, \ArrayType\ArrayOfReconciliationDeliveryDetail $reconciliationDetail = null, \ArrayType\ArrayOfstring $repliedInvoiceNumbers = null, \StructType\GetReconciliationDetailResponse $getReconciliationDetailResult = null)
    {
        $this
            ->setDeliveredInvoiceNumbers($deliveredInvoiceNumbers)
            ->setReceivedInvoiceNumbers($receivedInvoiceNumbers)
            ->setReconciliationDetail($reconciliationDetail)
            ->setRepliedInvoiceNumbers($repliedInvoiceNumbers)
            ->setGetReconciliationDetailResult($getReconciliationDetailResult);
    }
    /**
     * Get DeliveredInvoiceNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDeliveredInvoiceNumbers()
    {
        return isset($this->DeliveredInvoiceNumbers) ? $this->DeliveredInvoiceNumbers : null;
    }
    /**
     * Set DeliveredInvoiceNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $deliveredInvoiceNumbers
     * @return \StructType\GetReconciliationDetailResponse
     */
    public function setDeliveredInvoiceNumbers(\ArrayType\ArrayOfstring $deliveredInvoiceNumbers = null)
    {
        if (is_null($deliveredInvoiceNumbers) || (is_array($deliveredInvoiceNumbers) && empty($deliveredInvoiceNumbers))) {
            unset($this->DeliveredInvoiceNumbers);
        } else {
            $this->DeliveredInvoiceNumbers = $deliveredInvoiceNumbers;
        }
        return $this;
    }
    /**
     * Get ReceivedInvoiceNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getReceivedInvoiceNumbers()
    {
        return isset($this->ReceivedInvoiceNumbers) ? $this->ReceivedInvoiceNumbers : null;
    }
    /**
     * Set ReceivedInvoiceNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $receivedInvoiceNumbers
     * @return \StructType\GetReconciliationDetailResponse
     */
    public function setReceivedInvoiceNumbers(\ArrayType\ArrayOfstring $receivedInvoiceNumbers = null)
    {
        if (is_null($receivedInvoiceNumbers) || (is_array($receivedInvoiceNumbers) && empty($receivedInvoiceNumbers))) {
            unset($this->ReceivedInvoiceNumbers);
        } else {
            $this->ReceivedInvoiceNumbers = $receivedInvoiceNumbers;
        }
        return $this;
    }
    /**
     * Get ReconciliationDetail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReconciliationDeliveryDetail|null
     */
    public function getReconciliationDetail()
    {
        return isset($this->ReconciliationDetail) ? $this->ReconciliationDetail : null;
    }
    /**
     * Set ReconciliationDetail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReconciliationDeliveryDetail $reconciliationDetail
     * @return \StructType\GetReconciliationDetailResponse
     */
    public function setReconciliationDetail(\ArrayType\ArrayOfReconciliationDeliveryDetail $reconciliationDetail = null)
    {
        if (is_null($reconciliationDetail) || (is_array($reconciliationDetail) && empty($reconciliationDetail))) {
            unset($this->ReconciliationDetail);
        } else {
            $this->ReconciliationDetail = $reconciliationDetail;
        }
        return $this;
    }
    /**
     * Get RepliedInvoiceNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getRepliedInvoiceNumbers()
    {
        return isset($this->RepliedInvoiceNumbers) ? $this->RepliedInvoiceNumbers : null;
    }
    /**
     * Set RepliedInvoiceNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $repliedInvoiceNumbers
     * @return \StructType\GetReconciliationDetailResponse
     */
    public function setRepliedInvoiceNumbers(\ArrayType\ArrayOfstring $repliedInvoiceNumbers = null)
    {
        if (is_null($repliedInvoiceNumbers) || (is_array($repliedInvoiceNumbers) && empty($repliedInvoiceNumbers))) {
            unset($this->RepliedInvoiceNumbers);
        } else {
            $this->RepliedInvoiceNumbers = $repliedInvoiceNumbers;
        }
        return $this;
    }
    /**
     * Get GetReconciliationDetailResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetReconciliationDetailResponse|null
     */
    public function getGetReconciliationDetailResult()
    {
        return isset($this->GetReconciliationDetailResult) ? $this->GetReconciliationDetailResult : null;
    }
    /**
     * Set GetReconciliationDetailResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetReconciliationDetailResponse $getReconciliationDetailResult
     * @return \StructType\GetReconciliationDetailResponse
     */
    public function setGetReconciliationDetailResult(\StructType\GetReconciliationDetailResponse $getReconciliationDetailResult = null)
    {
        if (is_null($getReconciliationDetailResult) || (is_array($getReconciliationDetailResult) && empty($getReconciliationDetailResult))) {
            unset($this->GetReconciliationDetailResult);
        } else {
            $this->GetReconciliationDetailResult = $getReconciliationDetailResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetReconciliationDetailResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
