<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoicesResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetInvoicesResponse
 * @subpackage Structs
 */
class GetInvoicesResponse extends ResponseBase
{
    /**
     * The Invoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIncomingInvoice
     */
    public $Invoices;
    /**
     * The RemainedInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RemainedInvoiceCount;
    /**
     * The GetInvoicesResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetInvoicesResponse
     */
    public $GetInvoicesResult;
    /**
     * Constructor method for GetInvoicesResponse
     * @uses GetInvoicesResponse::setInvoices()
     * @uses GetInvoicesResponse::setRemainedInvoiceCount()
     * @uses GetInvoicesResponse::setGetInvoicesResult()
     * @param \ArrayType\ArrayOfIncomingInvoice $invoices
     * @param int $remainedInvoiceCount
     * @param \StructType\GetInvoicesResponse $getInvoicesResult
     */
    public function __construct(\ArrayType\ArrayOfIncomingInvoice $invoices = null, $remainedInvoiceCount = null, \StructType\GetInvoicesResponse $getInvoicesResult = null)
    {
        $this
            ->setInvoices($invoices)
            ->setRemainedInvoiceCount($remainedInvoiceCount)
            ->setGetInvoicesResult($getInvoicesResult);
    }
    /**
     * Get Invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIncomingInvoice|null
     */
    public function getInvoices()
    {
        return isset($this->Invoices) ? $this->Invoices : null;
    }
    /**
     * Set Invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIncomingInvoice $invoices
     * @return \StructType\GetInvoicesResponse
     */
    public function setInvoices(\ArrayType\ArrayOfIncomingInvoice $invoices = null)
    {
        if (is_null($invoices) || (is_array($invoices) && empty($invoices))) {
            unset($this->Invoices);
        } else {
            $this->Invoices = $invoices;
        }
        return $this;
    }
    /**
     * Get RemainedInvoiceCount value
     * @return int|null
     */
    public function getRemainedInvoiceCount()
    {
        return $this->RemainedInvoiceCount;
    }
    /**
     * Set RemainedInvoiceCount value
     * @param int $remainedInvoiceCount
     * @return \StructType\GetInvoicesResponse
     */
    public function setRemainedInvoiceCount($remainedInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($remainedInvoiceCount) && !(is_int($remainedInvoiceCount) || ctype_digit($remainedInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainedInvoiceCount, true), gettype($remainedInvoiceCount)), __LINE__);
        }
        $this->RemainedInvoiceCount = $remainedInvoiceCount;
        return $this;
    }
    /**
     * Get GetInvoicesResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetInvoicesResponse|null
     */
    public function getGetInvoicesResult()
    {
        return isset($this->GetInvoicesResult) ? $this->GetInvoicesResult : null;
    }
    /**
     * Set GetInvoicesResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetInvoicesResponse $getInvoicesResult
     * @return \StructType\GetInvoicesResponse
     */
    public function setGetInvoicesResult(\StructType\GetInvoicesResponse $getInvoicesResult = null)
    {
        if (is_null($getInvoicesResult) || (is_array($getInvoicesResult) && empty($getInvoicesResult))) {
            unset($this->GetInvoicesResult);
        } else {
            $this->GetInvoicesResult = $getInvoicesResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoicesResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
