<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoicesRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetInvoicesRequest
 * @subpackage Structs
 */
class GetInvoicesRequest extends RequestBase
{
    /**
     * The AcceptanceDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AcceptanceDateTime;
    /**
     * The InstitutionSourceCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $InstitutionSourceCode;
    /**
     * The MaxItemsToReturn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxItemsToReturn;
    /**
     * The RequestNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestNumber;
    /**
     * The ViewContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ViewContentType;
    /**
     * Constructor method for GetInvoicesRequest
     * @uses GetInvoicesRequest::setAcceptanceDateTime()
     * @uses GetInvoicesRequest::setInstitutionSourceCode()
     * @uses GetInvoicesRequest::setMaxItemsToReturn()
     * @uses GetInvoicesRequest::setRequestNumber()
     * @uses GetInvoicesRequest::setViewContentType()
     * @param string $acceptanceDateTime
     * @param int $institutionSourceCode
     * @param int $maxItemsToReturn
     * @param int $requestNumber
     * @param int $viewContentType
     */
    public function __construct($acceptanceDateTime = null, $institutionSourceCode = null, $maxItemsToReturn = null, $requestNumber = null, $viewContentType = null)
    {
        $this
            ->setAcceptanceDateTime($acceptanceDateTime)
            ->setInstitutionSourceCode($institutionSourceCode)
            ->setMaxItemsToReturn($maxItemsToReturn)
            ->setRequestNumber($requestNumber)
            ->setViewContentType($viewContentType);
    }
    /**
     * Get AcceptanceDateTime value
     * @return string|null
     */
    public function getAcceptanceDateTime()
    {
        return $this->AcceptanceDateTime;
    }
    /**
     * Set AcceptanceDateTime value
     * @param string $acceptanceDateTime
     * @return \StructType\GetInvoicesRequest
     */
    public function setAcceptanceDateTime($acceptanceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($acceptanceDateTime) && !is_string($acceptanceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptanceDateTime, true), gettype($acceptanceDateTime)), __LINE__);
        }
        $this->AcceptanceDateTime = $acceptanceDateTime;
        return $this;
    }
    /**
     * Get InstitutionSourceCode value
     * @return int|null
     */
    public function getInstitutionSourceCode()
    {
        return $this->InstitutionSourceCode;
    }
    /**
     * Set InstitutionSourceCode value
     * @param int $institutionSourceCode
     * @return \StructType\GetInvoicesRequest
     */
    public function setInstitutionSourceCode($institutionSourceCode = null)
    {
        // validation for constraint: int
        if (!is_null($institutionSourceCode) && !(is_int($institutionSourceCode) || ctype_digit($institutionSourceCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($institutionSourceCode, true), gettype($institutionSourceCode)), __LINE__);
        }
        $this->InstitutionSourceCode = $institutionSourceCode;
        return $this;
    }
    /**
     * Get MaxItemsToReturn value
     * @return int|null
     */
    public function getMaxItemsToReturn()
    {
        return $this->MaxItemsToReturn;
    }
    /**
     * Set MaxItemsToReturn value
     * @param int $maxItemsToReturn
     * @return \StructType\GetInvoicesRequest
     */
    public function setMaxItemsToReturn($maxItemsToReturn = null)
    {
        // validation for constraint: int
        if (!is_null($maxItemsToReturn) && !(is_int($maxItemsToReturn) || ctype_digit($maxItemsToReturn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxItemsToReturn, true), gettype($maxItemsToReturn)), __LINE__);
        }
        $this->MaxItemsToReturn = $maxItemsToReturn;
        return $this;
    }
    /**
     * Get RequestNumber value
     * @return int|null
     */
    public function getRequestNumber()
    {
        return $this->RequestNumber;
    }
    /**
     * Set RequestNumber value
     * @param int $requestNumber
     * @return \StructType\GetInvoicesRequest
     */
    public function setRequestNumber($requestNumber = null)
    {
        // validation for constraint: int
        if (!is_null($requestNumber) && !(is_int($requestNumber) || ctype_digit($requestNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestNumber, true), gettype($requestNumber)), __LINE__);
        }
        $this->RequestNumber = $requestNumber;
        return $this;
    }
    /**
     * Get ViewContentType value
     * @return int|null
     */
    public function getViewContentType()
    {
        return $this->ViewContentType;
    }
    /**
     * Set ViewContentType value
     * @param int $viewContentType
     * @return \StructType\GetInvoicesRequest
     */
    public function setViewContentType($viewContentType = null)
    {
        // validation for constraint: int
        if (!is_null($viewContentType) && !(is_int($viewContentType) || ctype_digit($viewContentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewContentType, true), gettype($viewContentType)), __LINE__);
        }
        $this->ViewContentType = $viewContentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoicesRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
