<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetInvoicesRawResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetInvoicesRawResponse
 * @subpackage Structs
 */
class GetInvoicesRawResponse extends ResponseBase
{
    /**
     * The Invoices
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfIncomingInvoiceRaw
     */
    public $Invoices;
    /**
     * The RemainedInvoiceCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RemainedInvoiceCount;
    /**
     * The GetInvoicesRawResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetInvoicesRawResponse
     */
    public $GetInvoicesRawResult;
    /**
     * Constructor method for GetInvoicesRawResponse
     * @uses GetInvoicesRawResponse::setInvoices()
     * @uses GetInvoicesRawResponse::setRemainedInvoiceCount()
     * @uses GetInvoicesRawResponse::setGetInvoicesRawResult()
     * @param \ArrayType\ArrayOfIncomingInvoiceRaw $invoices
     * @param int $remainedInvoiceCount
     * @param \StructType\GetInvoicesRawResponse $getInvoicesRawResult
     */
    public function __construct(\ArrayType\ArrayOfIncomingInvoiceRaw $invoices = null, $remainedInvoiceCount = null, \StructType\GetInvoicesRawResponse $getInvoicesRawResult = null)
    {
        $this
            ->setInvoices($invoices)
            ->setRemainedInvoiceCount($remainedInvoiceCount)
            ->setGetInvoicesRawResult($getInvoicesRawResult);
    }
    /**
     * Get Invoices value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfIncomingInvoiceRaw|null
     */
    public function getInvoices()
    {
        return isset($this->Invoices) ? $this->Invoices : null;
    }
    /**
     * Set Invoices value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfIncomingInvoiceRaw $invoices
     * @return \StructType\GetInvoicesRawResponse
     */
    public function setInvoices(\ArrayType\ArrayOfIncomingInvoiceRaw $invoices = null)
    {
        if (is_null($invoices) || (is_array($invoices) && empty($invoices))) {
            unset($this->Invoices);
        } else {
            $this->Invoices = $invoices;
        }
        return $this;
    }
    /**
     * Get RemainedInvoiceCount value
     * @return int|null
     */
    public function getRemainedInvoiceCount()
    {
        return $this->RemainedInvoiceCount;
    }
    /**
     * Set RemainedInvoiceCount value
     * @param int $remainedInvoiceCount
     * @return \StructType\GetInvoicesRawResponse
     */
    public function setRemainedInvoiceCount($remainedInvoiceCount = null)
    {
        // validation for constraint: int
        if (!is_null($remainedInvoiceCount) && !(is_int($remainedInvoiceCount) || ctype_digit($remainedInvoiceCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainedInvoiceCount, true), gettype($remainedInvoiceCount)), __LINE__);
        }
        $this->RemainedInvoiceCount = $remainedInvoiceCount;
        return $this;
    }
    /**
     * Get GetInvoicesRawResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetInvoicesRawResponse|null
     */
    public function getGetInvoicesRawResult()
    {
        return isset($this->GetInvoicesRawResult) ? $this->GetInvoicesRawResult : null;
    }
    /**
     * Set GetInvoicesRawResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetInvoicesRawResponse $getInvoicesRawResult
     * @return \StructType\GetInvoicesRawResponse
     */
    public function setGetInvoicesRawResult(\StructType\GetInvoicesRawResponse $getInvoicesRawResult = null)
    {
        if (is_null($getInvoicesRawResult) || (is_array($getInvoicesRawResult) && empty($getInvoicesRawResult))) {
            unset($this->GetInvoicesRawResult);
        } else {
            $this->GetInvoicesRawResult = $getInvoicesRawResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetInvoicesRawResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
