<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomersResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCustomersResponse
 * @subpackage Structs
 */
class GetCustomersResponse extends ResponseBase
{
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomer
     */
    public $Customers;
    /**
     * The RemainedCustomersCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RemainedCustomersCount;
    /**
     * The TotalPagesCount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalPagesCount;
    /**
     * The GetCustomersResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\GetCustomersResponse
     */
    public $GetCustomersResult;
    /**
     * Constructor method for GetCustomersResponse
     * @uses GetCustomersResponse::setCustomers()
     * @uses GetCustomersResponse::setRemainedCustomersCount()
     * @uses GetCustomersResponse::setTotalPagesCount()
     * @uses GetCustomersResponse::setGetCustomersResult()
     * @param \ArrayType\ArrayOfCustomer $customers
     * @param int $remainedCustomersCount
     * @param int $totalPagesCount
     * @param \StructType\GetCustomersResponse $getCustomersResult
     */
    public function __construct(\ArrayType\ArrayOfCustomer $customers = null, $remainedCustomersCount = null, $totalPagesCount = null, \StructType\GetCustomersResponse $getCustomersResult = null)
    {
        $this
            ->setCustomers($customers)
            ->setRemainedCustomersCount($remainedCustomersCount)
            ->setTotalPagesCount($totalPagesCount)
            ->setGetCustomersResult($getCustomersResult);
    }
    /**
     * Get Customers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomer|null
     */
    public function getCustomers()
    {
        return isset($this->Customers) ? $this->Customers : null;
    }
    /**
     * Set Customers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomer $customers
     * @return \StructType\GetCustomersResponse
     */
    public function setCustomers(\ArrayType\ArrayOfCustomer $customers = null)
    {
        if (is_null($customers) || (is_array($customers) && empty($customers))) {
            unset($this->Customers);
        } else {
            $this->Customers = $customers;
        }
        return $this;
    }
    /**
     * Get RemainedCustomersCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRemainedCustomersCount()
    {
        return isset($this->RemainedCustomersCount) ? $this->RemainedCustomersCount : null;
    }
    /**
     * Set RemainedCustomersCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $remainedCustomersCount
     * @return \StructType\GetCustomersResponse
     */
    public function setRemainedCustomersCount($remainedCustomersCount = null)
    {
        // validation for constraint: int
        if (!is_null($remainedCustomersCount) && !(is_int($remainedCustomersCount) || ctype_digit($remainedCustomersCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($remainedCustomersCount, true), gettype($remainedCustomersCount)), __LINE__);
        }
        if (is_null($remainedCustomersCount) || (is_array($remainedCustomersCount) && empty($remainedCustomersCount))) {
            unset($this->RemainedCustomersCount);
        } else {
            $this->RemainedCustomersCount = $remainedCustomersCount;
        }
        return $this;
    }
    /**
     * Get TotalPagesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalPagesCount()
    {
        return isset($this->TotalPagesCount) ? $this->TotalPagesCount : null;
    }
    /**
     * Set TotalPagesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalPagesCount
     * @return \StructType\GetCustomersResponse
     */
    public function setTotalPagesCount($totalPagesCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalPagesCount) && !(is_int($totalPagesCount) || ctype_digit($totalPagesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalPagesCount, true), gettype($totalPagesCount)), __LINE__);
        }
        if (is_null($totalPagesCount) || (is_array($totalPagesCount) && empty($totalPagesCount))) {
            unset($this->TotalPagesCount);
        } else {
            $this->TotalPagesCount = $totalPagesCount;
        }
        return $this;
    }
    /**
     * Get GetCustomersResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\GetCustomersResponse|null
     */
    public function getGetCustomersResult()
    {
        return isset($this->GetCustomersResult) ? $this->GetCustomersResult : null;
    }
    /**
     * Set GetCustomersResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\GetCustomersResponse $getCustomersResult
     * @return \StructType\GetCustomersResponse
     */
    public function setGetCustomersResult(\StructType\GetCustomersResponse $getCustomersResult = null)
    {
        if (is_null($getCustomersResult) || (is_array($getCustomersResult) && empty($getCustomersResult))) {
            unset($this->GetCustomersResult);
        } else {
            $this->GetCustomersResult = $getCustomersResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomersResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
