<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetCustomersRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:GetCustomersRequest
 * @subpackage Structs
 */
class GetCustomersRequest extends RequestBase
{
    /**
     * The DisplayLength
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayLength;
    /**
     * The DisplayStart
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayStart;
    /**
     * Constructor method for GetCustomersRequest
     * @uses GetCustomersRequest::setDisplayLength()
     * @uses GetCustomersRequest::setDisplayStart()
     * @param int $displayLength
     * @param int $displayStart
     */
    public function __construct($displayLength = null, $displayStart = null)
    {
        $this
            ->setDisplayLength($displayLength)
            ->setDisplayStart($displayStart);
    }
    /**
     * Get DisplayLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayLength()
    {
        return isset($this->DisplayLength) ? $this->DisplayLength : null;
    }
    /**
     * Set DisplayLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayLength
     * @return \StructType\GetCustomersRequest
     */
    public function setDisplayLength($displayLength = null)
    {
        // validation for constraint: int
        if (!is_null($displayLength) && !(is_int($displayLength) || ctype_digit($displayLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayLength, true), gettype($displayLength)), __LINE__);
        }
        if (is_null($displayLength) || (is_array($displayLength) && empty($displayLength))) {
            unset($this->DisplayLength);
        } else {
            $this->DisplayLength = $displayLength;
        }
        return $this;
    }
    /**
     * Get DisplayStart value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayStart()
    {
        return isset($this->DisplayStart) ? $this->DisplayStart : null;
    }
    /**
     * Set DisplayStart value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayStart
     * @return \StructType\GetCustomersRequest
     */
    public function setDisplayStart($displayStart = null)
    {
        // validation for constraint: int
        if (!is_null($displayStart) && !(is_int($displayStart) || ctype_digit($displayStart))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayStart, true), gettype($displayStart)), __LINE__);
        }
        if (is_null($displayStart) || (is_array($displayStart) && empty($displayStart))) {
            unset($this->DisplayStart);
        } else {
            $this->DisplayStart = $displayStart;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetCustomersRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
