<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FinancialAccount StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:FinancialAccount
 * @subpackage Structs
 */
class FinancialAccount extends AbstractStructBase
{
    /**
     * The CurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The FinancialInstitutionBranch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Branch
     */
    public $FinancialInstitutionBranch;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The PaymentNote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentNote;
    /**
     * Constructor method for FinancialAccount
     * @uses FinancialAccount::setCurrencyCode()
     * @uses FinancialAccount::setFinancialInstitutionBranch()
     * @uses FinancialAccount::setID()
     * @uses FinancialAccount::setPaymentNote()
     * @param string $currencyCode
     * @param \StructType\Branch $financialInstitutionBranch
     * @param string $iD
     * @param string $paymentNote
     */
    public function __construct($currencyCode = null, \StructType\Branch $financialInstitutionBranch = null, $iD = null, $paymentNote = null)
    {
        $this
            ->setCurrencyCode($currencyCode)
            ->setFinancialInstitutionBranch($financialInstitutionBranch)
            ->setID($iD)
            ->setPaymentNote($paymentNote);
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \StructType\FinancialAccount
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get FinancialInstitutionBranch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Branch|null
     */
    public function getFinancialInstitutionBranch()
    {
        return isset($this->FinancialInstitutionBranch) ? $this->FinancialInstitutionBranch : null;
    }
    /**
     * Set FinancialInstitutionBranch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Branch $financialInstitutionBranch
     * @return \StructType\FinancialAccount
     */
    public function setFinancialInstitutionBranch(\StructType\Branch $financialInstitutionBranch = null)
    {
        if (is_null($financialInstitutionBranch) || (is_array($financialInstitutionBranch) && empty($financialInstitutionBranch))) {
            unset($this->FinancialInstitutionBranch);
        } else {
            $this->FinancialInstitutionBranch = $financialInstitutionBranch;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\FinancialAccount
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get PaymentNote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentNote()
    {
        return isset($this->PaymentNote) ? $this->PaymentNote : null;
    }
    /**
     * Set PaymentNote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentNote
     * @return \StructType\FinancialAccount
     */
    public function setPaymentNote($paymentNote = null)
    {
        // validation for constraint: string
        if (!is_null($paymentNote) && !is_string($paymentNote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentNote, true), gettype($paymentNote)), __LINE__);
        }
        if (is_null($paymentNote) || (is_array($paymentNote) && empty($paymentNote))) {
            unset($this->PaymentNote);
        } else {
            $this->PaymentNote = $paymentNote;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\FinancialAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
