<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExchangeRate StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ExchangeRate
 * @subpackage Structs
 */
class ExchangeRate extends AbstractStructBase
{
    /**
     * The CalculationRate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CalculationRate;
    /**
     * The Date
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The SourceCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SourceCurrencyCode;
    /**
     * The TargetCurrencyCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetCurrencyCode;
    /**
     * Constructor method for ExchangeRate
     * @uses ExchangeRate::setCalculationRate()
     * @uses ExchangeRate::setDate()
     * @uses ExchangeRate::setSourceCurrencyCode()
     * @uses ExchangeRate::setTargetCurrencyCode()
     * @param float $calculationRate
     * @param string $date
     * @param string $sourceCurrencyCode
     * @param string $targetCurrencyCode
     */
    public function __construct($calculationRate = null, $date = null, $sourceCurrencyCode = null, $targetCurrencyCode = null)
    {
        $this
            ->setCalculationRate($calculationRate)
            ->setDate($date)
            ->setSourceCurrencyCode($sourceCurrencyCode)
            ->setTargetCurrencyCode($targetCurrencyCode);
    }
    /**
     * Get CalculationRate value
     * @return float|null
     */
    public function getCalculationRate()
    {
        return $this->CalculationRate;
    }
    /**
     * Set CalculationRate value
     * @param float $calculationRate
     * @return \StructType\ExchangeRate
     */
    public function setCalculationRate($calculationRate = null)
    {
        // validation for constraint: float
        if (!is_null($calculationRate) && !(is_float($calculationRate) || is_numeric($calculationRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($calculationRate, true), gettype($calculationRate)), __LINE__);
        }
        $this->CalculationRate = $calculationRate;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \StructType\ExchangeRate
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get SourceCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSourceCurrencyCode()
    {
        return isset($this->SourceCurrencyCode) ? $this->SourceCurrencyCode : null;
    }
    /**
     * Set SourceCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sourceCurrencyCode
     * @return \StructType\ExchangeRate
     */
    public function setSourceCurrencyCode($sourceCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($sourceCurrencyCode) && !is_string($sourceCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceCurrencyCode, true), gettype($sourceCurrencyCode)), __LINE__);
        }
        if (is_null($sourceCurrencyCode) || (is_array($sourceCurrencyCode) && empty($sourceCurrencyCode))) {
            unset($this->SourceCurrencyCode);
        } else {
            $this->SourceCurrencyCode = $sourceCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TargetCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetCurrencyCode()
    {
        return isset($this->TargetCurrencyCode) ? $this->TargetCurrencyCode : null;
    }
    /**
     * Set TargetCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetCurrencyCode
     * @return \StructType\ExchangeRate
     */
    public function setTargetCurrencyCode($targetCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($targetCurrencyCode) && !is_string($targetCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetCurrencyCode, true), gettype($targetCurrencyCode)), __LINE__);
        }
        if (is_null($targetCurrencyCode) || (is_array($targetCurrencyCode) && empty($targetCurrencyCode))) {
            unset($this->TargetCurrencyCode);
        } else {
            $this->TargetCurrencyCode = $targetCurrencyCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExchangeRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
