<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadInvoiceResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DownloadInvoiceResponse
 * @subpackage Structs
 */
class DownloadInvoiceResponse extends ResponseBase
{
    /**
     * The ViewContent
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ViewContent;
    /**
     * The DownloadInvoiceResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DownloadInvoiceResponse
     */
    public $DownloadInvoiceResult;
    /**
     * Constructor method for DownloadInvoiceResponse
     * @uses DownloadInvoiceResponse::setViewContent()
     * @uses DownloadInvoiceResponse::setDownloadInvoiceResult()
     * @param string $viewContent
     * @param \StructType\DownloadInvoiceResponse $downloadInvoiceResult
     */
    public function __construct($viewContent = null, \StructType\DownloadInvoiceResponse $downloadInvoiceResult = null)
    {
        $this
            ->setViewContent($viewContent)
            ->setDownloadInvoiceResult($downloadInvoiceResult);
    }
    /**
     * Get ViewContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getViewContent()
    {
        return isset($this->ViewContent) ? $this->ViewContent : null;
    }
    /**
     * Set ViewContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $viewContent
     * @return \StructType\DownloadInvoiceResponse
     */
    public function setViewContent($viewContent = null)
    {
        // validation for constraint: string
        if (!is_null($viewContent) && !is_string($viewContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($viewContent, true), gettype($viewContent)), __LINE__);
        }
        if (is_null($viewContent) || (is_array($viewContent) && empty($viewContent))) {
            unset($this->ViewContent);
        } else {
            $this->ViewContent = $viewContent;
        }
        return $this;
    }
    /**
     * Get DownloadInvoiceResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DownloadInvoiceResponse|null
     */
    public function getDownloadInvoiceResult()
    {
        return isset($this->DownloadInvoiceResult) ? $this->DownloadInvoiceResult : null;
    }
    /**
     * Set DownloadInvoiceResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DownloadInvoiceResponse $downloadInvoiceResult
     * @return \StructType\DownloadInvoiceResponse
     */
    public function setDownloadInvoiceResult(\StructType\DownloadInvoiceResponse $downloadInvoiceResult = null)
    {
        if (is_null($downloadInvoiceResult) || (is_array($downloadInvoiceResult) && empty($downloadInvoiceResult))) {
            unset($this->DownloadInvoiceResult);
        } else {
            $this->DownloadInvoiceResult = $downloadInvoiceResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DownloadInvoiceResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
