<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DownloadInvoiceRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DownloadInvoiceRequest
 * @subpackage Structs
 */
class DownloadInvoiceRequest extends RequestBase
{
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The TrackNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackNumber;
    /**
     * The ViewContentType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ViewContentType;
    /**
     * Constructor method for DownloadInvoiceRequest
     * @uses DownloadInvoiceRequest::setReferenceNumber()
     * @uses DownloadInvoiceRequest::setTrackNumber()
     * @uses DownloadInvoiceRequest::setViewContentType()
     * @param int $referenceNumber
     * @param string $trackNumber
     * @param int $viewContentType
     */
    public function __construct($referenceNumber = null, $trackNumber = null, $viewContentType = null)
    {
        $this
            ->setReferenceNumber($referenceNumber)
            ->setTrackNumber($trackNumber)
            ->setViewContentType($viewContentType);
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\DownloadInvoiceRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Get TrackNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackNumber()
    {
        return isset($this->TrackNumber) ? $this->TrackNumber : null;
    }
    /**
     * Set TrackNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackNumber
     * @return \StructType\DownloadInvoiceRequest
     */
    public function setTrackNumber($trackNumber = null)
    {
        // validation for constraint: string
        if (!is_null($trackNumber) && !is_string($trackNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackNumber, true), gettype($trackNumber)), __LINE__);
        }
        if (is_null($trackNumber) || (is_array($trackNumber) && empty($trackNumber))) {
            unset($this->TrackNumber);
        } else {
            $this->TrackNumber = $trackNumber;
        }
        return $this;
    }
    /**
     * Get ViewContentType value
     * @return int|null
     */
    public function getViewContentType()
    {
        return $this->ViewContentType;
    }
    /**
     * Set ViewContentType value
     * @param int $viewContentType
     * @return \StructType\DownloadInvoiceRequest
     */
    public function setViewContentType($viewContentType = null)
    {
        // validation for constraint: int
        if (!is_null($viewContentType) && !(is_int($viewContentType) || ctype_digit($viewContentType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($viewContentType, true), gettype($viewContentType)), __LINE__);
        }
        $this->ViewContentType = $viewContentType;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DownloadInvoiceRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
