<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DoReconciliationRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DoReconciliationRequest
 * @subpackage Structs
 */
class DoReconciliationRequest extends RequestBase
{
    /**
     * The ReconciliationDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ReconciliationDate;
    /**
     * The ReconciliationStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReconciliationStatus;
    /**
     * Constructor method for DoReconciliationRequest
     * @uses DoReconciliationRequest::setReconciliationDate()
     * @uses DoReconciliationRequest::setReconciliationStatus()
     * @param string $reconciliationDate
     * @param int $reconciliationStatus
     */
    public function __construct($reconciliationDate = null, $reconciliationStatus = null)
    {
        $this
            ->setReconciliationDate($reconciliationDate)
            ->setReconciliationStatus($reconciliationStatus);
    }
    /**
     * Get ReconciliationDate value
     * @return string|null
     */
    public function getReconciliationDate()
    {
        return $this->ReconciliationDate;
    }
    /**
     * Set ReconciliationDate value
     * @param string $reconciliationDate
     * @return \StructType\DoReconciliationRequest
     */
    public function setReconciliationDate($reconciliationDate = null)
    {
        // validation for constraint: string
        if (!is_null($reconciliationDate) && !is_string($reconciliationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reconciliationDate, true), gettype($reconciliationDate)), __LINE__);
        }
        $this->ReconciliationDate = $reconciliationDate;
        return $this;
    }
    /**
     * Get ReconciliationStatus value
     * @return int|null
     */
    public function getReconciliationStatus()
    {
        return $this->ReconciliationStatus;
    }
    /**
     * Set ReconciliationStatus value
     * @param int $reconciliationStatus
     * @return \StructType\DoReconciliationRequest
     */
    public function setReconciliationStatus($reconciliationStatus = null)
    {
        // validation for constraint: int
        if (!is_null($reconciliationStatus) && !(is_int($reconciliationStatus) || ctype_digit($reconciliationStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reconciliationStatus, true), gettype($reconciliationStatus)), __LINE__);
        }
        $this->ReconciliationStatus = $reconciliationStatus;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DoReconciliationRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
