<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Dimension StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Dimension
 * @subpackage Structs
 */
class Dimension extends AbstractStructBase
{
    /**
     * The AttributeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttributeID;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Description;
    /**
     * The MaximumMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $MaximumMeasure;
    /**
     * The Measure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $Measure;
    /**
     * The MinimumMeasure
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Measure
     */
    public $MinimumMeasure;
    /**
     * Constructor method for Dimension
     * @uses Dimension::setAttributeID()
     * @uses Dimension::setDescription()
     * @uses Dimension::setMaximumMeasure()
     * @uses Dimension::setMeasure()
     * @uses Dimension::setMinimumMeasure()
     * @param string $attributeID
     * @param \ArrayType\ArrayOfstring $description
     * @param \StructType\Measure $maximumMeasure
     * @param \StructType\Measure $measure
     * @param \StructType\Measure $minimumMeasure
     */
    public function __construct($attributeID = null, \ArrayType\ArrayOfstring $description = null, \StructType\Measure $maximumMeasure = null, \StructType\Measure $measure = null, \StructType\Measure $minimumMeasure = null)
    {
        $this
            ->setAttributeID($attributeID)
            ->setDescription($description)
            ->setMaximumMeasure($maximumMeasure)
            ->setMeasure($measure)
            ->setMinimumMeasure($minimumMeasure);
    }
    /**
     * Get AttributeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttributeID()
    {
        return isset($this->AttributeID) ? $this->AttributeID : null;
    }
    /**
     * Set AttributeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $attributeID
     * @return \StructType\Dimension
     */
    public function setAttributeID($attributeID = null)
    {
        // validation for constraint: string
        if (!is_null($attributeID) && !is_string($attributeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($attributeID, true), gettype($attributeID)), __LINE__);
        }
        if (is_null($attributeID) || (is_array($attributeID) && empty($attributeID))) {
            unset($this->AttributeID);
        } else {
            $this->AttributeID = $attributeID;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $description
     * @return \StructType\Dimension
     */
    public function setDescription(\ArrayType\ArrayOfstring $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get MaximumMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getMaximumMeasure()
    {
        return isset($this->MaximumMeasure) ? $this->MaximumMeasure : null;
    }
    /**
     * Set MaximumMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $maximumMeasure
     * @return \StructType\Dimension
     */
    public function setMaximumMeasure(\StructType\Measure $maximumMeasure = null)
    {
        if (is_null($maximumMeasure) || (is_array($maximumMeasure) && empty($maximumMeasure))) {
            unset($this->MaximumMeasure);
        } else {
            $this->MaximumMeasure = $maximumMeasure;
        }
        return $this;
    }
    /**
     * Get Measure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getMeasure()
    {
        return isset($this->Measure) ? $this->Measure : null;
    }
    /**
     * Set Measure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $measure
     * @return \StructType\Dimension
     */
    public function setMeasure(\StructType\Measure $measure = null)
    {
        if (is_null($measure) || (is_array($measure) && empty($measure))) {
            unset($this->Measure);
        } else {
            $this->Measure = $measure;
        }
        return $this;
    }
    /**
     * Get MinimumMeasure value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Measure|null
     */
    public function getMinimumMeasure()
    {
        return isset($this->MinimumMeasure) ? $this->MinimumMeasure : null;
    }
    /**
     * Set MinimumMeasure value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Measure $minimumMeasure
     * @return \StructType\Dimension
     */
    public function setMinimumMeasure(\StructType\Measure $minimumMeasure = null)
    {
        if (is_null($minimumMeasure) || (is_array($minimumMeasure) && empty($minimumMeasure))) {
            unset($this->MinimumMeasure);
        } else {
            $this->MinimumMeasure = $minimumMeasure;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Dimension
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
