<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Despatch StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Despatch
 * @subpackage Structs
 */
class Despatch extends AbstractStructBase
{
    /**
     * The ActualDespatchDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualDespatchDateTime;
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The DespatchAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $DespatchAddress;
    /**
     * The DespatchParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $DespatchParty;
    /**
     * The EstimatedDespatchPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period
     */
    public $EstimatedDespatchPeriod;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The Instructions
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Instructions;
    /**
     * Constructor method for Despatch
     * @uses Despatch::setActualDespatchDateTime()
     * @uses Despatch::setContact()
     * @uses Despatch::setDespatchAddress()
     * @uses Despatch::setDespatchParty()
     * @uses Despatch::setEstimatedDespatchPeriod()
     * @uses Despatch::setID()
     * @uses Despatch::setInstructions()
     * @param string $actualDespatchDateTime
     * @param \StructType\Contact $contact
     * @param \StructType\Address $despatchAddress
     * @param \StructType\Party $despatchParty
     * @param \StructType\Period $estimatedDespatchPeriod
     * @param string $iD
     * @param string $instructions
     */
    public function __construct($actualDespatchDateTime = null, \StructType\Contact $contact = null, \StructType\Address $despatchAddress = null, \StructType\Party $despatchParty = null, \StructType\Period $estimatedDespatchPeriod = null, $iD = null, $instructions = null)
    {
        $this
            ->setActualDespatchDateTime($actualDespatchDateTime)
            ->setContact($contact)
            ->setDespatchAddress($despatchAddress)
            ->setDespatchParty($despatchParty)
            ->setEstimatedDespatchPeriod($estimatedDespatchPeriod)
            ->setID($iD)
            ->setInstructions($instructions);
    }
    /**
     * Get ActualDespatchDateTime value
     * @return string|null
     */
    public function getActualDespatchDateTime()
    {
        return $this->ActualDespatchDateTime;
    }
    /**
     * Set ActualDespatchDateTime value
     * @param string $actualDespatchDateTime
     * @return \StructType\Despatch
     */
    public function setActualDespatchDateTime($actualDespatchDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDespatchDateTime) && !is_string($actualDespatchDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDespatchDateTime, true), gettype($actualDespatchDateTime)), __LINE__);
        }
        $this->ActualDespatchDateTime = $actualDespatchDateTime;
        return $this;
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\Despatch
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get DespatchAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getDespatchAddress()
    {
        return isset($this->DespatchAddress) ? $this->DespatchAddress : null;
    }
    /**
     * Set DespatchAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $despatchAddress
     * @return \StructType\Despatch
     */
    public function setDespatchAddress(\StructType\Address $despatchAddress = null)
    {
        if (is_null($despatchAddress) || (is_array($despatchAddress) && empty($despatchAddress))) {
            unset($this->DespatchAddress);
        } else {
            $this->DespatchAddress = $despatchAddress;
        }
        return $this;
    }
    /**
     * Get DespatchParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getDespatchParty()
    {
        return isset($this->DespatchParty) ? $this->DespatchParty : null;
    }
    /**
     * Set DespatchParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $despatchParty
     * @return \StructType\Despatch
     */
    public function setDespatchParty(\StructType\Party $despatchParty = null)
    {
        if (is_null($despatchParty) || (is_array($despatchParty) && empty($despatchParty))) {
            unset($this->DespatchParty);
        } else {
            $this->DespatchParty = $despatchParty;
        }
        return $this;
    }
    /**
     * Get EstimatedDespatchPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period|null
     */
    public function getEstimatedDespatchPeriod()
    {
        return isset($this->EstimatedDespatchPeriod) ? $this->EstimatedDespatchPeriod : null;
    }
    /**
     * Set EstimatedDespatchPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Period $estimatedDespatchPeriod
     * @return \StructType\Despatch
     */
    public function setEstimatedDespatchPeriod(\StructType\Period $estimatedDespatchPeriod = null)
    {
        if (is_null($estimatedDespatchPeriod) || (is_array($estimatedDespatchPeriod) && empty($estimatedDespatchPeriod))) {
            unset($this->EstimatedDespatchPeriod);
        } else {
            $this->EstimatedDespatchPeriod = $estimatedDespatchPeriod;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Despatch
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get Instructions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstructions()
    {
        return isset($this->Instructions) ? $this->Instructions : null;
    }
    /**
     * Set Instructions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instructions
     * @return \StructType\Despatch
     */
    public function setInstructions($instructions = null)
    {
        // validation for constraint: string
        if (!is_null($instructions) && !is_string($instructions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instructions, true), gettype($instructions)), __LINE__);
        }
        if (is_null($instructions) || (is_array($instructions) && empty($instructions))) {
            unset($this->Instructions);
        } else {
            $this->Instructions = $instructions;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Despatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
