<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DeliveryTerms StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:DeliveryTerms
 * @subpackage Structs
 */
class DeliveryTerms extends AbstractStructBase
{
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The SpecialTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpecialTerms;
    /**
     * Constructor method for DeliveryTerms
     * @uses DeliveryTerms::setAmount()
     * @uses DeliveryTerms::setID()
     * @uses DeliveryTerms::setSpecialTerms()
     * @param \StructType\Amount $amount
     * @param string $iD
     * @param string $specialTerms
     */
    public function __construct(\StructType\Amount $amount = null, $iD = null, $specialTerms = null)
    {
        $this
            ->setAmount($amount)
            ->setID($iD)
            ->setSpecialTerms($specialTerms);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $amount
     * @return \StructType\DeliveryTerms
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\DeliveryTerms
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get SpecialTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecialTerms()
    {
        return isset($this->SpecialTerms) ? $this->SpecialTerms : null;
    }
    /**
     * Set SpecialTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specialTerms
     * @return \StructType\DeliveryTerms
     */
    public function setSpecialTerms($specialTerms = null)
    {
        // validation for constraint: string
        if (!is_null($specialTerms) && !is_string($specialTerms)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialTerms, true), gettype($specialTerms)), __LINE__);
        }
        if (is_null($specialTerms) || (is_array($specialTerms) && empty($specialTerms))) {
            unset($this->SpecialTerms);
        } else {
            $this->SpecialTerms = $specialTerms;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DeliveryTerms
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
