<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Delivery StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Delivery
 * @subpackage Structs
 */
class Delivery extends AbstractStructBase
{
    /**
     * The ActualDeliveryDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ActualDeliveryDateTime;
    /**
     * The AlternativeDeliveryLocation
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Location
     */
    public $AlternativeDeliveryLocation;
    /**
     * The CarrierParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $CarrierParty;
    /**
     * The DeliveryAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $DeliveryAddress;
    /**
     * The DeliveryParty
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Party
     */
    public $DeliveryParty;
    /**
     * The DeliveryTerms
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfDeliveryTerms
     */
    public $DeliveryTerms;
    /**
     * The Despatch
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Despatch
     */
    public $Despatch;
    /**
     * The EstimatedDeliveryPeriod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Period
     */
    public $EstimatedDeliveryPeriod;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The LatestDeliveryDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $LatestDeliveryDateTime;
    /**
     * The Quantity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Quantity;
    /**
     * The Shipment
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Shipment
     */
    public $Shipment;
    /**
     * The TrackingID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrackingID;
    /**
     * Constructor method for Delivery
     * @uses Delivery::setActualDeliveryDateTime()
     * @uses Delivery::setAlternativeDeliveryLocation()
     * @uses Delivery::setCarrierParty()
     * @uses Delivery::setDeliveryAddress()
     * @uses Delivery::setDeliveryParty()
     * @uses Delivery::setDeliveryTerms()
     * @uses Delivery::setDespatch()
     * @uses Delivery::setEstimatedDeliveryPeriod()
     * @uses Delivery::setID()
     * @uses Delivery::setLatestDeliveryDateTime()
     * @uses Delivery::setQuantity()
     * @uses Delivery::setShipment()
     * @uses Delivery::setTrackingID()
     * @param string $actualDeliveryDateTime
     * @param \StructType\Location $alternativeDeliveryLocation
     * @param \StructType\Party $carrierParty
     * @param \StructType\Address $deliveryAddress
     * @param \StructType\Party $deliveryParty
     * @param \ArrayType\ArrayOfDeliveryTerms $deliveryTerms
     * @param \StructType\Despatch $despatch
     * @param \StructType\Period $estimatedDeliveryPeriod
     * @param string $iD
     * @param string $latestDeliveryDateTime
     * @param float $quantity
     * @param \StructType\Shipment $shipment
     * @param string $trackingID
     */
    public function __construct($actualDeliveryDateTime = null, \StructType\Location $alternativeDeliveryLocation = null, \StructType\Party $carrierParty = null, \StructType\Address $deliveryAddress = null, \StructType\Party $deliveryParty = null, \ArrayType\ArrayOfDeliveryTerms $deliveryTerms = null, \StructType\Despatch $despatch = null, \StructType\Period $estimatedDeliveryPeriod = null, $iD = null, $latestDeliveryDateTime = null, $quantity = null, \StructType\Shipment $shipment = null, $trackingID = null)
    {
        $this
            ->setActualDeliveryDateTime($actualDeliveryDateTime)
            ->setAlternativeDeliveryLocation($alternativeDeliveryLocation)
            ->setCarrierParty($carrierParty)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryParty($deliveryParty)
            ->setDeliveryTerms($deliveryTerms)
            ->setDespatch($despatch)
            ->setEstimatedDeliveryPeriod($estimatedDeliveryPeriod)
            ->setID($iD)
            ->setLatestDeliveryDateTime($latestDeliveryDateTime)
            ->setQuantity($quantity)
            ->setShipment($shipment)
            ->setTrackingID($trackingID);
    }
    /**
     * Get ActualDeliveryDateTime value
     * @return string|null
     */
    public function getActualDeliveryDateTime()
    {
        return $this->ActualDeliveryDateTime;
    }
    /**
     * Set ActualDeliveryDateTime value
     * @param string $actualDeliveryDateTime
     * @return \StructType\Delivery
     */
    public function setActualDeliveryDateTime($actualDeliveryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($actualDeliveryDateTime) && !is_string($actualDeliveryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actualDeliveryDateTime, true), gettype($actualDeliveryDateTime)), __LINE__);
        }
        $this->ActualDeliveryDateTime = $actualDeliveryDateTime;
        return $this;
    }
    /**
     * Get AlternativeDeliveryLocation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Location|null
     */
    public function getAlternativeDeliveryLocation()
    {
        return isset($this->AlternativeDeliveryLocation) ? $this->AlternativeDeliveryLocation : null;
    }
    /**
     * Set AlternativeDeliveryLocation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Location $alternativeDeliveryLocation
     * @return \StructType\Delivery
     */
    public function setAlternativeDeliveryLocation(\StructType\Location $alternativeDeliveryLocation = null)
    {
        if (is_null($alternativeDeliveryLocation) || (is_array($alternativeDeliveryLocation) && empty($alternativeDeliveryLocation))) {
            unset($this->AlternativeDeliveryLocation);
        } else {
            $this->AlternativeDeliveryLocation = $alternativeDeliveryLocation;
        }
        return $this;
    }
    /**
     * Get CarrierParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getCarrierParty()
    {
        return isset($this->CarrierParty) ? $this->CarrierParty : null;
    }
    /**
     * Set CarrierParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $carrierParty
     * @return \StructType\Delivery
     */
    public function setCarrierParty(\StructType\Party $carrierParty = null)
    {
        if (is_null($carrierParty) || (is_array($carrierParty) && empty($carrierParty))) {
            unset($this->CarrierParty);
        } else {
            $this->CarrierParty = $carrierParty;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->DeliveryAddress) ? $this->DeliveryAddress : null;
    }
    /**
     * Set DeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $deliveryAddress
     * @return \StructType\Delivery
     */
    public function setDeliveryAddress(\StructType\Address $deliveryAddress = null)
    {
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->DeliveryAddress);
        } else {
            $this->DeliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get DeliveryParty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Party|null
     */
    public function getDeliveryParty()
    {
        return isset($this->DeliveryParty) ? $this->DeliveryParty : null;
    }
    /**
     * Set DeliveryParty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Party $deliveryParty
     * @return \StructType\Delivery
     */
    public function setDeliveryParty(\StructType\Party $deliveryParty = null)
    {
        if (is_null($deliveryParty) || (is_array($deliveryParty) && empty($deliveryParty))) {
            unset($this->DeliveryParty);
        } else {
            $this->DeliveryParty = $deliveryParty;
        }
        return $this;
    }
    /**
     * Get DeliveryTerms value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfDeliveryTerms|null
     */
    public function getDeliveryTerms()
    {
        return isset($this->DeliveryTerms) ? $this->DeliveryTerms : null;
    }
    /**
     * Set DeliveryTerms value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfDeliveryTerms $deliveryTerms
     * @return \StructType\Delivery
     */
    public function setDeliveryTerms(\ArrayType\ArrayOfDeliveryTerms $deliveryTerms = null)
    {
        if (is_null($deliveryTerms) || (is_array($deliveryTerms) && empty($deliveryTerms))) {
            unset($this->DeliveryTerms);
        } else {
            $this->DeliveryTerms = $deliveryTerms;
        }
        return $this;
    }
    /**
     * Get Despatch value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Despatch|null
     */
    public function getDespatch()
    {
        return isset($this->Despatch) ? $this->Despatch : null;
    }
    /**
     * Set Despatch value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Despatch $despatch
     * @return \StructType\Delivery
     */
    public function setDespatch(\StructType\Despatch $despatch = null)
    {
        if (is_null($despatch) || (is_array($despatch) && empty($despatch))) {
            unset($this->Despatch);
        } else {
            $this->Despatch = $despatch;
        }
        return $this;
    }
    /**
     * Get EstimatedDeliveryPeriod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Period|null
     */
    public function getEstimatedDeliveryPeriod()
    {
        return isset($this->EstimatedDeliveryPeriod) ? $this->EstimatedDeliveryPeriod : null;
    }
    /**
     * Set EstimatedDeliveryPeriod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Period $estimatedDeliveryPeriod
     * @return \StructType\Delivery
     */
    public function setEstimatedDeliveryPeriod(\StructType\Period $estimatedDeliveryPeriod = null)
    {
        if (is_null($estimatedDeliveryPeriod) || (is_array($estimatedDeliveryPeriod) && empty($estimatedDeliveryPeriod))) {
            unset($this->EstimatedDeliveryPeriod);
        } else {
            $this->EstimatedDeliveryPeriod = $estimatedDeliveryPeriod;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Delivery
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get LatestDeliveryDateTime value
     * @return string|null
     */
    public function getLatestDeliveryDateTime()
    {
        return $this->LatestDeliveryDateTime;
    }
    /**
     * Set LatestDeliveryDateTime value
     * @param string $latestDeliveryDateTime
     * @return \StructType\Delivery
     */
    public function setLatestDeliveryDateTime($latestDeliveryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($latestDeliveryDateTime) && !is_string($latestDeliveryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($latestDeliveryDateTime, true), gettype($latestDeliveryDateTime)), __LINE__);
        }
        $this->LatestDeliveryDateTime = $latestDeliveryDateTime;
        return $this;
    }
    /**
     * Get Quantity value
     * @return float|null
     */
    public function getQuantity()
    {
        return $this->Quantity;
    }
    /**
     * Set Quantity value
     * @param float $quantity
     * @return \StructType\Delivery
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: float
        if (!is_null($quantity) && !(is_float($quantity) || is_numeric($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        $this->Quantity = $quantity;
        return $this;
    }
    /**
     * Get Shipment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Shipment|null
     */
    public function getShipment()
    {
        return isset($this->Shipment) ? $this->Shipment : null;
    }
    /**
     * Set Shipment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Shipment $shipment
     * @return \StructType\Delivery
     */
    public function setShipment(\StructType\Shipment $shipment = null)
    {
        if (is_null($shipment) || (is_array($shipment) && empty($shipment))) {
            unset($this->Shipment);
        } else {
            $this->Shipment = $shipment;
        }
        return $this;
    }
    /**
     * Get TrackingID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrackingID()
    {
        return isset($this->TrackingID) ? $this->TrackingID : null;
    }
    /**
     * Set TrackingID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trackingID
     * @return \StructType\Delivery
     */
    public function setTrackingID($trackingID = null)
    {
        // validation for constraint: string
        if (!is_null($trackingID) && !is_string($trackingID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trackingID, true), gettype($trackingID)), __LINE__);
        }
        if (is_null($trackingID) || (is_array($trackingID) && empty($trackingID))) {
            unset($this->TrackingID);
        } else {
            $this->TrackingID = $trackingID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Delivery
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
