<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomerInquiryResponse StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomerInquiryResponse
 * @subpackage Structs
 */
class CustomerInquiryResponse extends ResponseBase
{
    /**
     * The Customers
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfCustomer
     */
    public $Customers;
    /**
     * The CustomerInquiryResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CustomerInquiryResponse
     */
    public $CustomerInquiryResult;
    /**
     * Constructor method for CustomerInquiryResponse
     * @uses CustomerInquiryResponse::setCustomers()
     * @uses CustomerInquiryResponse::setCustomerInquiryResult()
     * @param \ArrayType\ArrayOfCustomer $customers
     * @param \StructType\CustomerInquiryResponse $customerInquiryResult
     */
    public function __construct(\ArrayType\ArrayOfCustomer $customers = null, \StructType\CustomerInquiryResponse $customerInquiryResult = null)
    {
        $this
            ->setCustomers($customers)
            ->setCustomerInquiryResult($customerInquiryResult);
    }
    /**
     * Get Customers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfCustomer|null
     */
    public function getCustomers()
    {
        return isset($this->Customers) ? $this->Customers : null;
    }
    /**
     * Set Customers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfCustomer $customers
     * @return \StructType\CustomerInquiryResponse
     */
    public function setCustomers(\ArrayType\ArrayOfCustomer $customers = null)
    {
        if (is_null($customers) || (is_array($customers) && empty($customers))) {
            unset($this->Customers);
        } else {
            $this->Customers = $customers;
        }
        return $this;
    }
    /**
     * Get CustomerInquiryResult value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CustomerInquiryResponse|null
     */
    public function getCustomerInquiryResult()
    {
        return isset($this->CustomerInquiryResult) ? $this->CustomerInquiryResult : null;
    }
    /**
     * Set CustomerInquiryResult value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CustomerInquiryResponse $customerInquiryResult
     * @return \StructType\CustomerInquiryResponse
     */
    public function setCustomerInquiryResult(\StructType\CustomerInquiryResponse $customerInquiryResult = null)
    {
        if (is_null($customerInquiryResult) || (is_array($customerInquiryResult) && empty($customerInquiryResult))) {
            unset($this->CustomerInquiryResult);
        } else {
            $this->CustomerInquiryResult = $customerInquiryResult;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomerInquiryResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
