<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Customer StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Customer
 * @subpackage Structs
 */
class Customer extends AbstractStructBase
{
    /**
     * The CustomerCreatedOn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CustomerCreatedOn;
    /**
     * The IdentityNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentityNumber;
    /**
     * The IsExists
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExists;
    /**
     * The ReceiverAliasses
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfReceiverAlias
     */
    public $ReceiverAliasses;
    /**
     * Constructor method for Customer
     * @uses Customer::setCustomerCreatedOn()
     * @uses Customer::setIdentityNumber()
     * @uses Customer::setIsExists()
     * @uses Customer::setReceiverAliasses()
     * @param string $customerCreatedOn
     * @param string $identityNumber
     * @param bool $isExists
     * @param \ArrayType\ArrayOfReceiverAlias $receiverAliasses
     */
    public function __construct($customerCreatedOn = null, $identityNumber = null, $isExists = null, \ArrayType\ArrayOfReceiverAlias $receiverAliasses = null)
    {
        $this
            ->setCustomerCreatedOn($customerCreatedOn)
            ->setIdentityNumber($identityNumber)
            ->setIsExists($isExists)
            ->setReceiverAliasses($receiverAliasses);
    }
    /**
     * Get CustomerCreatedOn value
     * @return string|null
     */
    public function getCustomerCreatedOn()
    {
        return $this->CustomerCreatedOn;
    }
    /**
     * Set CustomerCreatedOn value
     * @param string $customerCreatedOn
     * @return \StructType\Customer
     */
    public function setCustomerCreatedOn($customerCreatedOn = null)
    {
        // validation for constraint: string
        if (!is_null($customerCreatedOn) && !is_string($customerCreatedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerCreatedOn, true), gettype($customerCreatedOn)), __LINE__);
        }
        $this->CustomerCreatedOn = $customerCreatedOn;
        return $this;
    }
    /**
     * Get IdentityNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentityNumber()
    {
        return isset($this->IdentityNumber) ? $this->IdentityNumber : null;
    }
    /**
     * Set IdentityNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identityNumber
     * @return \StructType\Customer
     */
    public function setIdentityNumber($identityNumber = null)
    {
        // validation for constraint: string
        if (!is_null($identityNumber) && !is_string($identityNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityNumber, true), gettype($identityNumber)), __LINE__);
        }
        if (is_null($identityNumber) || (is_array($identityNumber) && empty($identityNumber))) {
            unset($this->IdentityNumber);
        } else {
            $this->IdentityNumber = $identityNumber;
        }
        return $this;
    }
    /**
     * Get IsExists value
     * @return bool|null
     */
    public function getIsExists()
    {
        return $this->IsExists;
    }
    /**
     * Set IsExists value
     * @param bool $isExists
     * @return \StructType\Customer
     */
    public function setIsExists($isExists = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExists) && !is_bool($isExists)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExists, true), gettype($isExists)), __LINE__);
        }
        $this->IsExists = $isExists;
        return $this;
    }
    /**
     * Get ReceiverAliasses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfReceiverAlias|null
     */
    public function getReceiverAliasses()
    {
        return isset($this->ReceiverAliasses) ? $this->ReceiverAliasses : null;
    }
    /**
     * Set ReceiverAliasses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfReceiverAlias $receiverAliasses
     * @return \StructType\Customer
     */
    public function setReceiverAliasses(\ArrayType\ArrayOfReceiverAlias $receiverAliasses = null)
    {
        if (is_null($receiverAliasses) || (is_array($receiverAliasses) && empty($receiverAliasses))) {
            unset($this->ReceiverAliasses);
        } else {
            $this->ReceiverAliasses = $receiverAliasses;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Customer
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
