<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustomPostBoxEnvelopeInquiryRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CustomPostBoxEnvelopeInquiryRequest
 * @subpackage Structs
 */
class CustomPostBoxEnvelopeInquiryRequest extends RequestBase
{
    /**
     * The AcceptanceDateTime
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AcceptanceDateTime;
    /**
     * The MaxItemsToReturn
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MaxItemsToReturn;
    /**
     * The RequestNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $RequestNumber;
    /**
     * Constructor method for CustomPostBoxEnvelopeInquiryRequest
     * @uses CustomPostBoxEnvelopeInquiryRequest::setAcceptanceDateTime()
     * @uses CustomPostBoxEnvelopeInquiryRequest::setMaxItemsToReturn()
     * @uses CustomPostBoxEnvelopeInquiryRequest::setRequestNumber()
     * @param string $acceptanceDateTime
     * @param int $maxItemsToReturn
     * @param int $requestNumber
     */
    public function __construct($acceptanceDateTime = null, $maxItemsToReturn = null, $requestNumber = null)
    {
        $this
            ->setAcceptanceDateTime($acceptanceDateTime)
            ->setMaxItemsToReturn($maxItemsToReturn)
            ->setRequestNumber($requestNumber);
    }
    /**
     * Get AcceptanceDateTime value
     * @return string|null
     */
    public function getAcceptanceDateTime()
    {
        return $this->AcceptanceDateTime;
    }
    /**
     * Set AcceptanceDateTime value
     * @param string $acceptanceDateTime
     * @return \StructType\CustomPostBoxEnvelopeInquiryRequest
     */
    public function setAcceptanceDateTime($acceptanceDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($acceptanceDateTime) && !is_string($acceptanceDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($acceptanceDateTime, true), gettype($acceptanceDateTime)), __LINE__);
        }
        $this->AcceptanceDateTime = $acceptanceDateTime;
        return $this;
    }
    /**
     * Get MaxItemsToReturn value
     * @return int|null
     */
    public function getMaxItemsToReturn()
    {
        return $this->MaxItemsToReturn;
    }
    /**
     * Set MaxItemsToReturn value
     * @param int $maxItemsToReturn
     * @return \StructType\CustomPostBoxEnvelopeInquiryRequest
     */
    public function setMaxItemsToReturn($maxItemsToReturn = null)
    {
        // validation for constraint: int
        if (!is_null($maxItemsToReturn) && !(is_int($maxItemsToReturn) || ctype_digit($maxItemsToReturn))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxItemsToReturn, true), gettype($maxItemsToReturn)), __LINE__);
        }
        $this->MaxItemsToReturn = $maxItemsToReturn;
        return $this;
    }
    /**
     * Get RequestNumber value
     * @return int|null
     */
    public function getRequestNumber()
    {
        return $this->RequestNumber;
    }
    /**
     * Set RequestNumber value
     * @param int $requestNumber
     * @return \StructType\CustomPostBoxEnvelopeInquiryRequest
     */
    public function setRequestNumber($requestNumber = null)
    {
        // validation for constraint: int
        if (!is_null($requestNumber) && !(is_int($requestNumber) || ctype_digit($requestNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($requestNumber, true), gettype($requestNumber)), __LINE__);
        }
        $this->RequestNumber = $requestNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustomPostBoxEnvelopeInquiryRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
