<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Country StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Country
 * @subpackage Structs
 */
class Country extends AbstractStructBase
{
    /**
     * The IdentificationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdentificationCode;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Country
     * @uses Country::setIdentificationCode()
     * @uses Country::setName()
     * @param string $identificationCode
     * @param string $name
     */
    public function __construct($identificationCode = null, $name = null)
    {
        $this
            ->setIdentificationCode($identificationCode)
            ->setName($name);
    }
    /**
     * Get IdentificationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentificationCode()
    {
        return isset($this->IdentificationCode) ? $this->IdentificationCode : null;
    }
    /**
     * Set IdentificationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identificationCode
     * @return \StructType\Country
     */
    public function setIdentificationCode($identificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($identificationCode) && !is_string($identificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identificationCode, true), gettype($identificationCode)), __LINE__);
        }
        if (is_null($identificationCode) || (is_array($identificationCode) && empty($identificationCode))) {
            unset($this->IdentificationCode);
        } else {
            $this->IdentificationCode = $identificationCode;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Country
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Country
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
