<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Contact StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Contact
 * @subpackage Structs
 */
class Contact extends AbstractStructBase
{
    /**
     * The ElectronicMail
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ElectronicMail;
    /**
     * The Name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Note
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The OtherCommunication
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherCommunication;
    /**
     * The Telefax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telefax;
    /**
     * The Telephone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Telephone;
    /**
     * Constructor method for Contact
     * @uses Contact::setElectronicMail()
     * @uses Contact::setName()
     * @uses Contact::setNote()
     * @uses Contact::setOtherCommunication()
     * @uses Contact::setTelefax()
     * @uses Contact::setTelephone()
     * @param string $electronicMail
     * @param string $name
     * @param string $note
     * @param string $otherCommunication
     * @param string $telefax
     * @param string $telephone
     */
    public function __construct($electronicMail = null, $name = null, $note = null, $otherCommunication = null, $telefax = null, $telephone = null)
    {
        $this
            ->setElectronicMail($electronicMail)
            ->setName($name)
            ->setNote($note)
            ->setOtherCommunication($otherCommunication)
            ->setTelefax($telefax)
            ->setTelephone($telephone);
    }
    /**
     * Get ElectronicMail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getElectronicMail()
    {
        return isset($this->ElectronicMail) ? $this->ElectronicMail : null;
    }
    /**
     * Set ElectronicMail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $electronicMail
     * @return \StructType\Contact
     */
    public function setElectronicMail($electronicMail = null)
    {
        // validation for constraint: string
        if (!is_null($electronicMail) && !is_string($electronicMail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($electronicMail, true), gettype($electronicMail)), __LINE__);
        }
        if (is_null($electronicMail) || (is_array($electronicMail) && empty($electronicMail))) {
            unset($this->ElectronicMail);
        } else {
            $this->ElectronicMail = $electronicMail;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \StructType\Contact
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \StructType\Contact
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get OtherCommunication value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherCommunication()
    {
        return isset($this->OtherCommunication) ? $this->OtherCommunication : null;
    }
    /**
     * Set OtherCommunication value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherCommunication
     * @return \StructType\Contact
     */
    public function setOtherCommunication($otherCommunication = null)
    {
        // validation for constraint: string
        if (!is_null($otherCommunication) && !is_string($otherCommunication)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherCommunication, true), gettype($otherCommunication)), __LINE__);
        }
        if (is_null($otherCommunication) || (is_array($otherCommunication) && empty($otherCommunication))) {
            unset($this->OtherCommunication);
        } else {
            $this->OtherCommunication = $otherCommunication;
        }
        return $this;
    }
    /**
     * Get Telefax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelefax()
    {
        return isset($this->Telefax) ? $this->Telefax : null;
    }
    /**
     * Set Telefax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telefax
     * @return \StructType\Contact
     */
    public function setTelefax($telefax = null)
    {
        // validation for constraint: string
        if (!is_null($telefax) && !is_string($telefax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telefax, true), gettype($telefax)), __LINE__);
        }
        if (is_null($telefax) || (is_array($telefax) && empty($telefax))) {
            unset($this->Telefax);
        } else {
            $this->Telefax = $telefax;
        }
        return $this;
    }
    /**
     * Get Telephone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTelephone()
    {
        return isset($this->Telephone) ? $this->Telephone : null;
    }
    /**
     * Set Telephone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $telephone
     * @return \StructType\Contact
     */
    public function setTelephone($telephone = null)
    {
        // validation for constraint: string
        if (!is_null($telephone) && !is_string($telephone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($telephone, true), gettype($telephone)), __LINE__);
        }
        if (is_null($telephone) || (is_array($telephone) && empty($telephone))) {
            unset($this->Telephone);
        } else {
            $this->Telephone = $telephone;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Contact
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
