<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelInvoiceWithKEPRequest StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CancelInvoiceWithKEPRequest
 * @subpackage Structs
 */
class CancelInvoiceWithKEPRequest extends RequestBase
{
    /**
     * The IsReturnInvoiceWithKEP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReturnInvoiceWithKEP;
    /**
     * The ReferenceNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ReferenceNumber;
    /**
     * Constructor method for CancelInvoiceWithKEPRequest
     * @uses CancelInvoiceWithKEPRequest::setIsReturnInvoiceWithKEP()
     * @uses CancelInvoiceWithKEPRequest::setReferenceNumber()
     * @param bool $isReturnInvoiceWithKEP
     * @param int $referenceNumber
     */
    public function __construct($isReturnInvoiceWithKEP = null, $referenceNumber = null)
    {
        $this
            ->setIsReturnInvoiceWithKEP($isReturnInvoiceWithKEP)
            ->setReferenceNumber($referenceNumber);
    }
    /**
     * Get IsReturnInvoiceWithKEP value
     * @return bool|null
     */
    public function getIsReturnInvoiceWithKEP()
    {
        return $this->IsReturnInvoiceWithKEP;
    }
    /**
     * Set IsReturnInvoiceWithKEP value
     * @param bool $isReturnInvoiceWithKEP
     * @return \StructType\CancelInvoiceWithKEPRequest
     */
    public function setIsReturnInvoiceWithKEP($isReturnInvoiceWithKEP = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturnInvoiceWithKEP) && !is_bool($isReturnInvoiceWithKEP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturnInvoiceWithKEP, true), gettype($isReturnInvoiceWithKEP)), __LINE__);
        }
        $this->IsReturnInvoiceWithKEP = $isReturnInvoiceWithKEP;
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return $this->ReferenceNumber;
    }
    /**
     * Set ReferenceNumber value
     * @param int $referenceNumber
     * @return \StructType\CancelInvoiceWithKEPRequest
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        $this->ReferenceNumber = $referenceNumber;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelInvoiceWithKEPRequest
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
