<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BillingReference StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:BillingReference
 * @subpackage Structs
 */
class BillingReference extends AbstractStructBase
{
    /**
     * The AdditionalDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $AdditionalDocumentReference;
    /**
     * The BillingReferenceLine
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfBillingReferenceLine
     */
    public $BillingReferenceLine;
    /**
     * The CreditNoteDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $CreditNoteDocumentReference;
    /**
     * The DebitNoteDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $DebitNoteDocumentReference;
    /**
     * The InvoiceDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $InvoiceDocumentReference;
    /**
     * The ReminderDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $ReminderDocumentReference;
    /**
     * The SelfBilledInvoiceDocumentReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DocumentReference
     */
    public $SelfBilledInvoiceDocumentReference;
    /**
     * Constructor method for BillingReference
     * @uses BillingReference::setAdditionalDocumentReference()
     * @uses BillingReference::setBillingReferenceLine()
     * @uses BillingReference::setCreditNoteDocumentReference()
     * @uses BillingReference::setDebitNoteDocumentReference()
     * @uses BillingReference::setInvoiceDocumentReference()
     * @uses BillingReference::setReminderDocumentReference()
     * @uses BillingReference::setSelfBilledInvoiceDocumentReference()
     * @param \StructType\DocumentReference $additionalDocumentReference
     * @param \ArrayType\ArrayOfBillingReferenceLine $billingReferenceLine
     * @param \StructType\DocumentReference $creditNoteDocumentReference
     * @param \StructType\DocumentReference $debitNoteDocumentReference
     * @param \StructType\DocumentReference $invoiceDocumentReference
     * @param \StructType\DocumentReference $reminderDocumentReference
     * @param \StructType\DocumentReference $selfBilledInvoiceDocumentReference
     */
    public function __construct(\StructType\DocumentReference $additionalDocumentReference = null, \ArrayType\ArrayOfBillingReferenceLine $billingReferenceLine = null, \StructType\DocumentReference $creditNoteDocumentReference = null, \StructType\DocumentReference $debitNoteDocumentReference = null, \StructType\DocumentReference $invoiceDocumentReference = null, \StructType\DocumentReference $reminderDocumentReference = null, \StructType\DocumentReference $selfBilledInvoiceDocumentReference = null)
    {
        $this
            ->setAdditionalDocumentReference($additionalDocumentReference)
            ->setBillingReferenceLine($billingReferenceLine)
            ->setCreditNoteDocumentReference($creditNoteDocumentReference)
            ->setDebitNoteDocumentReference($debitNoteDocumentReference)
            ->setInvoiceDocumentReference($invoiceDocumentReference)
            ->setReminderDocumentReference($reminderDocumentReference)
            ->setSelfBilledInvoiceDocumentReference($selfBilledInvoiceDocumentReference);
    }
    /**
     * Get AdditionalDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getAdditionalDocumentReference()
    {
        return isset($this->AdditionalDocumentReference) ? $this->AdditionalDocumentReference : null;
    }
    /**
     * Set AdditionalDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $additionalDocumentReference
     * @return \StructType\BillingReference
     */
    public function setAdditionalDocumentReference(\StructType\DocumentReference $additionalDocumentReference = null)
    {
        if (is_null($additionalDocumentReference) || (is_array($additionalDocumentReference) && empty($additionalDocumentReference))) {
            unset($this->AdditionalDocumentReference);
        } else {
            $this->AdditionalDocumentReference = $additionalDocumentReference;
        }
        return $this;
    }
    /**
     * Get BillingReferenceLine value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfBillingReferenceLine|null
     */
    public function getBillingReferenceLine()
    {
        return isset($this->BillingReferenceLine) ? $this->BillingReferenceLine : null;
    }
    /**
     * Set BillingReferenceLine value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfBillingReferenceLine $billingReferenceLine
     * @return \StructType\BillingReference
     */
    public function setBillingReferenceLine(\ArrayType\ArrayOfBillingReferenceLine $billingReferenceLine = null)
    {
        if (is_null($billingReferenceLine) || (is_array($billingReferenceLine) && empty($billingReferenceLine))) {
            unset($this->BillingReferenceLine);
        } else {
            $this->BillingReferenceLine = $billingReferenceLine;
        }
        return $this;
    }
    /**
     * Get CreditNoteDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getCreditNoteDocumentReference()
    {
        return isset($this->CreditNoteDocumentReference) ? $this->CreditNoteDocumentReference : null;
    }
    /**
     * Set CreditNoteDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $creditNoteDocumentReference
     * @return \StructType\BillingReference
     */
    public function setCreditNoteDocumentReference(\StructType\DocumentReference $creditNoteDocumentReference = null)
    {
        if (is_null($creditNoteDocumentReference) || (is_array($creditNoteDocumentReference) && empty($creditNoteDocumentReference))) {
            unset($this->CreditNoteDocumentReference);
        } else {
            $this->CreditNoteDocumentReference = $creditNoteDocumentReference;
        }
        return $this;
    }
    /**
     * Get DebitNoteDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getDebitNoteDocumentReference()
    {
        return isset($this->DebitNoteDocumentReference) ? $this->DebitNoteDocumentReference : null;
    }
    /**
     * Set DebitNoteDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $debitNoteDocumentReference
     * @return \StructType\BillingReference
     */
    public function setDebitNoteDocumentReference(\StructType\DocumentReference $debitNoteDocumentReference = null)
    {
        if (is_null($debitNoteDocumentReference) || (is_array($debitNoteDocumentReference) && empty($debitNoteDocumentReference))) {
            unset($this->DebitNoteDocumentReference);
        } else {
            $this->DebitNoteDocumentReference = $debitNoteDocumentReference;
        }
        return $this;
    }
    /**
     * Get InvoiceDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getInvoiceDocumentReference()
    {
        return isset($this->InvoiceDocumentReference) ? $this->InvoiceDocumentReference : null;
    }
    /**
     * Set InvoiceDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $invoiceDocumentReference
     * @return \StructType\BillingReference
     */
    public function setInvoiceDocumentReference(\StructType\DocumentReference $invoiceDocumentReference = null)
    {
        if (is_null($invoiceDocumentReference) || (is_array($invoiceDocumentReference) && empty($invoiceDocumentReference))) {
            unset($this->InvoiceDocumentReference);
        } else {
            $this->InvoiceDocumentReference = $invoiceDocumentReference;
        }
        return $this;
    }
    /**
     * Get ReminderDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getReminderDocumentReference()
    {
        return isset($this->ReminderDocumentReference) ? $this->ReminderDocumentReference : null;
    }
    /**
     * Set ReminderDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $reminderDocumentReference
     * @return \StructType\BillingReference
     */
    public function setReminderDocumentReference(\StructType\DocumentReference $reminderDocumentReference = null)
    {
        if (is_null($reminderDocumentReference) || (is_array($reminderDocumentReference) && empty($reminderDocumentReference))) {
            unset($this->ReminderDocumentReference);
        } else {
            $this->ReminderDocumentReference = $reminderDocumentReference;
        }
        return $this;
    }
    /**
     * Get SelfBilledInvoiceDocumentReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DocumentReference|null
     */
    public function getSelfBilledInvoiceDocumentReference()
    {
        return isset($this->SelfBilledInvoiceDocumentReference) ? $this->SelfBilledInvoiceDocumentReference : null;
    }
    /**
     * Set SelfBilledInvoiceDocumentReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\DocumentReference $selfBilledInvoiceDocumentReference
     * @return \StructType\BillingReference
     */
    public function setSelfBilledInvoiceDocumentReference(\StructType\DocumentReference $selfBilledInvoiceDocumentReference = null)
    {
        if (is_null($selfBilledInvoiceDocumentReference) || (is_array($selfBilledInvoiceDocumentReference) && empty($selfBilledInvoiceDocumentReference))) {
            unset($this->SelfBilledInvoiceDocumentReference);
        } else {
            $this->SelfBilledInvoiceDocumentReference = $selfBilledInvoiceDocumentReference;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BillingReference
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
