<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Attachment StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Attachment
 * @subpackage Structs
 */
class Attachment extends AbstractStructBase
{
    /**
     * The EmbeddedDocumentBinaryObject
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmbeddedDocumentBinaryObject;
    /**
     * The ExternalReference
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalReference;
    /**
     * The FileName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The MimeCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MimeCode;
    /**
     * Constructor method for Attachment
     * @uses Attachment::setEmbeddedDocumentBinaryObject()
     * @uses Attachment::setExternalReference()
     * @uses Attachment::setFileName()
     * @uses Attachment::setMimeCode()
     * @param string $embeddedDocumentBinaryObject
     * @param string $externalReference
     * @param string $fileName
     * @param string $mimeCode
     */
    public function __construct($embeddedDocumentBinaryObject = null, $externalReference = null, $fileName = null, $mimeCode = null)
    {
        $this
            ->setEmbeddedDocumentBinaryObject($embeddedDocumentBinaryObject)
            ->setExternalReference($externalReference)
            ->setFileName($fileName)
            ->setMimeCode($mimeCode);
    }
    /**
     * Get EmbeddedDocumentBinaryObject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmbeddedDocumentBinaryObject()
    {
        return isset($this->EmbeddedDocumentBinaryObject) ? $this->EmbeddedDocumentBinaryObject : null;
    }
    /**
     * Set EmbeddedDocumentBinaryObject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $embeddedDocumentBinaryObject
     * @return \StructType\Attachment
     */
    public function setEmbeddedDocumentBinaryObject($embeddedDocumentBinaryObject = null)
    {
        // validation for constraint: string
        if (!is_null($embeddedDocumentBinaryObject) && !is_string($embeddedDocumentBinaryObject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($embeddedDocumentBinaryObject, true), gettype($embeddedDocumentBinaryObject)), __LINE__);
        }
        if (is_null($embeddedDocumentBinaryObject) || (is_array($embeddedDocumentBinaryObject) && empty($embeddedDocumentBinaryObject))) {
            unset($this->EmbeddedDocumentBinaryObject);
        } else {
            $this->EmbeddedDocumentBinaryObject = $embeddedDocumentBinaryObject;
        }
        return $this;
    }
    /**
     * Get ExternalReference value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalReference()
    {
        return isset($this->ExternalReference) ? $this->ExternalReference : null;
    }
    /**
     * Set ExternalReference value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalReference
     * @return \StructType\Attachment
     */
    public function setExternalReference($externalReference = null)
    {
        // validation for constraint: string
        if (!is_null($externalReference) && !is_string($externalReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalReference, true), gettype($externalReference)), __LINE__);
        }
        if (is_null($externalReference) || (is_array($externalReference) && empty($externalReference))) {
            unset($this->ExternalReference);
        } else {
            $this->ExternalReference = $externalReference;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \StructType\Attachment
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get MimeCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMimeCode()
    {
        return isset($this->MimeCode) ? $this->MimeCode : null;
    }
    /**
     * Set MimeCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mimeCode
     * @return \StructType\Attachment
     */
    public function setMimeCode($mimeCode = null)
    {
        // validation for constraint: string
        if (!is_null($mimeCode) && !is_string($mimeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mimeCode, true), gettype($mimeCode)), __LINE__);
        }
        if (is_null($mimeCode) || (is_array($mimeCode) && empty($mimeCode))) {
            unset($this->MimeCode);
        } else {
            $this->MimeCode = $mimeCode;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Attachment
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
