<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AllowanceCharge StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AllowanceCharge
 * @subpackage Structs
 */
class AllowanceCharge extends AbstractStructBase
{
    /**
     * The AllowanceChargeReason
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowanceChargeReason;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $Amount;
    /**
     * The BaseAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $BaseAmount;
    /**
     * The ChargeIndicator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ChargeIndicator;
    /**
     * The MultiplierFactorNumeric
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $MultiplierFactorNumeric;
    /**
     * The PerUnitAmount
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Amount
     */
    public $PerUnitAmount;
    /**
     * The SequenceNumeric
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $SequenceNumeric;
    /**
     * Constructor method for AllowanceCharge
     * @uses AllowanceCharge::setAllowanceChargeReason()
     * @uses AllowanceCharge::setAmount()
     * @uses AllowanceCharge::setBaseAmount()
     * @uses AllowanceCharge::setChargeIndicator()
     * @uses AllowanceCharge::setMultiplierFactorNumeric()
     * @uses AllowanceCharge::setPerUnitAmount()
     * @uses AllowanceCharge::setSequenceNumeric()
     * @param string $allowanceChargeReason
     * @param \StructType\Amount $amount
     * @param \StructType\Amount $baseAmount
     * @param bool $chargeIndicator
     * @param float $multiplierFactorNumeric
     * @param \StructType\Amount $perUnitAmount
     * @param float $sequenceNumeric
     */
    public function __construct($allowanceChargeReason = null, \StructType\Amount $amount = null, \StructType\Amount $baseAmount = null, $chargeIndicator = null, $multiplierFactorNumeric = null, \StructType\Amount $perUnitAmount = null, $sequenceNumeric = null)
    {
        $this
            ->setAllowanceChargeReason($allowanceChargeReason)
            ->setAmount($amount)
            ->setBaseAmount($baseAmount)
            ->setChargeIndicator($chargeIndicator)
            ->setMultiplierFactorNumeric($multiplierFactorNumeric)
            ->setPerUnitAmount($perUnitAmount)
            ->setSequenceNumeric($sequenceNumeric);
    }
    /**
     * Get AllowanceChargeReason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowanceChargeReason()
    {
        return isset($this->AllowanceChargeReason) ? $this->AllowanceChargeReason : null;
    }
    /**
     * Set AllowanceChargeReason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowanceChargeReason
     * @return \StructType\AllowanceCharge
     */
    public function setAllowanceChargeReason($allowanceChargeReason = null)
    {
        // validation for constraint: string
        if (!is_null($allowanceChargeReason) && !is_string($allowanceChargeReason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowanceChargeReason, true), gettype($allowanceChargeReason)), __LINE__);
        }
        if (is_null($allowanceChargeReason) || (is_array($allowanceChargeReason) && empty($allowanceChargeReason))) {
            unset($this->AllowanceChargeReason);
        } else {
            $this->AllowanceChargeReason = $allowanceChargeReason;
        }
        return $this;
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $amount
     * @return \StructType\AllowanceCharge
     */
    public function setAmount(\StructType\Amount $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BaseAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getBaseAmount()
    {
        return isset($this->BaseAmount) ? $this->BaseAmount : null;
    }
    /**
     * Set BaseAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $baseAmount
     * @return \StructType\AllowanceCharge
     */
    public function setBaseAmount(\StructType\Amount $baseAmount = null)
    {
        if (is_null($baseAmount) || (is_array($baseAmount) && empty($baseAmount))) {
            unset($this->BaseAmount);
        } else {
            $this->BaseAmount = $baseAmount;
        }
        return $this;
    }
    /**
     * Get ChargeIndicator value
     * @return bool|null
     */
    public function getChargeIndicator()
    {
        return $this->ChargeIndicator;
    }
    /**
     * Set ChargeIndicator value
     * @param bool $chargeIndicator
     * @return \StructType\AllowanceCharge
     */
    public function setChargeIndicator($chargeIndicator = null)
    {
        // validation for constraint: boolean
        if (!is_null($chargeIndicator) && !is_bool($chargeIndicator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($chargeIndicator, true), gettype($chargeIndicator)), __LINE__);
        }
        $this->ChargeIndicator = $chargeIndicator;
        return $this;
    }
    /**
     * Get MultiplierFactorNumeric value
     * @return float|null
     */
    public function getMultiplierFactorNumeric()
    {
        return $this->MultiplierFactorNumeric;
    }
    /**
     * Set MultiplierFactorNumeric value
     * @param float $multiplierFactorNumeric
     * @return \StructType\AllowanceCharge
     */
    public function setMultiplierFactorNumeric($multiplierFactorNumeric = null)
    {
        // validation for constraint: float
        if (!is_null($multiplierFactorNumeric) && !(is_float($multiplierFactorNumeric) || is_numeric($multiplierFactorNumeric))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($multiplierFactorNumeric, true), gettype($multiplierFactorNumeric)), __LINE__);
        }
        $this->MultiplierFactorNumeric = $multiplierFactorNumeric;
        return $this;
    }
    /**
     * Get PerUnitAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Amount|null
     */
    public function getPerUnitAmount()
    {
        return isset($this->PerUnitAmount) ? $this->PerUnitAmount : null;
    }
    /**
     * Set PerUnitAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Amount $perUnitAmount
     * @return \StructType\AllowanceCharge
     */
    public function setPerUnitAmount(\StructType\Amount $perUnitAmount = null)
    {
        if (is_null($perUnitAmount) || (is_array($perUnitAmount) && empty($perUnitAmount))) {
            unset($this->PerUnitAmount);
        } else {
            $this->PerUnitAmount = $perUnitAmount;
        }
        return $this;
    }
    /**
     * Get SequenceNumeric value
     * @return float|null
     */
    public function getSequenceNumeric()
    {
        return $this->SequenceNumeric;
    }
    /**
     * Set SequenceNumeric value
     * @param float $sequenceNumeric
     * @return \StructType\AllowanceCharge
     */
    public function setSequenceNumeric($sequenceNumeric = null)
    {
        // validation for constraint: float
        if (!is_null($sequenceNumeric) && !(is_float($sequenceNumeric) || is_numeric($sequenceNumeric))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($sequenceNumeric, true), gettype($sequenceNumeric)), __LINE__);
        }
        $this->SequenceNumeric = $sequenceNumeric;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AllowanceCharge
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
