<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AirTransport StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AirTransport
 * @subpackage Structs
 */
class AirTransport extends AbstractStructBase
{
    /**
     * The AircraftID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AircraftID;
    /**
     * Constructor method for AirTransport
     * @uses AirTransport::setAircraftID()
     * @param string $aircraftID
     */
    public function __construct($aircraftID = null)
    {
        $this
            ->setAircraftID($aircraftID);
    }
    /**
     * Get AircraftID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAircraftID()
    {
        return isset($this->AircraftID) ? $this->AircraftID : null;
    }
    /**
     * Set AircraftID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aircraftID
     * @return \StructType\AirTransport
     */
    public function setAircraftID($aircraftID = null)
    {
        // validation for constraint: string
        if (!is_null($aircraftID) && !is_string($aircraftID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($aircraftID, true), gettype($aircraftID)), __LINE__);
        }
        if (is_null($aircraftID) || (is_array($aircraftID) && empty($aircraftID))) {
            unset($this->AircraftID);
        } else {
            $this->AircraftID = $aircraftID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AirTransport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
