<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AgentParty StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:AgentParty
 * @subpackage Structs
 */
class AgentParty extends AbstractStructBase
{
    /**
     * The Contact
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Contact
     */
    public $Contact;
    /**
     * The IndustryClassificationCode
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IndustryClassificationCode;
    /**
     * The PartyIdentifications
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfPartyIdentification
     */
    public $PartyIdentifications;
    /**
     * The PartyName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartyName;
    /**
     * The PartyTax
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PartyTax;
    /**
     * The Person
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Person
     */
    public $Person;
    /**
     * The PostalAddress
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Address
     */
    public $PostalAddress;
    /**
     * The WebsiteURI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WebsiteURI;
    /**
     * Constructor method for AgentParty
     * @uses AgentParty::setContact()
     * @uses AgentParty::setIndustryClassificationCode()
     * @uses AgentParty::setPartyIdentifications()
     * @uses AgentParty::setPartyName()
     * @uses AgentParty::setPartyTax()
     * @uses AgentParty::setPerson()
     * @uses AgentParty::setPostalAddress()
     * @uses AgentParty::setWebsiteURI()
     * @param \StructType\Contact $contact
     * @param string $industryClassificationCode
     * @param \ArrayType\ArrayOfPartyIdentification $partyIdentifications
     * @param string $partyName
     * @param string $partyTax
     * @param \StructType\Person $person
     * @param \StructType\Address $postalAddress
     * @param string $websiteURI
     */
    public function __construct(\StructType\Contact $contact = null, $industryClassificationCode = null, \ArrayType\ArrayOfPartyIdentification $partyIdentifications = null, $partyName = null, $partyTax = null, \StructType\Person $person = null, \StructType\Address $postalAddress = null, $websiteURI = null)
    {
        $this
            ->setContact($contact)
            ->setIndustryClassificationCode($industryClassificationCode)
            ->setPartyIdentifications($partyIdentifications)
            ->setPartyName($partyName)
            ->setPartyTax($partyTax)
            ->setPerson($person)
            ->setPostalAddress($postalAddress)
            ->setWebsiteURI($websiteURI);
    }
    /**
     * Get Contact value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Contact|null
     */
    public function getContact()
    {
        return isset($this->Contact) ? $this->Contact : null;
    }
    /**
     * Set Contact value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Contact $contact
     * @return \StructType\AgentParty
     */
    public function setContact(\StructType\Contact $contact = null)
    {
        if (is_null($contact) || (is_array($contact) && empty($contact))) {
            unset($this->Contact);
        } else {
            $this->Contact = $contact;
        }
        return $this;
    }
    /**
     * Get IndustryClassificationCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIndustryClassificationCode()
    {
        return isset($this->IndustryClassificationCode) ? $this->IndustryClassificationCode : null;
    }
    /**
     * Set IndustryClassificationCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $industryClassificationCode
     * @return \StructType\AgentParty
     */
    public function setIndustryClassificationCode($industryClassificationCode = null)
    {
        // validation for constraint: string
        if (!is_null($industryClassificationCode) && !is_string($industryClassificationCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($industryClassificationCode, true), gettype($industryClassificationCode)), __LINE__);
        }
        if (is_null($industryClassificationCode) || (is_array($industryClassificationCode) && empty($industryClassificationCode))) {
            unset($this->IndustryClassificationCode);
        } else {
            $this->IndustryClassificationCode = $industryClassificationCode;
        }
        return $this;
    }
    /**
     * Get PartyIdentifications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfPartyIdentification|null
     */
    public function getPartyIdentifications()
    {
        return isset($this->PartyIdentifications) ? $this->PartyIdentifications : null;
    }
    /**
     * Set PartyIdentifications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfPartyIdentification $partyIdentifications
     * @return \StructType\AgentParty
     */
    public function setPartyIdentifications(\ArrayType\ArrayOfPartyIdentification $partyIdentifications = null)
    {
        if (is_null($partyIdentifications) || (is_array($partyIdentifications) && empty($partyIdentifications))) {
            unset($this->PartyIdentifications);
        } else {
            $this->PartyIdentifications = $partyIdentifications;
        }
        return $this;
    }
    /**
     * Get PartyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyName()
    {
        return isset($this->PartyName) ? $this->PartyName : null;
    }
    /**
     * Set PartyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyName
     * @return \StructType\AgentParty
     */
    public function setPartyName($partyName = null)
    {
        // validation for constraint: string
        if (!is_null($partyName) && !is_string($partyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyName, true), gettype($partyName)), __LINE__);
        }
        if (is_null($partyName) || (is_array($partyName) && empty($partyName))) {
            unset($this->PartyName);
        } else {
            $this->PartyName = $partyName;
        }
        return $this;
    }
    /**
     * Get PartyTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPartyTax()
    {
        return isset($this->PartyTax) ? $this->PartyTax : null;
    }
    /**
     * Set PartyTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $partyTax
     * @return \StructType\AgentParty
     */
    public function setPartyTax($partyTax = null)
    {
        // validation for constraint: string
        if (!is_null($partyTax) && !is_string($partyTax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($partyTax, true), gettype($partyTax)), __LINE__);
        }
        if (is_null($partyTax) || (is_array($partyTax) && empty($partyTax))) {
            unset($this->PartyTax);
        } else {
            $this->PartyTax = $partyTax;
        }
        return $this;
    }
    /**
     * Get Person value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Person|null
     */
    public function getPerson()
    {
        return isset($this->Person) ? $this->Person : null;
    }
    /**
     * Set Person value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Person $person
     * @return \StructType\AgentParty
     */
    public function setPerson(\StructType\Person $person = null)
    {
        if (is_null($person) || (is_array($person) && empty($person))) {
            unset($this->Person);
        } else {
            $this->Person = $person;
        }
        return $this;
    }
    /**
     * Get PostalAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Address|null
     */
    public function getPostalAddress()
    {
        return isset($this->PostalAddress) ? $this->PostalAddress : null;
    }
    /**
     * Set PostalAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Address $postalAddress
     * @return \StructType\AgentParty
     */
    public function setPostalAddress(\StructType\Address $postalAddress = null)
    {
        if (is_null($postalAddress) || (is_array($postalAddress) && empty($postalAddress))) {
            unset($this->PostalAddress);
        } else {
            $this->PostalAddress = $postalAddress;
        }
        return $this;
    }
    /**
     * Get WebsiteURI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWebsiteURI()
    {
        return isset($this->WebsiteURI) ? $this->WebsiteURI : null;
    }
    /**
     * Set WebsiteURI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $websiteURI
     * @return \StructType\AgentParty
     */
    public function setWebsiteURI($websiteURI = null)
    {
        // validation for constraint: string
        if (!is_null($websiteURI) && !is_string($websiteURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($websiteURI, true), gettype($websiteURI)), __LINE__);
        }
        if (is_null($websiteURI) || (is_array($websiteURI) && empty($websiteURI))) {
            unset($this->WebsiteURI);
        } else {
            $this->WebsiteURI = $websiteURI;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AgentParty
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
