<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Address StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:Address
 * @subpackage Structs
 */
class Address extends AbstractStructBase
{
    /**
     * The BlockName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BlockName;
    /**
     * The BuildingName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingName;
    /**
     * The BuildingNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BuildingNumber;
    /**
     * The CityName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CityName;
    /**
     * The CitySubdivisionName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CitySubdivisionName;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Country
     */
    public $Country;
    /**
     * The District
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $District;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ID;
    /**
     * The PostBox
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostBox;
    /**
     * The PostalZone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PostalZone;
    /**
     * The Region
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Region;
    /**
     * The Room
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Room;
    /**
     * The StreetName
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StreetName;
    /**
     * Constructor method for Address
     * @uses Address::setBlockName()
     * @uses Address::setBuildingName()
     * @uses Address::setBuildingNumber()
     * @uses Address::setCityName()
     * @uses Address::setCitySubdivisionName()
     * @uses Address::setCountry()
     * @uses Address::setDistrict()
     * @uses Address::setID()
     * @uses Address::setPostBox()
     * @uses Address::setPostalZone()
     * @uses Address::setRegion()
     * @uses Address::setRoom()
     * @uses Address::setStreetName()
     * @param string $blockName
     * @param string $buildingName
     * @param string $buildingNumber
     * @param string $cityName
     * @param string $citySubdivisionName
     * @param \StructType\Country $country
     * @param string $district
     * @param string $iD
     * @param string $postBox
     * @param string $postalZone
     * @param string $region
     * @param string $room
     * @param string $streetName
     */
    public function __construct($blockName = null, $buildingName = null, $buildingNumber = null, $cityName = null, $citySubdivisionName = null, \StructType\Country $country = null, $district = null, $iD = null, $postBox = null, $postalZone = null, $region = null, $room = null, $streetName = null)
    {
        $this
            ->setBlockName($blockName)
            ->setBuildingName($buildingName)
            ->setBuildingNumber($buildingNumber)
            ->setCityName($cityName)
            ->setCitySubdivisionName($citySubdivisionName)
            ->setCountry($country)
            ->setDistrict($district)
            ->setID($iD)
            ->setPostBox($postBox)
            ->setPostalZone($postalZone)
            ->setRegion($region)
            ->setRoom($room)
            ->setStreetName($streetName);
    }
    /**
     * Get BlockName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBlockName()
    {
        return isset($this->BlockName) ? $this->BlockName : null;
    }
    /**
     * Set BlockName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $blockName
     * @return \StructType\Address
     */
    public function setBlockName($blockName = null)
    {
        // validation for constraint: string
        if (!is_null($blockName) && !is_string($blockName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($blockName, true), gettype($blockName)), __LINE__);
        }
        if (is_null($blockName) || (is_array($blockName) && empty($blockName))) {
            unset($this->BlockName);
        } else {
            $this->BlockName = $blockName;
        }
        return $this;
    }
    /**
     * Get BuildingName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingName()
    {
        return isset($this->BuildingName) ? $this->BuildingName : null;
    }
    /**
     * Set BuildingName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingName
     * @return \StructType\Address
     */
    public function setBuildingName($buildingName = null)
    {
        // validation for constraint: string
        if (!is_null($buildingName) && !is_string($buildingName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingName, true), gettype($buildingName)), __LINE__);
        }
        if (is_null($buildingName) || (is_array($buildingName) && empty($buildingName))) {
            unset($this->BuildingName);
        } else {
            $this->BuildingName = $buildingName;
        }
        return $this;
    }
    /**
     * Get BuildingNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBuildingNumber()
    {
        return isset($this->BuildingNumber) ? $this->BuildingNumber : null;
    }
    /**
     * Set BuildingNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $buildingNumber
     * @return \StructType\Address
     */
    public function setBuildingNumber($buildingNumber = null)
    {
        // validation for constraint: string
        if (!is_null($buildingNumber) && !is_string($buildingNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($buildingNumber, true), gettype($buildingNumber)), __LINE__);
        }
        if (is_null($buildingNumber) || (is_array($buildingNumber) && empty($buildingNumber))) {
            unset($this->BuildingNumber);
        } else {
            $this->BuildingNumber = $buildingNumber;
        }
        return $this;
    }
    /**
     * Get CityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCityName()
    {
        return isset($this->CityName) ? $this->CityName : null;
    }
    /**
     * Set CityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cityName
     * @return \StructType\Address
     */
    public function setCityName($cityName = null)
    {
        // validation for constraint: string
        if (!is_null($cityName) && !is_string($cityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityName, true), gettype($cityName)), __LINE__);
        }
        if (is_null($cityName) || (is_array($cityName) && empty($cityName))) {
            unset($this->CityName);
        } else {
            $this->CityName = $cityName;
        }
        return $this;
    }
    /**
     * Get CitySubdivisionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCitySubdivisionName()
    {
        return isset($this->CitySubdivisionName) ? $this->CitySubdivisionName : null;
    }
    /**
     * Set CitySubdivisionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $citySubdivisionName
     * @return \StructType\Address
     */
    public function setCitySubdivisionName($citySubdivisionName = null)
    {
        // validation for constraint: string
        if (!is_null($citySubdivisionName) && !is_string($citySubdivisionName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citySubdivisionName, true), gettype($citySubdivisionName)), __LINE__);
        }
        if (is_null($citySubdivisionName) || (is_array($citySubdivisionName) && empty($citySubdivisionName))) {
            unset($this->CitySubdivisionName);
        } else {
            $this->CitySubdivisionName = $citySubdivisionName;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Country|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Country $country
     * @return \StructType\Address
     */
    public function setCountry(\StructType\Country $country = null)
    {
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get District value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistrict()
    {
        return isset($this->District) ? $this->District : null;
    }
    /**
     * Set District value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $district
     * @return \StructType\Address
     */
    public function setDistrict($district = null)
    {
        // validation for constraint: string
        if (!is_null($district) && !is_string($district)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($district, true), gettype($district)), __LINE__);
        }
        if (is_null($district) || (is_array($district) && empty($district))) {
            unset($this->District);
        } else {
            $this->District = $district;
        }
        return $this;
    }
    /**
     * Get ID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getID()
    {
        return isset($this->ID) ? $this->ID : null;
    }
    /**
     * Set ID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iD
     * @return \StructType\Address
     */
    public function setID($iD = null)
    {
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        if (is_null($iD) || (is_array($iD) && empty($iD))) {
            unset($this->ID);
        } else {
            $this->ID = $iD;
        }
        return $this;
    }
    /**
     * Get PostBox value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostBox()
    {
        return isset($this->PostBox) ? $this->PostBox : null;
    }
    /**
     * Set PostBox value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postBox
     * @return \StructType\Address
     */
    public function setPostBox($postBox = null)
    {
        // validation for constraint: string
        if (!is_null($postBox) && !is_string($postBox)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postBox, true), gettype($postBox)), __LINE__);
        }
        if (is_null($postBox) || (is_array($postBox) && empty($postBox))) {
            unset($this->PostBox);
        } else {
            $this->PostBox = $postBox;
        }
        return $this;
    }
    /**
     * Get PostalZone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPostalZone()
    {
        return isset($this->PostalZone) ? $this->PostalZone : null;
    }
    /**
     * Set PostalZone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $postalZone
     * @return \StructType\Address
     */
    public function setPostalZone($postalZone = null)
    {
        // validation for constraint: string
        if (!is_null($postalZone) && !is_string($postalZone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($postalZone, true), gettype($postalZone)), __LINE__);
        }
        if (is_null($postalZone) || (is_array($postalZone) && empty($postalZone))) {
            unset($this->PostalZone);
        } else {
            $this->PostalZone = $postalZone;
        }
        return $this;
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $region
     * @return \StructType\Address
     */
    public function setRegion($region = null)
    {
        // validation for constraint: string
        if (!is_null($region) && !is_string($region)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($region, true), gettype($region)), __LINE__);
        }
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Get Room value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRoom()
    {
        return isset($this->Room) ? $this->Room : null;
    }
    /**
     * Set Room value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $room
     * @return \StructType\Address
     */
    public function setRoom($room = null)
    {
        // validation for constraint: string
        if (!is_null($room) && !is_string($room)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($room, true), gettype($room)), __LINE__);
        }
        if (is_null($room) || (is_array($room) && empty($room))) {
            unset($this->Room);
        } else {
            $this->Room = $room;
        }
        return $this;
    }
    /**
     * Get StreetName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStreetName()
    {
        return isset($this->StreetName) ? $this->StreetName : null;
    }
    /**
     * Set StreetName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $streetName
     * @return \StructType\Address
     */
    public function setStreetName($streetName = null)
    {
        // validation for constraint: string
        if (!is_null($streetName) && !is_string($streetName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($streetName, true), gettype($streetName)), __LINE__);
        }
        if (is_null($streetName) || (is_array($streetName) && empty($streetName))) {
            unset($this->StreetName);
        } else {
            $this->StreetName = $streetName;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Address
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
