<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Return ServiceType
 * @subpackage Services
 */
class _Return extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReturnInvoiceWithKEP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReturnInvoiceWithKEP $parameters
     * @return \StructType\ReturnInvoiceWithKEPResponse|bool
     */
    public function ReturnInvoiceWithKEP(\StructType\ReturnInvoiceWithKEP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReturnInvoiceWithKEP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReturnInvoiceWithKEPResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
