<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reply ServiceType
 * @subpackage Services
 */
class Reply extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReplyInvoices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReplyInvoices $parameters
     * @return \StructType\ReplyInvoicesResponse|bool
     */
    public function ReplyInvoices(\StructType\ReplyInvoices $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReplyInvoices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReplyInvoicesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
