<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Reconciliation ServiceType
 * @subpackage Services
 */
class Reconciliation extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ReconciliationInquiry
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ReconciliationInquiry $parameters
     * @return \StructType\ReconciliationInquiryResponse|bool
     */
    public function ReconciliationInquiry(\StructType\ReconciliationInquiry $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ReconciliationInquiry($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ReconciliationInquiryResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
