<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Preview ServiceType
 * @subpackage Services
 */
class Preview extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named PreviewInvoice
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewInvoice $parameters
     * @return \StructType\PreviewInvoiceResponse|bool
     */
    public function PreviewInvoice(\StructType\PreviewInvoice $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PreviewInvoice($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named PreviewInvoiceRaw
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\PreviewInvoiceRaw $parameters
     * @return \StructType\PreviewInvoiceRawResponse|bool
     */
    public function PreviewInvoiceRaw(\StructType\PreviewInvoiceRaw $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->PreviewInvoiceRaw($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\PreviewInvoiceRawResponse|\StructType\PreviewInvoiceResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
